/*   call C_HST_RECON_OVERSLICES(display_graphics, output_id, & */
/*   oversampling, start_x, start_y, num_x, num_y, & */
/*   second_slice, third_slice, fourth_slice, & */
/*   axis_position, angle_offset, angle_increment, first_slice, last_slice, & */
/*   num_bins, num_projections, dim_slices, num_slices, SINOGRAMS, & */
/*   time_cpu_filter, time_elapse_filter, time_cpu_back, time_elapse_back, & */
/*   time_cpu_slices, time_elapse_slices, & */
/*   time_cpu_output, time_elapse_output, & */
/*   SLICE, SLICE2, SLICE3, SLICE4, record, status) */


#include"Python.h"
#include"structmember.h"
#include<string.h>

#include "Numeric/arrayobject.h"

#ifdef LINUX
 #define _FILE_OFFSET_BITS  64
#endif


#define DEBUG(a)


int C_HST_RECON_OVERSLICES(
  FILE *output,              /*  Identifier for file outp   */ 
  int *oversampling,           /*  0 = Linear, 1 = Nearest pixel,         */
                               /*  2, 3, etc. equal over-sampling factor  */ 
  int *start_x,                /* First X-pixel in region required by user    */
  int *start_y,                /* First Y-pixel in region required by user    */
  int *num_x,                  /* Number of X-pixels in reconstruction region */
  int *num_y,                  /* Number of Y-pixels in reconstruction region */
  float *axis_position,        /* Position of rotation axis */
  float *angle_offset,         /* Offset rotation angle in radians */
  float *angle_increment,      /* Angle in radians between each */
  int *first_slice,            /* First slice to treat*/
  int *last_slice,             /* Last slice to treat*/
  int *num_bins,               /* Number of bins in each sinogram  */
  int *num_projections,        /* Number of projections in  each sinogram */
  int *dim_slices,             /* Slice dimension (3rd) of sinogram  */
  int *num_slices,             /* Number of sinograms in sinogram array  */
  int *no_filtering,		   /* sinogram previously filtered if set */
  int *nthreads,
  float *SINOGRAMS,            /* Storage for the sinogram. Dimensions:  */
                               /* (num_bins,num_projections,dim_slices)  */

  /*
   * SLICE : Storage for a reconstructed slice.
   * Dimension(num_x,num_y)
  */
  float *SLICE, 
  int *status ,                 /* Status return variable */
  int *memory     /* 0 writes on file, 1 no write on file */
  );





/*
 * The error object to expose 
 */

static PyObject *ErrorObject;
#define onError(message)\
  { PyErr_SetString(ErrorObject, message); return NULL;}



/*
 * structure of an edfobject
 */

typedef struct {
  PyObject_HEAD
  FILE *output;              /*  Identifier for file outp   */ 
  int oversampling;           /*  0 = Linear, 1 = Nearest pixel,         */
                               /*  2, 3, etc. equal over-sampling factor  */ 
  int start_x;                /* First X-pixel in region required by user    */
  int start_y;                /* First Y-pixel in region required by user    */
  int num_x;                  /* Number of X-pixels in reconstruction region */
  int num_y;                  /* Number of Y-pixels in reconstruction region */
  float axis_position;        /* Position of rotation axis */
  float angle_offset;         /* Offset rotation angle in radians */
  float angle_increment;      /* Angle in radians between each */
  int no_filtering;	  /* is 1 to skip the sinogram filtering */
  int num_bins;               /* Number of bins in each sinogram  */
  int num_projections;        /* Number of projections in  each sinogram */
  PyObject *SINOGRAMS;            /* Storage for the sinogram. Dimensions:  */
                               /* (num_bins,num_projections,dim_slices)  */
} PyHST;

staticforward PyTypeObject PyHSTtype;

#define is_PyHST(v) ((v)->ob_type == &tPyHSType )


/*
 * kinf of destructor called by garbage collector
 */
static void
PyHST_dealloc(PyHST *self)
{
  DEBUG("... going to destroy an PyHST ...")
  Py_XDECREF(self->SINOGRAMS);

  if(self)
    free(self);
  DEBUG("... going to destroy an PyHST ... OK")
}

/*
 * creation and initialization of a new 
 */
static char PyHST_new_doc[]="

/*
 * creation and initialization of a new PyHST. Lots of arguments:
  if(!PyArg_ParseTuple(args,\"siiiiifffiiiO:PyHST_new\", &outputname, &(res->oversampling),&(res->start_x),&(res->start_y),
		       &(res->num_x),&(res->num_y),
		       &(res->axis_position),&(res->angle_offset),&(res->angle_increment),
			   &(res->no_filtering),
		       &(res->num_bins),&(res->num_projections),
		       &(res->SINOGRAMS)))
    return NULL;
   */
";
static PyObject *
PyHST_new( PyObject *self, PyObject *args)
     /* return a new instance of edfobject */
{
  PyHST* res;
  char * outputname;

  res= (PyHST*) PyObject_NEW(PyHST, &PyHSTtype);


  if(!PyArg_ParseTuple(args,"siiiiifffiiiO:PyHST_new", &outputname, &(res->oversampling),&(res->start_x),&(res->start_y),
		       &(res->num_x),&(res->num_y),
		       &(res->axis_position),&(res->angle_offset),&(res->angle_increment),
			   &(res->no_filtering),
		       &(res->num_bins),&(res->num_projections),
		       &(res->SINOGRAMS)))
    return NULL;

  if(strlen(outputname)>0){  
    res->output=fopen(outputname,"w");
    if(!res->output) {
      printf("ERROR : could not open file %s\n", outputname);
      return NULL;
    }
  }
  
  Py_INCREF(res->SINOGRAMS);

  return (PyObject*) res;
}



static char PyHST_calcSlices_doc[]="
/* calculate a number of slices given as argument
  Takes two arguments : 
if(!PyArg_ParseTuple(args,\"ii:PyHST_calcSlices\", &num_slices, &nthreads))
    return NULL;

 */
";

static PyObject *
PyHST_calcSlices(PyObject *self_a, PyObject *args)
{
  int num_slices;
  int nthreads;
  int status;
  float *SLICE;
  int first_slice;
  int last_slice;
  int dim_slices; 
  PyHST *self;
  int memory;
  first_slice=0;


  self = (PyHST *) self_a;

  if(!PyArg_ParseTuple(args,"ii:PyHST_calcSlices", &num_slices, &nthreads))
    return NULL;

  last_slice=first_slice+num_slices-1;

  SLICE=malloc( self->num_x*self->num_y*sizeof(float) );
  memory = 0;
  C_HST_RECON_OVERSLICES(self->output,
                         &self->oversampling,
			 &self->start_x,
			 &self->start_y,
			 &self->num_x,
			 &self->num_y,
			 &self->axis_position,
			 &self->angle_offset, 
			 &self->angle_increment,
			 &first_slice, 
			 &last_slice,
			 &self->num_bins,
			 &self->num_projections,
			 &dim_slices,
			 &num_slices,
			 &self->no_filtering,
			 &nthreads,
			 (float*) ((PyArrayObject *) self->SINOGRAMS)->data,
                         SLICE,
                         &status,
			 &memory);
 
  free(SLICE);
  Py_INCREF( Py_None);
  return Py_None;
}

static char PyHST_calcSlicesMemory_doc[]="
/* calculate a number of slices given as argument
  Takes three arguments : 
if(!PyArg_ParseTuple(args,\"iiO:PyHST_calcSlices\", &num_slices, &nthreads, &Oslice))
    return NULL;

 */
";
static PyObject *
PyHST_calcSlicesMemory(PyObject *self_a, PyObject *args)
{
  int num_slices;
  int nthreads;
  int status;
  float *SLICE;
  int first_slice;
  int last_slice;
  int dim_slices; 
  PyHST *self;
  PyArrayObject * Oslice ; 
  int memory;
  first_slice=0;

  self = (PyHST *) self_a;

  if(!PyArg_ParseTuple(args,"iiO:PyHST_calcSlices", &num_slices, &nthreads, &Oslice )  )  
    return NULL;

  last_slice=first_slice+num_slices-1;

  SLICE= (float * )   Oslice ->data;
  /* malloc( self->num_x*self->num_y*sizeof(float) );*/
  memory=1;
  C_HST_RECON_OVERSLICES(self->output,
                         &self->oversampling,
			 &self->start_x,
			 &self->start_y,
			 &self->num_x,
			 &self->num_y,
			 &self->axis_position,
			 &self->angle_offset, 
			 &self->angle_increment,
			 &first_slice, 
			 &last_slice,
			 &self->num_bins,
			 &self->num_projections,
			 &dim_slices,
			 &num_slices,
			 &self->no_filtering,
			 &nthreads,
			 (float*) ((PyArrayObject *) self->SINOGRAMS)->data,
                         SLICE,
                         &status,
			 &memory);
 
  /* free(SLICE); */
  Py_INCREF( Py_None);
  return Py_None;
}

static PyMethodDef PyHST_methods[]={
  {"calcSlices",(PyCFunction) PyHST_calcSlices, METH_VARARGS,PyHST_calcSlices_doc},
  {"calcSlicesMemory",(PyCFunction) PyHST_calcSlicesMemory, METH_VARARGS,PyHST_calcSlicesMemory_doc},
  { NULL, NULL}
};


static struct memberlist PyHST_memberlist[]={
    { NULL }
};

static PyMethodDef PyHST_functions[] = {
  {"PyHST", PyHST_new, METH_VARARGS, PyHST_new_doc},
  { NULL, NULL}
};



static PyObject *
PyHST_getattr(PyHST *self, char *attr) 
{
  PyObject *res;

  res= Py_FindMethod(PyHST_methods, (PyObject*) self, attr);
  if(NULL !=res)
    return res;
  else {
    PyErr_Clear();
    return PyMember_Get((char*) self,PyHST_memberlist, attr);
  }
}



void 
initPyHST_c()
{
  PyObject *m, *d;
  m = Py_InitModule("PyHST_c", PyHST_functions);
  d = PyModule_GetDict(m);
  ErrorObject = Py_BuildValue("s","PyHST_c.error");
  PyDict_SetItemString(d,"error", ErrorObject);
  if(PyErr_Occurred())
    Py_FatalError("can't initialize module PyHST_c");

#ifdef import_array
  import_array();
#endif
}



static PyTypeObject PyHSTtype = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "PyHST",
  sizeof(PyHST),
  0,
  (destructor) PyHST_dealloc,
  0,
  (getattrfunc) PyHST_getattr,
};






#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <semaphore.h>



#include <pthread.h>

#ifdef SOLARIS
#include <thread.h> 
#endif


#define ARG(a) (*a)

#define use_c_recon 




int C_HST_RECON_1OVER(
   int *num_bins,        /* Number of bins in each sinogram  */
   int *num_projections, /* Number of projections in  each sinogram */
   int *oversampling,    /*  0 = Linear, 1 = Nearestpixel,
                             2, 3, etc. equal over-sampling factor  */ 
   int *start_x,         /* First X-pixel in region required by user    */
   int *start_y,         /* First Y-pixel in region required by user    */
   int *num_x,           /* Number of X-pixels in reconstruction region */
   int *num_y,           /* Number of Y-pixels in reconstruction region */
   int *y_start, 
   int *y_end,
   int *X_STARTS,   /* X_Start tells the limits for each y ( idem for X_ENDS) */
   int *X_ENDS,
   float* angle_offset,
   float* angle_increment,
   float* axis_position,
   int *dim_exponts,
   float  *EXPONENTS, 
   int    *dim_fft,
   float  *FILTER,
   int *dim_over,
   float* SINOGRAMS ,
   float *time_cpu_filter, 
   float *time_elapse_filter, 
   float *time_cpu_back,
   float *time_elapse_back, 
   float *SLICE,
   float *OVERSAMPLE,
   float *WORK,
   int *status,
   int nthreads,
   int thread,
   sem_t *sema,
   sem_t *semb
   );


int hst_calculate_limits__(int * num_bins__,int *  start_x__, int * start_y__, 
	int * num_x__, int * num_y__, float *axis_position__, int * y_start__, int * y_end__, int * x_starts__, 
			   int * x_ends__, int * status);

    
void C_HST_EXPNT(int dim_exponts,int dim_fft2,int radix,float *EXPONENTS,
  int *status)
{
  int hst_expnt__(int *maxdat,int * numdat,int * jump,float  *twiddle, int *status);

  hst_expnt__(&dim_exponts,&dim_fft2,&radix,EXPONENTS,status);
}
   
void check_alloc(void *ptr,char *msg )
{
  if(!ptr) {
    printf(" failed allocations of array %s \n", msg);
    printf(" Program stops. Bye \n");
    exit(0);
  }
} 

void MESSAGE(char * s )
{
  printf(" ROUTINE C_HST_RECON_OVERSLICES %s", s);
}

/********************************************************

 The following  structure is passed to the threaded routines.
 The thread mechanism allows to specify a function and
 a pointer to a variable. in our case this pointer
 points to an object the following structure
 where all the arguments are specified.

 Ptr are all the old arguments for hst-recon_1over.
 sema, semb are semaphore to synchronise the threads
 nthreads is the number of threads.
 thread will be 0,1... for thread 0,1,.. respectively
************************************************************/

typedef struct Args {
  void * ptr[40]; 
  sem_t *sema;
  sem_t *semb;
  int nthreads;
  int thread;
} arg;


/*  void sort2(long n,float *arr,float * brr); */

/*************************************************************
  the following routine will be launched in parallel
  by the thread mechanism
*************************************************************/

void *start_routine(void  *ar)
{
  arg *args = (arg *)ar;
  C_HST_RECON_1OVER( 
    (*args).ptr[0],
    (*args).ptr[1],
    (*args).ptr[2],
    (*args).ptr[3],
    (*args).ptr[4],
    (*args).ptr[5],
    (*args).ptr[6],
    (*args).ptr[7],
    (*args).ptr[8],
    (*args).ptr[9],
    (*args).ptr[10],
    (*args).ptr[11],
    (*args).ptr[12],
    (*args).ptr[13],
    (*args).ptr[14],
    (*args).ptr[15],
    (*args).ptr[16],
    (*args).ptr[17],
    (*args).ptr[18],
    (*args).ptr[19],
    (*args).ptr[20],
    (*args).ptr[21],
    (*args).ptr[22],
    (*args).ptr[23],
    (*args).ptr[24],
    (*args).ptr[25],
    (*args).ptr[26],
    (*args).ptr[27],
    (*args).nthreads,
    (*args).thread,
    (*args).sema,
    (*args).semb);
  return(0);
}




int C_HST_RECON_OVERSLICES(
  FILE *output,              /*  Identifier for file outp   */ 
  int *oversampling,           /*  0 = Linear, 1 = Nearest pixel,         */
                               /*  2, 3, etc. equal over-sampling factor  */ 
  int *start_x,                /* First X-pixel in region required by user    */
  int *start_y,                /* First Y-pixel in region required by user    */
  int *num_x,                  /* Number of X-pixels in reconstruction region */
  int *num_y,                  /* Number of Y-pixels in reconstruction region */
  float *axis_position,        /* Position of rotation axis */
  float *angle_offset,         /* Offset rotation angle in radians */
  float *angle_increment,      /* Angle in radians between each */
  int *first_slice,            /* First slice to treat*/
  int *last_slice,             /* Last slice to treat*/
  int *num_bins,               /* Number of bins in each sinogram  */
  int *num_projections,        /* Number of projections in  each sinogram */
  int *dim_slices,             /* Slice dimension (3rd) of sinogram  */
  int *num_slices,             /* Number of sinograms in sinogram array  */
  int *no_filtering,		   /* sinogram previously filtered if set */
  int *nthreads,
  float *SINOGRAMS,            /* Storage for the sinogram. Dimensions:  */
                               /* (num_bins,num_projections,dim_slices)  */
  /*
   * SLICE : Storage for a reconstructed slice.
   * Dimension(num_x,num_y)
  */
  float *SLICE, 
  int *status,                  /* Status return variable */
  int * memory
  )
{

  int two_power;
  int dim_fft;
  int dim_exponts;
  int i,j;
  int *X_STARTS, *X_ENDS;
  
  float *FILTER;
  float *EXPONENTS;
  float *WORK;

  int dim_over;
  float *OVERSAMPLE;

  int y_start;
  int y_end;
  float dum_time;


#ifdef use_c_recon

  sem_t sema, semb;

#define NMAXTHREAD 64
  
  pthread_t tid[NMAXTHREAD];
  arg ARGOMENTS[NMAXTHREAD];
  
  int ret;
  void *pstatus;
  

/*******************************************************************************
  The following variable specifies how many processors we are using.
  Look also set_concurrency of the sun library to get real concurrency
  with solaris
 ******************************************************************************/
  /*int nthreads = NTHREADS  ;*/
  int it;
#endif
  
  int num_slice;


  
  /* hard to understand why the -1 is there but it works nicely */
  
  two_power = (int)(log((2. * ARG(num_bins) - 1)) / log(2.0) + 0.9999);
  
  dim_fft = 1; for(i=0;i<two_power; i++) dim_fft*=2;
  
  dim_exponts = 2 * dim_fft;
  
  printf( " ARG(num_bins), two_power, dim_fft, dim_exponts %d %d %d %d\n",
    ARG(num_bins), two_power, dim_fft, dim_exponts);
  
  
  /*************************************************************
   * Depending on geometry ( dimensions, axis positions ....  )*
   * only a restraint part of the slice can be back projected  *
   * from all the sinograms.                                   *
   * X_Start tells the limits for each y  ( idem for X_ENDS)   *
   *************************************************************/
  X_STARTS = malloc(ARG(num_bins) * sizeof(int));
  check_alloc(X_STARTS," X_STARTS allocation in c_hst_recon_overslices");
  X_ENDS = malloc(ARG(num_bins) * sizeof(int));
  check_alloc(X_ENDS," X_ENDS allocation in c_hst_recon_overslices");
  
  
/*******************************************************************************
 * Takes care of fourier space
 ******************************************************************************/
  FILTER    = malloc((dim_fft) * sizeof(float));
  check_alloc(FILTER," FILTER allocation in c_hst_recon_overslices" );
  EXPONENTS = malloc((dim_exponts) * sizeof(float));
  check_alloc(EXPONENTS," EXPONENTS allocation in c_hst_recon_overslices" );
  WORK      = malloc((dim_fft) * sizeof(float));
  check_alloc(WORK," WORK allocation in c_hst_recon_overslices" ); 
  
/*******************************************************************************
 * Takes care of oversampling space
 ******************************************************************************/
  dim_over = ARG(num_bins) * ARG(oversampling);
  OVERSAMPLE = malloc(dim_over *sizeof(float));
  check_alloc(OVERSAMPLE," OVERSAMPLE allocation in c_hst_recon_overslices"); 
  
  MESSAGE(" ALLOCATION OK \n");
  
  /****************************************************
   * Initialise filter                                *
   ****************************************************/
  for(j=0;  j<dim_fft; j++)
    FILTER[j]=0.0;
  FILTER[1]= 1.0/dim_fft ;             /* This is the real part of the highest frequency */
  for(j=1;j<dim_fft / 2; j++) {
    FILTER[2 * j] = j * 2.0 / dim_fft/ dim_fft;
    FILTER[2 * j+1] = FILTER[2 * j];    /* !!! this was missing in AH code!!! */
  }
  
  FILTER[1] = (ARG(no_filtering)) ? (-9999.9999)  : FILTER[1];  /* set -9999.9999 to disable filtering */
  
  if (FILTER[1] > 0.)
    MESSAGE(" FILTER OK \n");
  
  /************************************************************
   * calculation of exponential facotors for fft              *
   ************************************************************/
  C_HST_EXPNT(dim_exponts, dim_fft*2, 8, EXPONENTS, status);
  
  MESSAGE(" C_HST_EXPNT  OK\n");
  
  /************************************************************
   * calculate limits of slices to reconstruct                *
   ************************************************************/
  hst_calculate_limits__(num_bins, start_x, start_y, num_x, num_y, 
    axis_position, &y_start, &y_end, X_STARTS, X_ENDS, status);
  
  MESSAGE(" HST_CALCULATE_LIMITS   OK\n");
  
  
  for(num_slice=0; num_slice<=ARG(last_slice) - ARG(first_slice); num_slice++) {
    if((num_slice % 16) == 0) {
      printf(
        " C_HST_RECON_OVERSLICES INFO: Reconstructing slice %d (and onwards)\n",
        num_slice + ARG(first_slice));
    }
    
#ifdef use_c_recon
    sem_init(&sema, 0, 1);
    sem_init(&semb, 0, 1);
    
    /****************************************************
      the following should be activated for sun
      and compilation against libthread
     ****************************************************/

#ifdef SOLARIS
         thr_setconcurrency( *nthreads ); 
#endif
    
    for(it=0; it<*nthreads; it++) {
      
      ARGOMENTS[it].sema = &sema;
      ARGOMENTS[it].semb = &semb;
      
      ARGOMENTS[it].nthreads= *nthreads;
      ARGOMENTS[it].thread  = it;
      
      ARGOMENTS[it].ptr[0] = num_bins;
      ARGOMENTS[it].ptr[1] = num_projections ;
      ARGOMENTS[it].ptr[2] = oversampling;
      ARGOMENTS[it].ptr[3] = start_x;
      ARGOMENTS[it].ptr[4] = start_y;
      ARGOMENTS[it].ptr[5] = num_x;
      ARGOMENTS[it].ptr[6] = num_y;
      ARGOMENTS[it].ptr[7] = &y_start;
      ARGOMENTS[it].ptr[8] = &y_end;
      ARGOMENTS[it].ptr[9] = X_STARTS;
      ARGOMENTS[it].ptr[10] = X_ENDS;
      ARGOMENTS[it].ptr[11] = angle_offset;
      ARGOMENTS[it].ptr[12] = angle_increment;
      ARGOMENTS[it].ptr[13] = axis_position;
      ARGOMENTS[it].ptr[14] = &dim_exponts;
      ARGOMENTS[it].ptr[15] = EXPONENTS;
      ARGOMENTS[it].ptr[16] = &dim_fft;
      ARGOMENTS[it].ptr[17] = FILTER;
      ARGOMENTS[it].ptr[18] = &dim_over;
      ARGOMENTS[it].ptr[19] = SINOGRAMS + num_slice * ARG(num_bins) *
        ARG(num_projections);
      ARGOMENTS[it].ptr[20] = &dum_time;
      ARGOMENTS[it].ptr[21] = &dum_time;
      ARGOMENTS[it].ptr[22] = &dum_time;
      ARGOMENTS[it].ptr[23] = &dum_time;
      ARGOMENTS[it].ptr[24] = SLICE;
      ARGOMENTS[it].ptr[25] = OVERSAMPLE;
      ARGOMENTS[it].ptr[26] = WORK;
      ARGOMENTS[it].ptr[27] = status;
      
      
      ret = pthread_create(&tid[it], NULL, start_routine, &ARGOMENTS[it]);
      
      printf(" lanciata thread %d\n",it);
      
    }
    for(it=0; it<*nthreads; it++) {
      pthread_join(tid[it], &pstatus);
    }
    
#else
    HST_RECON_1OVER(num_bins,num_projections,oversampling,
      start_x, start_y, num_x, num_y, &y_start, &y_end,
      X_STARTS, X_ENDS,
      angle_offset, angle_increment, axis_position,
      &dim_exponts, EXPONENTS, &dim_fft, FILTER, &dim_over,
      SINOGRAMS +  num_slice*ARG(num_bins)*ARG(num_projections),
      time_cpu_filter, time_elapse_filter, 
      time_cpu_back, time_elapse_back, 
      SLICE,
      OVERSAMPLE,
      WORK,
      status);
#endif
    
    if((*memory)==0)fwrite(SLICE, ARG(num_x) * sizeof(float), ARG(num_y), output);
  }
  
  
  
  MESSAGE(" FREEING MEMORY  OK\n");
  
  free(X_STARTS);
  free(X_ENDS);
  free(FILTER);
  free(EXPONENTS);
  free(WORK);
  free(OVERSAMPLE);
  
  printf(" EXITING ROUTINE C_HST_RECON_OVERSLICES\n");
  return 1;
}
int MAIN__() {}
