"""
    Drawable1D.py
    1D Graphics displaying widget
"""

from PyDVT import __version__,__date__,__author__


from Binding import Pen,Brush


class Drawable_1D:
    """
    1D Graphics displaying widget interface definition
    
    Application Level Interface:
    ===========================
    This class has some methods that can be called at application level. They refer to adding
    and changing graphical elements over the graphic displaying. They are called through
    View.GetDrawable() object:    
        PutLine
        PutRectangle
        PutSymbol
        PutText
        SetObjectCoords
        GetObjectCoords
        EraseObject
        UpdateObject
        
    This class generates the following callbacks to parent (a View object):
        _RightButtonPress
        _ButtonPress
        _DoubleClick
        _ButtonRelease
        _Motion
        _ButtonPressMotion
        _KeyPress
    """
    def __init__(self,parent,zoom_mode="ON",scroll_mode="ON"):
        """
        Parameters:
            parent: parent widget (a View object)
            zoom_mode: "ON" or "OFF" "
            scroll_mode: "ON", "OFF" or "AUTO"
        """
        pass

    
    def Show(self):
        """
        Displays widget
        """
        pass


    def GetHeight(self):
        """
        Returns height of the widget
        """
        pass


    def GetWidth(self):
        """
        Returns width of the widget
        """
        pass


    def ToggleGridlines(self):
        """
        Toggles gridline state (initial state: off)
        """
        pass


    def SetLabels(self,title_label=None,x_label=None,y_label=None,y2_label=None):
        """
        Parameters:
            title_label: Label on the top of drawing
            x_label: Label for x axis
            y_label: Label for y axis
            y2_label: Label for second (right-side) y axis
        """
        pass

            
    def SetEnv(self,xmin,xmax,ymin,ymax,y2min=None,y2max=None,reset_zoom=0):
        """
        Parameters:
            xmin,xmax: lower,upper values of x axis
            ymin,ymax: lower,upper values of y axis
            y2min,y2max: lower,upper values of y2 axis
            reset_zoom: if non-zero, resets zoom state.
        """
        pass


    def SetLogX(self,on,minvalue=1):
        """
        Parameters:
            on: if non-zero sets x axis logarithmic
                if zero, sets x axis linear
            minvalue: if on is non-zero sets the displaying value
                      for all values lass than or equals to zero
        """
        pass        

        
    def SetLogY(self,on,minvalue=0.000001):
        """
        Sets drawing limits
        Parameters:
            on: if non-zero sets y axis logarithmic
                if zero, sets y axis linear
            minvalue: if on is non-zero sets the displaying value
                      for all values lass than or equals to zero
        """
        pass

        
    def SetPolarEnv(self,value):
        """
        Parameters:
            value: if non-zero enable polar environment 
                   if zero, disables
        """        
        pass


    def EnableLegend(self,enable,position="bottom"):
        """
        Parameters:
            enable: if non-zero adds legend. If zero, removes.
            position: if enable is non-zero  sets the position of the legend: "top", "left",
                      "right" or "bottom"
        """
        pass

    def RemoveGraphicObjects(self):
        """
        Removes all graphical objects on the plotting
        (Added with the Put... methods)
        """
        pass

       
    def RemoveFunction(self,name=None):
        """
        Parameters:
            name: name of the function to be removed from the drawable.
                  if none, all are removed
        """        
        pass

            
    def SetFunction(self,name,function_pars):
        """
        Parameters:
            name: name of the function to be included
            function_pars: dictionary with the function properties (see GraphView)
                           In addiction:
                            "valid_range": tuple, defines a validity interval
                                           (the functions is only drawn in this interval)
        """        
        pass


    def SetFunctionItem(self,name,item,val):
        """
        Sets "item" of the function named "name" to the value "val"
        """        
        pass


    def Redraw(self):
        """
        Draws itself        
        """
        pass

    def IncrementalUpdate(self,function_name,range,restart=0):
        """
        Draws just the interval defined bu
        Parameters:
            function_name: name of the function
            range: tuple,(min,max) values for updating
            restart: if non-zero, erases previously displayed functions values
                     of function_name
        """


    def Save(self,filename,format):        
        """
        Parameters:
            filename: name of the output file.
            format: format to be saved ("PS","PNG","BMP" or "JPG")
        """
        pass

    
    def SetStyle(self,style):
        """
        Parameters:
            style: "Line", "Points", "PointsLine" or "Bars"
        """
        pass


    def SetZoom (self,(x0,y0),(x1,y1)):        
        """
        Parameters:
            (x0,y0): upper-left corner
            (x1,y1): upper-left corner 
        """
        pass


    def ResetZoom(self,update=1):
        """
        Parameters:
            update: if non-zero triggers a Redraw
        """
        pass

		
    def PutLine(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid"),yscale=0):
        """
        Parameters:
            X0,Y0: First point (data coords = coordinates of the displayed axis)
            X1,Y1: Second point (data coords = coordinates of the displayed axis)
            pen: Pen object
            yscale: if equals to 1 it's referenced to second y axis
        Returns a reference to the object
        """
        pass

    
    def PutRectangle(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid"),brush=Brush((0,0,0),"fill_0"),yscale=0):
        """
        Parameters:
            X0,Y0: upper-left corner (data coords = coordinates of the displayed axis)
            X1,Y1: lower-right corner (data coords = coordinates of the displayed axis)
            pen: Pen object to the contour
            brush: Brush object for the filling
            yscale: if equals to 1 it's referenced to second y axis
        Returns a reference to the object
        """
        pass


    def PutSymbol(self,X0,Y0,symbol="circle",pen=Pen((0,0,0),1,"solid"),yscale=0):
        """
        Parameters:
            X0,Y0: Location (data coords = coordinates of the displayed axis)
            symbol: 'circle', square', 'diamond', 'plus', 'cross', 'star' or 'triangle'        
            pen: Pen object
            yscale: if equals to 1 it's referenced to second y axis
        Returns a reference to the object
        """
        pass


    def PutText(self,X0,Y0,text, align="center",orient=0.,pen=Pen((0,0,0),1,"solid"),style="normal",yscale=0,brush=Brush((255,255,255),"fill_100")):
        """
        Parameters:
            X0,Y0: Location (data coords = coordinates of the displayed axis)
            align: 'center', 'left' or 'right'
            orient: angle (in degrees) of the text
            pen: Pen object for the text
            style: 'normal', 'bold' oe 'italic'
            yscale: if equals to 1 it's referenced to second y axis
            brush: Brush object for the background
        Returns a reference to the object
        """
        pass


    def SetObjectCoords(self,obj,*args):
        """
        Changes the coordinates of an graphical object
        Parameters:
            obj: reference to the object
            *args: X0,Y0,X1,Y1,... in data coords = coordinates of the displayed axis
        """
        pass


    def GetObjectCoords(self,obj):
        """
        Parameters:
            obj: reference to the object
        Returns the coordinates of the graphical object in data coords = coordinates
        of the displayed axis
        """
        pass

    
    def EraseObject(self,obj):
        """
        Erases graphical object
        Parameters:
            obj: reference to the object
        """
        pass


    def UpdateObject(self,obj,pen=None,brush=None,textOptsDic=None):
        """
        Changes properties of an object
        Parameters:
            pen: new Pen object
            brush: new Brush object
            textOptsDic: dictionary with new text properties
                         keys: 'orient', 'align', 'text', 'style'
                         values as in PutText method
        """
        pass
            

    def GetVisibleXAxis(self):
        """
        Returns the visible x axis (lower and higher values)
        """
        pass


    def GetVisibleYAxis(self):
        """
        Returns the visible y axis (lower and higher values)
        """
        pass


    def GetVisibleY2Axis(self):
        """
        Returns the visible y2 axis (lower and higher values)
        """
        pass


    def GetFunctionScale(self,name):
        """
        Returns which y axis the function named "name" is referenced to
        """
        pass

    
    def ImageCoord2ViewCoord(self, coord):
        """
        Tranforms image coordinates (referenced to original image) into 
        view coordinates (as generated by the events)
        """
        pass


    def ViewCoord2ImageCoord(self, coord):
        """
        Tranforms view coordinates (as generated by the events) into
        image coordinates ( referenced to original image )
        """
        pass


    def DataCoord2ViewCoord(self, coord):
        """
        Tranforms data coordinates (coordinates of the displayed axis) into 
        view coordinates (as generated by the events)
        """
        pass        


    def ViewCoord2DataCoord(self, coord):
        """
        Tranforms view coordinates (as generated by the events) into 
        data coordinates (coordinates of the displayed axis)
        """
        pass


    def Destroy(self):
        """
        Cleanup
        """
        pass
















