import string,time,types,sys
#sys.path.insert(0,'../')
#sys.path.insert(0,'../../PyDVT')
#sys.path.insert(0,'../odm')

from PyDisWindow import Plugin
from PyDVT.ImageView import ImageView
from PyDVT.EdfFileData import EdfFileData
print 'DEBUG'
from PyDVT.FitFilter import FitFilter
print 'DEBUG'
import PyDVT.DataSelection as DataSelection
print 'DEBUG'
from DataWrapper import DataToGroupNode
from SciDXPData import SciDXPData
from scidxp.util import DefaultArray
from ReadMccdFile import ReadMccdFileGroupNode
from AzimInt import AzimIntDataSetNode
from AzimIntFilter import AzimIntFilter
from IntegratePhiFilter import IntegratePhiFilter
from Integration import IntegrationDataSetNode

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '03/10/2002'

DEBUG=0

class Py4datAsciiPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datAsciiPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datAsciiPlugin.OnFinishInit...'
		self.app_window=app_window
	
	def OnFileSave (self,window,filename,format_string):
        	if DEBUG: print 'In Py4datAsciiPlugin.OnFileSave...'
		sourceWindow=self.GetSourceWindow(window)
		azimWindow=self.app_window.GetWindow('AzimInt - '+ sourceWindow.name)
		print 'initialFile=',sourceWindow.name,'\n','destinationFile=',filename
		file=open(filename,'w')
		file.write('# Py4dat Ascii Save for Graph Views'+'\n')
		file.write('# Date:'+ time.asctime() +'\n')
		file.write('# Parameters:'+'\n')
		file.write('#   CenterXY:'+str(sourceWindow.center)+'\n')
		file.write('#   OffsetXY:'+str(sourceWindow.offset)+'\n')
		file.write('#   PixelXY:'+str(sourceWindow.pixelsize)+'\n')
		if azimWindow!=None:
			ret=[]
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			for roi in azimWindow.rois.keys():
				ret.append(azimWindow.rois[roi])
			Limits = [ret[0].limits[0],ret[1].limits[0],ret[2].limits[0]]
			Limits.sort()
			ROI=Limits[1]
			BKG1=Limits[0]
			BKG2=Limits[2]
			file.write('#   ROI:'+str(ROI)+'\n')
			file.write('#   BKG1:'+str(BKG1)+'\n')
			file.write('#   BKG2:'+str(BKG2)+'\n')
	
		if sourceWindow.shortName=='Stack':
			if azimWindow==None:
				print 'Do Azim Int and select Rois !........'
				return
			if azimWindow.rois=={}:
				print 'Select Rois !.........'
				return
			image=0
			while image < sourceWindow.NumImages:	
				#imageName=string.split(sourceWindow.fileName[image],'/')[-1]
				file.write('###########################################\n')
				file.write('# File:' + sourceWindow.fileName[image] + '\n')
				if sourceWindow.fileName[image][-3:]=='edf':
					data=EdfFileData()
					data.SetSource(sourceWindow.fileName[image])
					data.LoadSource()
					#groupNode=DataToGroupNode(data,'groupNode')
					#datasetnode=groupNode.getChild('page0')
				elif sourceWindow.fileName[image][-4:]=='mccd':
					inputGroupNode=ReadMccdFileGroupNode(sourceWindow.fileName[image])
					data=SciDXPData()
					data.SetSource(inputGroupNode)
					data.LoadSource()
					#datasetnode=inputGroupNode.getChild(inputGroupNode.getChildren().keys()[0])
				if hasattr(sourceWindow,'Mask') and type(sourceWindow.Mask) != types.NoneType: 
					file.write('# Masked image \n')
					data.Pages[0].Array=data.GetPageArray()*sourceWindow.Mask
					#datasetnode._array=DefaultArray(datasetnode._array*sourceWindow.Mask)
				#azimDataSetNode=AzimIntDataSetNode(datasetnode,pixelsize=sourceWindow.pixelsize,offset=sourceWindow.offset,center=sourceWindow.center) 
				#azimDataSetNode.setAttribute('ROI1',ROI)
				#azimDataSetNode.setAttribute('ROI0',BKG1)
				#azimDataSetNode.setAttribute('ROI2',BKG2)
				#IntDataSetNode=IntegrationDataSetNode(azimDataSetNode)
				dataSelection=DataSelection.RectSelection(data)
				azimFilter=AzimIntFilter(dataSelection,pixelsize=sourceWindow.pixelsize,offset=sourceWindow.offset,center=sourceWindow.center)
				iphiFilter=IntegratePhiFilter('',azimFilter,parentWindow=azimWindow)
				#xdata=range(0,360)
				#ydata=IntDataSetNode.getData().getData().tolist()
				xdata=iphiFilter.GetOutput()['xdata']
				ydata=iphiFilter.GetOutput()['data']
				if hasattr(window,'fit_filter') and type(window.fit_filter) != types.NoneType:
					yfit=window.fit_filter.GetOutput()['data']
					file.write('# Fit Parameters:' + str(window.fit_filter.GetParameters()) + '\n')
					file.write('# Xdata' + '    /    ' + 'Ydata' + '    /    ' + 'Yfit' + '\n')
					i=0
					while i < len(ydata) :
						file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '    ' + str(yfit[i])+ '\n')
						i=i+1
				else:
					file.write('# Xdata' + '    /    ' + 'Ydata' + '\n')
					i=0
					while i < len(ydata) :
						file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '\n')
						i=i+1
				image=image+1
			file.close()
		else:
			if window==None or isinstance(window.View,ImageView) == 1 :
				print 'The active window must be a GraphView...........'
				return
			file.write('###########################################\n')
			file.write('# File:' + window.name + '\n')
			xdata=window.View.GetSource()[0].GetOutput()['xdata'].tolist()
			ydata=window.View.GetSource()[0].GetOutput()['data'].tolist()
			file.write('# Xdata' + '    /    ' + 'Ydata' + '\n')
			i=0
			while i < len(xdata) :
				file.write(str(xdata[i]) + '    ' + str(ydata[i]) + '\n')
				i=i+1
			file.close()	

		
	def GetSaveFormatList(self,window):
        	if DEBUG: print 'In Py4datAsciiPlugin.GetSaveFormatList...'
		return ["Ascii files (*.txt)"]

	def GetInfoString(self):
		return "v. "+__version__

    	########################################################
    	### Private
    	########################################################

    	def GetSourceWindow(self,window):
    		if window==None: return
		while window.master_window!=None:
			window=window.master_window
		return window
	

			
plugin=Py4datAsciiPlugin()
