import Command,types,Numeric, sys
#sys.path.insert(0,'../../PyDVT')
#sys.path.insert(0,'../.')
from PyDisWindow import Plugin
import PyDVT.ImageView as ImageView
from PyDVT.ImageViewSelect import ImageViewSelectRect
import PyDVT.DataSelection as DataSelection
from Py4datMaskFilter import Py4datMaskFilter
from Py4datImageViewSelect import ViewSelectPolygon
from Py4dat2DTransformPlugin import Py4dat2DTransformPlugin

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'

DEBUG=0

class Py4datMaskPlugin(Plugin):
	"""
    	Py4datMaskPlugin allows to put a mask on an image.
    	The mask is rectangular or polygonal.
	
    	Virtuals:
    	===========================    
        	OnStartInit
		OnFinishInit
		OnInitWindowPopupMenu
		GetInfoString
	
    	Private Methods:
    	===========================  
    		SetMask
		DelMasks 
		MaskDefine
		EventMaskSelection
		ClearMaskSelect
		Polygon
		EventPolygonSelection
		ClearPolygonSelect
	
	"""
  	########################################################
    	### Virtuals
    	########################################################
	def OnStartInit (self):
		if DEBUG: print 'In Py4datMaskPlugin.OnStartInit...'
		return 0

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datMaskPlugin.OnFinishInit...'
		self.app_window=app_window

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datMaskPlugin.OnInitWindowPopupMenu...'
    		if isinstance(window.View,ImageView.ImageView) == 1:
			window.Mask=None
			window.View.AddMenuSeparator()
			window.View.AddMenuPopupItem("Add mask Rectangle",Command.Command(self.MaskDefine,window))
			window.View.AddMenuPopupItem("Add mask Polygon",Command.Command(self.Polygon,window))
			window.View.AddMenuPopupItem("Del Masks",Command.Command(self.DelMasks,window))
	
	def GetInfoString(self):
		return "v. "+__version__
	
    	########################################################
    	### Private methods
    	########################################################

	def UpdateViews(self,window):
		if DEBUG: print 'In Py4datMaskPlugin.UpdateViews...'
		#for win in self.app_window.mdi.windows:  print win.name
		if window.name[0:7]=='AzimInt':
			integratePhiWindow=self.app_window.GetWindow('I(Phi) - '+ window.name)
			integrateqWindow=self.app_window.GetWindow('I(q) - '+ window.name)
			obj=Py4dat2DTransformPlugin()
			obj.OnFinishInit(self.app_window)
			if integratePhiWindow != None:
				obj.IPhi(window)
			if integrateqWindow != None: 
				obj.Iq(window)
		else:
			azimIntWindow=self.app_window.GetWindow('AzimInt - '+ window.name)
			integratePhiWindow=self.app_window.GetWindow('I(Phi) - AzimInt - '+ window.name)
			integrateqWindow=self.app_window.GetWindow('I(q) - AzimInt - '+ window.name)
			if azimIntWindow != None: 
				obj=Py4dat2DTransformPlugin()
				obj.OnFinishInit(self.app_window)
				obj.AzimInt(window)
				if hasattr(azimIntWindow,'Mask') and type(azimIntWindow.Mask)!=types.NoneType: 
					dataFilter=azimIntWindow.Filter
					if dataFilter==None: return
					maskedImage=Py4datMaskFilter(dataFilter)
					colormap=ImageView.ColormapFilter("colormap",maskedImage)
					azimIntWindow.View.SetSource(colormap)
					azimIntWindow.View.GetSource()[0].GetSource().SetMask(azimIntWindow.Mask)
				if integratePhiWindow != None:
					obj.IPhi(azimIntWindow)
				if integrateqWindow != None: 
					obj.Iq(azimIntWindow)	
	
	############## MASK ################################################
		
	def SetMask(self, val=None, rect=None):
		window=self.app_window.mdi.activeWindow()
		window.View.Drawable.SetMask (val=val,rect=rect)
	
	def DelMasks(self,window):
		data=window.View.GetSource()[0].GetOutput()['data']
		window.View.GetSource()[0].GetSource().SetMask(Numeric.ones(data.shape,data.typecode()))
		window.View.Refresh()
		self.UpdateViews(window)
		window.Mask=None
	
	def MaskDefine(self,window):
		if (window.View.Source!=()):
			#data=window.View.Source[0].GetData()
			dataFilter=window.Filter
			if dataFilter==None: return
			if type(window.Mask)==types.NoneType:
				#maskedImage=Py4datMaskFilter(DataSelection.RectSelection(dataFilter))
				maskedImage=Py4datMaskFilter(dataFilter)
				colormap=ImageView.ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			window.View.MaskSelect=ImageViewSelectRect(dataFilter,self.EventMaskSelection)
			window.View.MaskSelect.ConnectView(window.View)	
			
	def EventMaskSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		if (window.View.Source != ()) and (window.View.Source[0] != None):
			if type(window.Mask)==types.NoneType:
				#window.Mask=Numeric.ones(window.View.Source[0].GetData().Pages[0].Array.shape)
				window.Mask=Numeric.ones(window.View.Source[0].GetOutput()['data'].shape)
			data=window.View.GetSource()[0].GetOutput()['data']
          		if window.View.GetSource()[0]==None:
             			window.View.ClearMaskSelect(window)
              			return
          		window.View.MaskSelect.EraseSelection(window.View)
          		(p0,p1)=source.GetSelection()["BoundingRect"]
          		(x0,y0),(x1,y1)=window.View.Source[0].DataCoord2SelectionCoord(p0),window.View.Source[0].DataCoord2SelectionCoord(p1)
          		rect=(min(x0,x1),min(y0,y1),max(x0,x1),max(y0,y1))
			x,y=x0,y0
			while x < x1:
				while y < y1:
					window.Mask[y,x]=0.
					y=y+1
				x,y=x+1,y0
			window.View.GetSource()[0].GetSource().SetMask(window.Mask)
			window.View.Refresh()
			self.UpdateViews(window)
			self.ClearMaskSelect(window)

	def ClearMaskSelect(self,window):
        	if (window.View.MaskSelect is not None):
          		window.View.MaskSelect.Destroy()
          		window.View.MaskSelect=None    

	################## POLYGON ################################################
		
	def Polygon(self,window):
		if (window.View.Source!=()):
			#data=window.View.Source[0].GetData()
			dataFilter=window.Filter
			if dataFilter==None: return
			if type(window.Mask)==types.NoneType:
				maskedImage=Py4datMaskFilter(dataFilter)
				colormap=ImageView.ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			if hasattr(window.View,"PolygonSelect") and window.View.PolygonSelect is not None:
				window.View.PolygonSelect.Destroy()
			window.View.PolygonSelect=ViewSelectPolygon(dataFilter,self.EventPolygonSelection)
			window.View.PolygonSelect.ConnectView(window.View)
			
	def EventPolygonSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		if type(window.Mask)==types.NoneType:
				window.Mask=Numeric.ones(window.View.Source[0].GetOutput()['data'].shape)
		nbSites=len(source.GetSelection()['Polygon'])-1
		listx,listy=[],[]
		for position in source.GetSelection()['Polygon']:
			listx.append(position.PageCoord[0]),listy.append(position.PageCoord[1])
		xmin,ymin,xmax,ymax=min(listx),min(listy),max(listx),max(listy)
		x=xmin
		while x < xmax:	
			y=ymin
			while y < ymax:
				i=0
				intersection=0
				while i < nbSites:
					try:
						(xi,yi)=(source.GetSelection()['Polygon'][i].PageCoord)
						if i<nbSites-1: (xinext,yinext)=(source.GetSelection()['Polygon'][i+1].PageCoord)
						elif i==nbSites-1:(xinext,yinext)=(source.GetSelection()['Polygon'][0].PageCoord)
						a=(yinext-yi)*1./(xinext-xi)
						b=(yi*xinext-yinext*xi)*1./(xinext-xi)
						c=(y*1./x)
						xj=b/(c-a)
						yj=(c*b)/(c-a)
						if xj>min(xi,xinext) and xj<max(xi,xinext) and yj>min(yi,yinext) and yj<max(yi,yinext) and xj<x and yj<y:
							intersection=intersection+1
						i=i+1
					except:
						i=i+1
						continue
				if intersection % 2==0: pass
				else:
					window.Mask[y,x]=0.
				y=y+1
			x=x+1
		window.View.GetSource()[0].GetSource().SetMask(window.Mask)
		window.View.Refresh()
		source.Disable()
		self.UpdateViews(window)
		self.ClearPolygonSelect()
		
	def ClearPolygonSelect(self):
        	window=self.app_window.mdi.activeWindow()
		if (window.View.PolygonSelect is not None):
          		window.View.PolygonSelect.Destroy()
          		window.View.PolygonSelect=None
    
    		
plugin=Py4datMaskPlugin()
