from scidxp.util import *
print 'DEBUG1'
import Numeric, threading, time, random, os, os.path, pprint, time, string
print 'DEBUG2'
import specfile
print specfile
print 'DEBUG3'



class ReadSpecFileGroupNode(DefaultGroupNode):

	def __init__(self, filename, start_scan = None, end_scan = None):
		DefaultGroupNode.__init__(self, 'filename')
		try:
			f=specfile.Specfile(filename)
			self._nbscans=f.scanno()
			self._startscan=1
			self._endscan=self._nbscans
			attributes = self.getAttributes()
			if not start_scan is None:
				self._startscan = start_scan
				self._endscan = self._startscan
			if not end_scan is None:
				self._endscan = end_scan
				if self._endscan>self._nbscans:
					self._endscan=self._nbscans
			self.setAttribute("Title",DefaultArray(f.title()))
			self.setAttribute("User Information",DefaultArray(f.user()))
			self.setAttribute("Date",DefaultArray(f.date()))
			self.setAttribute("Epoch",DefaultArray(str(f.epoch())))
			self.setAttribute("Nbscans",DefaultArray(str(self._nbscans)))
		
			gn=self._startscan
			if self._startscan>self._endscan:
				print 'Error: startscan must be smaller than endscan'
				self.setAttribute("Status",DefaultArray("ERROR"))
			else:
				while gn<=self._endscan:
				        #Index of scans
					dsn=0
					scan=f.select(str(gn))
					labels=scan.alllabels()
				        #print 'labels=',labels
					if labels!=[]:
						nbArray=scan.cols()
					        #print 'nbArray=',nbArray,
						nblines=scan.lines()
					        #print 'nblines=',nblines,
						Array=[0]*nblines
						scan_name='scan'+str(gn)
						self._scan_groupnode=DefaultGroupNode(scan_name)
						self.insertChild(self._scan_groupnode)
						self._scan_groupnode.setAttribute("Nbcolumns",DefaultArray(str(nbArray)))
						self._scan_groupnode.setAttribute("Nblines",DefaultArray(str(nblines)))
						self._scan_groupnode.setAttribute("Date",DefaultArray(scan.date()))
						self._scan_groupnode.setAttribute("Title",DefaultArray(scan.header("")[0][5:]))
						self._scan_groupnode.setAttribute("h,k,l values",DefaultArray(scan.hkl()))
						#print 'scan number=',gn
						while dsn<nbArray:
						        # Index of columns
							test_data_set=SpecArray(f,gn,dsn+1)
							labels[dsn]=string.replace(labels[dsn],' ','_')
							test_data_set_node = DefaultDataSetNode(labels[dsn],test_data_set)    
							self._scan_groupnode.insertChild(test_data_set_node)
							dsn=dsn+1
						gn=gn+1
					else:
						gn=gn+1

			self.setAttribute("Status",DefaultArray("OK"))
			self.setAttribute("StatusMessage",DefaultArray("No errors."))
		except:
			raise
			self.setAttribute("Status",DefaultArray("ERROR"))
			self.setAttribute("StatusMessage",DefaultArray("Something went wrong."))



class SpecArray(Array):
	def __init__(self,f,scanIndex,columnIndex):
		self._columnIndex=columnIndex
		self._scanIndex=scanIndex
		self._scan=f.select(str(self._scanIndex))
		self._nblines=self._scan.lines()
		#self._dataType=dataType
		self.Array=[0]*self._nblines
		self._arrayChangeSupport=ArrayChangeSupport(self)
	
	def getRank(self):
		return 1
	
	def getExtends(self):
		return [self._nblines]
	
	def getExtend(self,dim):
		return self._nblines
	
	def getUnit(self):
		return ""
	
	def getDataCount(self):
		return self._nblines
	
	def getDataType(self):
		return Array.FLOAT64
	
	def getData(self):
		self.Array=self._scan.datacol(self._columnIndex)
		return self.Array
	
	def getDataSlab(self,first,last):
		self.Array=self._scan.datacol(self._columnIndex)[first[0]:last[0]+1]
		return self.Array
	
	def addArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._ArrayChangeSupport.addArrayChangeEventListener(ArrayChangeEventListener)
	
	def removeArrayChangeEventListener(self,ArrayChangeEventListener):
    		self._ArrayChangeSupport.removeArrayChangeEventListener(ArrayChangeEventListener)
	
	def fireArrayChangeEvent(self,ArrayChangeEvent):
    		self._ArrayChangeSupport.fireArrayChangeEvent(ArrayChangeEvent)






