import qt,saxs,array,types
from Numeric import *
from PyDVT.ExtendedImageView import *
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import ReadEdfFile
import PyDVT.ImageView
import PyDVT.GraphView as GraphView

DEBUG=1

class IntegrateQFilter(GraphFilter):
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=0,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none"):
		if DEBUG: print 'In IntegrateQFilter.__init__()'
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
	
	def GetOutput(self):
		if DEBUG: print 'In IntegrateQFilter.GetOutput...'
		
		sel=self.GetInput()
		
		#print 'input=',sel['data'][0,0]
		image=sel['data']		
		if type(image)==types.NoneType: return
		
		outputGraph=[]
		for x in range(0,image.shape[1]):
          		outputGraph.append(Numeric.sum(image[:,x]))
		L=50000				# Distance echantillon-detecteur en um ?
		lo=1000				# Longeur d'onde en um ?
		px=100				# Pixel size in um
		py=100				# Pixel size in um
		i=0
		xaxis=[]
		while i<len(outputGraph):
			if type(outputGraph[0])!=types.FloatType:	outputGraph[i]=float(outputGraph[i])
			xaxis.append(i*px*2*math.pi/L/lo)
			i=i+1
		outputarr=array(outputGraph)
      		xaxis=array(xaxis)
		
		#print 'output=',outputarr[0:5]				
		return {'name': self.name,'data': outputarr,'xdata': xaxis,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
	
