import qt,saxs,array
from Numeric import *
from PyDVT.ExtendedImageView import *
from PyDVT.ExtendedGraphView import *
from scidxp.util import *
import ReadEdfFile
import PyDVT.ImageView as ImageView
import PyDVT.GraphView as GraphView
from ErrorWindow import ErrorWindow

DEBUG=0

class IntegratePhiFilter(GraphFilter):
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=0,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none",parentWindow=None):
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
		self.parentWindow=parentWindow
	
	def GetOutput(self):
		if DEBUG: print 'In IntegratePhiFilter.GetOutput...'
		
		sel=self.GetInput()
		
		image=sel['data']
				
		if len(self.parentWindow.rois.keys())!=3:
			#print self.parentWindow.rois
			dial=ErrorWindow(None,message=' You must select 3 ROIs before integrate !',sizex=237,sizey=60)
			#print ' You must select 3 ROIs before integrate !'
			return {}
		else:
			ret=[]
			for roi in self.parentWindow.rois.keys():
				ret.append(self.parentWindow.rois[roi])
			print 'number of ROIs:',len(ret)
			Limits = [ret[0].limits[0],ret[1].limits[0],ret[2].limits[0]]
			Limits.sort()
			ROI=Limits[1]
			BKG1=Limits[0]
			BKG2=Limits[2]
			print 'BKG1,ROI,BKG2=',BKG1,ROI,BKG2
          		y1, y2 = ROI[0],ROI[1]
			y3, y4 = BKG1[0],BKG1[1]
			y5, y6 = BKG2[0],BKG2[1]
          		ROI = Numeric.sum(image[:,int(y1):int(y2)],1)
            		BKG1 = Numeric.sum(image[:,int(y3):int(y4)],1)
          		BKG2 = Numeric.sum(image[:,int(y5):int(y6)],1)
        		if len(BKG1) == len(BKG2):
         			BKG = BKG1 + BKG2
        		else:
          			BKG = BKG1
        		integrated_arr = ROI - BKG
			
      			xdata=arange(0,integrated_arr.shape[0],1)			
			return {'name': self.name,'data': integrated_arr,'xdata': xdata,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
			
		
	
