"""
    AzimParametersDialog.py
    
"""
from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='02/10/2002'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'


class AzimParametersDialog(QMainWindow):
	def __init__(self, parent,initial_parameters):
        	QMainWindow.__init__(self,parent,"Azim Parameters Editor",0)  

		dlg=Dialog(self,"Azim Parameters",1,0)
        	box=QVBox( dlg )
		self.pixelsizeX=initial_parameters['pixelsizeX']
		self.offsetX=initial_parameters['offsetX']
		self.centerX=initial_parameters['centerX']
		self.pixelsizeY=initial_parameters['pixelsizeY']
		self.offsetY=initial_parameters['offsetY']
		self.centerY=initial_parameters['centerY']
		
        	box1 = QHBox( box )
        	box2 = QHBox( box )
        	box3 = QHBox( box )
        	box4 = QHBox( box )
		box5 = QHBox( box )
        	box6 = QHBox( box )
        	box7 = QHBox( box )
        
        	lab1=QLabel(box1)
        	ed1=QLineEdit(box1)
        	lab2=QLabel(box2)
        	ed2=QLineEdit(box2)
        	lab3=QLabel(box3)
        	ed3=QLineEdit(box3)   
		lab4=QLabel(box4)
        	ed4=QLineEdit(box4)
        	lab5=QLabel(box5)
        	ed5=QLineEdit(box5)
        	lab6=QLabel(box6)
        	ed6=QLineEdit(box6)     
        	lab1.setText("Pixel Size X")
        	ed1.setText(QString(str(self.pixelsizeX)))
        	lab2.setText("Pixel Size Y")
        	ed2.setText(QString(str(self.pixelsizeY)))
        	lab3.setText("Offset X")
        	ed3.setText(QString(str(self.offsetX)))
		lab4.setText("Offset Y")
        	ed4.setText(QString(str(self.offsetY)))
        	lab5.setText("Center X")
        	ed5.setText(QString(str(self.centerX)))
        	lab6.setText("Center Y")
        	ed6.setText(QString(str(self.centerY)))
        	button=QPushButton(box7)
        	button.setText("OK")
        
		self.connect(button,SIGNAL("clicked()"),dlg.accept)
        	box.resize( 210, 180 )
        	if dlg.exec_loop():
            		try:
                		self.pixelsizeX=float(str(ed1.text()))
                		self.offsetX=float(str(ed3.text()))
                		self.centerX=float(str(ed5.text()))
				self.pixelsizeY=float(str(ed2.text()))
                		self.offsetY=float(str(ed4.text()))
                		self.centerY=float(str(ed6.text()))
            		except: pass
		

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=AzimParametersDialog(None,{'pixelsizeX':.01,'pixelsizeY':.01,'offsetX':0,'offsetY':0,'centerX':256,'centerY':256})
    app.setMainWidget (win)
    app.exec_loop()

