import Pmw
import Tkinter as Tk
#import Selector
import tkColorChooser
from BltGraphProperties import *

# --- default element configuration ---
elt_counter	= 0
elt_symbols	= ['circle','square','diamond','plus','cross','splus','scross']
elt_colors	= ['#FF0022','#9c0','#0c9','#690','#693','#060','#363', '#063','#093','#390']

def geteltconf(type='mca'):
    global elt_counter
    if type!='mca':
        symbol= elt_symbols[elt_counter % len(elt_symbols)]
    else:
	symbol= ''
    color= elt_colors[elt_counter % len(elt_colors)]
    elt_counter += 1
    return {'symbol': symbol, 'color': color, 'pixels': '0.1c'}


# --- defaults ROI configuration ---
roi_counter	= 0
roi_colors	= ['yellow', 'orange', 'red']
def getroiconf():
    global roi_counter
    colorno = roi_counter % len(roi_colors)
    roi_counter += 1
    return {'fill': roi_colors[colorno], 'linewidth':0, 'outline': roi_colors[colorno], 'stipple':'gray25'}


# --- defaults PEAK configuration ---
def getpeakconf():
    return {'outline':'black', 'linewidth':2, 'dashes':''}


class BltGraph(Pmw.Blt.Graph):
    def __init__(self, master, legend=0):
	self.master	= master

	Pmw.Blt.Graph.__init__(self, self.master, topmargin=0,title="", bufferelements=0)

	self.elements	= {}
	
	self.__xaxis	= ()
	self.__yaxis	= ()
	self.__xview	= ()
	self.__yview	= ()
	self.__zoom	= 0

	self.legend	= legend
	self.__create_legend()

	self.crosshairs	= GraphCrosshairs(self)
	self.gridlines	= GraphGridlines(self)
	self.axis	= {}
	self.axis['x']	= GraphAxis(self, 'x')
	self.axis['y']	= GraphAxis(self, 'y')
	self.axis['y2']	= GraphAxis(self, 'y2')

	self.element_popup = None

    def __create_legend(self):
	if self.legend:
	    hide= 0
	else:
	    hide= 1
	self.legend_configure(anchor='sw',position='bottom',
                              relief='flat',
                              padx=4, hide=hide,
                              foreground='#000',background="#eec",
                              activerelief='raised',
                              activebackground="#eeeeee",
                              activeforeground="#f00")

    # --- RESIZE ---
    def resize(self, width, height):
	self.configure(width=width, height=height)

    # --- LINE, POLYGON, ... in Tkinter canvas style ---
    def create_line(self, *args, **kw):
	""" Create a line in Tkinter canvas style:
		create_line(x0, y0, x1, y1, ..., xn, yn, options)
	    Coordinates should be given in view coord
	    Return a new line ID
	"""
	coords= ()
	for idx in range(0, len(args)-1, 2):
	    coords += self.invtransform(args[idx], args[idx+1])
	kw['coords']= coords
	return self.marker_create('line', **kw)

    def coords(self, name, *args):
	""" Update coordinates of any marker (line, polygon)
	    Coordinates should be given in view coord
	"""
	coords= ()
	for idx in range(0, len(args)-1, 2):
	    coords += self.invtransform(args[idx], args[idx+1])
	self.marker_configure(name, coords=coords)

    def create_rectangle(self, *args, **kw):
	""" Create a rectangle in Tkinter canvas style:
		create_polygon(x0, y0, x1, y1, options)
	    Coordinates should be given in view coord
	    Return a new polygon ID
	"""
	coords= ()
	coords+= self.invtransform(args[0], args[1])
	coords+= self.invtransform(args[0], args[3])
	coords+= self.invtransform(args[2], args[3])
	coords+= self.invtransform(args[2], args[1])
	kw['coords']= coords
	return self.marker_create('polygon', **kw)

    def coords_rectangle(self, name, *args):
	""" Update rectangle coordinates
		coords_rectangle(x0, y0, x1, y1)
	    Coordinates should be given in view coord
	"""
	coords= ()
        coords+= self.invtransform(args[0], args[1])
        coords+= self.invtransform(args[0], args[3])
        coords+= self.invtransform(args[2], args[3])
        coords+= self.invtransform(args[2], args[1])
	self.marker_configure(name, coords=coords)

    def EraseObject(self, *args):
	""" Delete any matching marker
	"""
	self.marker_delete(*args)

    # --- ZOOM ---
    def __init_zoom(self):
	self.__zoom= 1
	self.__xaxis= self.xaxis_limits()
	self.__yaxis= self.yaxis_limits()
	self.__xview= self.__xaxis
	self.__yview= self.__yaxis
	
    def zoom(self, xcoord, ycoord):
	if not self.__zoom:
	    self.__init_zoom()
	self.__xview= xcoord
	self.__yview= ycoord

    	self.xaxis_configure(min=xcoord[0], max=xcoord[1])
	self.yaxis_configure(min=ycoord[0], max=ycoord[1])

    def zoomminus(self):
	if not self.__zoom:
	    self.__init_zoom()
	xstep= (self.__xview[1]-self.__xview[0])/2
	ystep= (self.__yview[1]-self.__yview[0])/2
	xmin= self.__xview[0]-xstep
	xmax= self.__xview[1]+xstep
	ymin= self.__yview[0]-ystep
	ymax= self.__yview[1]+ystep
	if xmin < self.__xaxis[0]:	xmin= self.__xaxis[0]
	if xmax > self.__xaxis[1]:	xmax= self.__xaxis[1]
	if ymin < self.__yaxis[0]:	ymin= self.__yaxis[0]
	if ymax > self.__yaxis[1]:	ymax= self.__yaxis[1]
	self.zoom((xmin, xmax), (ymin, ymax))

    def zoomplus(self):
	if not self.__zoom:
	    self.__init_zoom()
	xstep= (self.__xview[1]-self.__xview[0])/4
	ystep= (self.__yview[1]-self.__yview[0])/4
	self.zoom((self.__xview[0]+xstep, self.__xview[1]-xstep),
		  (self.__yview[0]+ystep, self.__yview[1]-ystep))

    def zoomallowed(self):
	if self.__xview==self.__xaxis and self.__yview==self.__yaxis:
	    return 0
	else:
	    return 1
	

    def zoomreset(self, event=None):
	if not self.__zoom:
	    self.__init_zoom()
	if self.__xaxis != self.__xview or self.__yaxis != self.__yview:
	    self.xaxis_configure(min="", max="")
	    self.yaxis_configure(min="", max="")
	    self.__init_zoom()

    # --- DATA ---
    def setplot(self, name, xdata, ydata, yaxis='y', **kw):
	if name not in self.elements.keys():
	    self.elements[name]= GraphElement(self, name, xdata, ydata, yaxis, **kw)
	else:
	    elt= self.elements[name]
	    elt.setx(xdata)
	    elt.sety(ydata)
	    elt.setyaxis(yaxis)
	    elt.configure(**kw)

    def delplot(self, name=None):
	if name is None:
	    for name in self.elements.keys():
		self.elements[name].delete()
		del self.elements[name]
	else:
	    if name in self.elements.keys():
	        self.elements[name].delete()
	        del self.elements[name]

    def getplotnames(self):
	return self.elements.keys()


# ----------------------------------------------------------
# Generic Graph Object with configuration methods
# ----------------------------------------------------------
class GraphObject:
    def __init__(self, graph, cget, configure, name=None, default={}, conf={}):
	self.g		= graph
	self._cget	= cget
	self._conf	= configure
	self.default	= default

	if name is not None:
	    self.name	= name
	    self._param	= (name,)
	else:
	    self._param	= ()
	
	self._create()

	actual		= self.configure()
	self.cnfkeys	= actual.keys()

	cnf= self.default.copy()
	cnf.update(conf)
	if len(cnf.keys()):	
	    self.configure(**cnf)

    def _create(self):
	pass

    def __getitem__(self, key):
	return apply(self._cget, self._param+(key,))

    def __setitem__(self, key, value):
	cnf= {key: value}
	return apply(self._conf, self._param, cnf)
	
    def configure(self, **kw):
	return apply(self._conf, self._param, kw)

    def getconfig(self):
	cnf= {}
	for key in self.cnfkeys:
	    cnf[key]= apply(self._cget, self._param+(key,))
	return cnf

    def setconfig(self, cnf):
	self.configure(**cnf)

# ----------------------------------------------------------
# 		GRAPH ELEMENTS
# ----------------------------------------------------------
class GraphElement(GraphObject):
    def __init__(self, graph, name, xdata, ydata, yaxis='y', **kw):
	self.xvector	= Pmw.Blt.Vector(len(xdata))
	self.yvector	= Pmw.Blt.Vector(len(ydata))

	GraphObject.__init__(self, graph, graph.element_cget, graph.element_configure, name,
				default= geteltconf(), conf=kw)

	self.selected	= 0
	self.yaxis	= None

	self.setx(xdata)
	self.sety(ydata)
	self.setyaxis(yaxis)

    def _create(self):
	self.element= self.g.line_create(self.name, xdata= self.xvector, ydata= self.yvector)
	self.g.legend_bind(self.name, '<ButtonPress-1>',self.select)
	#self.graph.legend_bind(self.yname, '<ButtonPress-3>',self.popupmenu)

    # --- delete element ---
    def delete(self):
	self.g.element_delete(self.name)
	self.g.axis[self.yaxis].remove(self.name)

    # --- popup menu on legend ==> move to graph
    def __create_menu(self):
	self.__menu = Tk.Menu(self.graph,tearoff=0)
	self.__menu.add_command(label='Graph: %s'%self.yname)
	self.__menu.add_separator()
        self.__menu.add_command(label='Delete',command=self.__delete)
	self.__menu.add_command(label='Clone', command=self.__clone)
	self.__menu.add_command(label='Properties', command=self.__properties)

    def popupmenu(self, event):
	self.select()
	x= event.x + self.g.winfo_rootx()
	y= event.y + self.g.winfo_rooty()
	self.__menu.tk_popup(x, y)

    # --- selection (toggle active state) ---
    def select(self, event=None):
	if not self.selected:
	    self.g.legend_activate(self.name)
	    self.selected= 1

    def unselect(self, event=None):
	if self.selected:
	    self.g.legend_deactivate(self.name)
	    self.selected= 0

    # --- data operation ---
    def setx(self, xdata):
	self.xvector.set(xdata)
    
    def sety(self, ydata):
	self.yvector.set(ydata)

    def setyaxis(self, yaxis):
	if yaxis!=self.yaxis:
	    if self.yaxis is not None:
		self.g.axis[self.yaxis].remove(self.name)
	    self.configure(mapy=yaxis)
	    self.g.axis[yaxis].add(self.name)
	    self.yaxis= yaxis
	
    def addx(self, xdata):
	self.xvector.append(xdata)

    def addy(self, ydata):
	self.yvector.append(ydata)

# ----------------------------------------------------------
# 			AXIS
# ----------------------------------------------------------
class GraphAxis(GraphObject):
    def __init__(self, graph, name, **kw):
	GraphObject.__init__(self, graph, graph.axis_cget, graph.axis_configure, name, conf=kw)

	self.use	= []
	self.hide	= name not in ['x', 'y']

    def add(self, name):
	self.use.append(name)
	if len(self.use) and self.hide:
	    self.g.axis_configure(self.name, hide=0)
	    self.hide= 0

    def remove(self, name):
	self.use.remove(name)
	if not len(self.use) and not self.hide:
	    self.g.axis_configure(self.name, hide=1)
	    self.hide= 1

    def limits(self):
	return self.g.axis_limits(self.name)
	
# ----------------------------------------------------------
# 			CROSSHAIRS
# ----------------------------------------------------------
class GraphCrosshairs(GraphObject):
    def __init__(self, graph, **kw):
	GraphObject.__init__(self, graph, graph.crosshairs_cget, graph.crosshairs_configure, None,
			{'hide':1, 'dashes':1, 'linewidth':1, 'color':'black'}, kw)

    def _create(self):
	self.g.bind('<Motion>', self.__followmouse, '+')

    def __followmouse(self, event):
	if self.g.crosshairs_cget('hide')=='0':
	    self.g.crosshairs_configure(position='@%d,%d'%(event.x, event.y))
	   
    def toggle(self):
	self.g.crosshairs_toggle()

# ----------------------------------------------------------
# 			GRID
# ----------------------------------------------------------
class GraphGridlines(GraphObject):
    def __init__(self, graph, **kw):
	GraphObject.__init__(self, graph, graph.grid_cget, graph.grid_configure, None,
		{'hide':1, 'dashes':0, 'linewidth':1, 'mapx':'x', 'mapy':'y', 'minor':0}, kw)

    def toggle(self):
	self.g.grid_toggle()



def test():
    x = range(10)
    y1= range(10)
    y2= range(0, 20, 2)
    y2[5]= 0.00001
    y3= range(0, 30, 3)

    root= Tk.Tk()
    g = BltGraph(root, legend=1)
    g.setplot('p1', x, y1, 'y')
    g.setplot('p2', x, y2, 'y')
    g.setplot('p3', x, y3, 'y2')
    g.elements['p3'].configure(mapy='y2')

    g.pack(fill='both', expand='yes')

    g.crosshairs.toggle()
    g.gridlines.setconfig({'hide':1})

    g.axis['y2']['logscale']= 1

    #ycnf= g.elements['y1'].getconfig()
    #ycnf['dashes']= 5
    #ycnf['symbol']= 'triangle'
    #g.elements['y1'].setconfig(ycnf)

    #g.addroi('roi1', 2, 4)
    #g.addroi('roi2', 3, 5)
    #g.addroi('roi3', 6, 8)
    #g.setroiactive('roi3')

    #d = GraphDialog(root, 'test')    

    #p1= GraphPeak(g, 'p1', 4.5)
    #p2= GraphPeak(g, 'p2', 6.5, element='y2')
    #Tk.Button(text='test', command=lambda graph=g: BltGraph.delroi(graph,'roi3')).pack()
    root.mainloop()


if __name__=='__main__':
    test()
