from Numeric import *
from  PPMtens import *
from Dabax import *
from Minimiser import *
import string
List=list
t0=Dabax_f0_Table("f0_WaasKirf.dat",)

t12=Dabax_f1f2_Table("f1f2_Windt.dat",)

roughtop=Variable(2,1.0,20.0,)

roughbot=Variable(2,1.0,20.0,)

shb=Variable(-0.390319680143,-5.0,5.0,)

thickness=Variable(4.0,81.09,160.0,)

shiftbidon=Variable(-0.4614,-2.0,2.0,)

m_Al=AtomicProperties("Al","Density[g/ccm]",)

m_O=AtomicProperties("O","Density[g/ccm]",)

m_Fe=AtomicProperties("Fe","Density[g/ccm]",)

dens_alo=Variable(4.0,0.,0.,)

dens_feo=Variable(5.1,0.,0.,)

o_dens_feo=DependentVariable("par(dens_feo)*par(m_O)*4.0/(3*par(m_Fe)+4.0*par(m_O))",dictio=locals())

fe_dens_feo=DependentVariable("par(dens_feo)*par(m_Fe)*3.0/(par(m_Fe)*3+par(m_O)*4)",dictio=locals())

al_dens_alo=DependentVariable("par(dens_alo)*par(m_Al)*2.0/(par(m_Al)*2.0+par(m_O)*3.0)",dictio=locals())

o_dens_alo=DependentVariable("par(dens_alo)*3.0*par(m_O)/(2*par(m_Al)+3.0*par(m_O))",dictio=locals())

alo_ind=IndexFromTable(t0,t12,"Al",al_dens_alo,"O",o_dens_alo,)

feo_ind=IndexFromTable(t0,t12,"Fe",fe_dens_feo,"O",o_dens_feo,)

bfitted=BetaManipulator_ContributionsFromFile("GOOD",shift=0.0,factor=1,rescaleXlambda=0,saturation=1.0,)

b_sacchi_dat=BetaManipulator_ContributionsFromFile("fox3.dat",shift=0.0,factor=0.012,rescaleXlambda=0,saturation=1.0,)
bfitted=b_sacchi_dat

bvararA_plus=CreateVariableArray(Np=10,Xmin=700.0,Xmax=704.0,value=1.0,min=0.,max=20.0,)

bvararA=CreateVariableArray(Np=10,Xmin=700.0,Xmax=704.0,value=1.0,min=0.,max=20.0,)

bvararB_plus=CreateVariableArray(Np=40,Xmin=704.1,Xmax=711.9,value=1.0,min=0.0,max=20.0,)

bvararB=CreateVariableArray(Np=40,Xmin=704.1,Xmax=711.9,value=1.0,min=0.0,max=20.0,)

bvararC_plus=CreateVariableArray(Np=50,Xmin=712.0,Xmax=730.0,value=1.0,min=0.0,max=20.0,)

bvararC=CreateVariableArray(Np=50,Xmin=712.0,Xmax=730.0,value=1.0,min=0.0,max=20.0,)

b_var_plus=BetaManipulator_ContributionsFromInterpolation(bfitted,shift=0.0,arrs=[bvararA_plus, bvararB_plus, bvararC_plus],)

b_var_minus=BetaManipulator_ContributionsFromInterpolation(bfitted,shift=0.0,arrs=[bvararA, bvararB, bvararC],)

b_feo_minus= BetaManipulator_BetaJoin( b_var_minus ,material=feo_ind,trim_left=0,trim_right=0,)

b_feo_plus = BetaManipulator_BetaJoin( b_var_plus   ,material=feo_ind,trim_left=0,trim_right=2,)

feo_minus=KK(filename_or_betaObject=b_feo_minus,material=feo_ind,E1=600,E2=900,N=3000,e1=610,e2=790,Fact=1.0,Dx=0.0,)

feo_plus=KK(filename_or_betaObject=b_feo_plus,material=feo_ind,E1=600,E2=900,N=3000,e1=610.0,e2=790,Fact=1.0,Dx=0.0,)

feo_mag=MagScatterer(NameFilePlus=feo_plus ,NameFileMinus=feo_minus,versor=(1.0,0,0),RelativeDensity=1.0,Saturation=1.0,)

subst=PPM_SimpleLayer(thickness=0.0,roughness=roughbot,material=alo_ind,)

feo_layer=PPM_SimpleLayer(thickness=thickness,roughness=roughtop,material=feo_mag,)

stack=SumThings(subst,feo_layer,)

scan_ref4=ScanReader("5A_4deg_ref.TXT",Polarisation=[(0.5,0,(1.0/math.sqrt(2.0) , 1.0j/math.sqrt(2.0))),(0.5,1,(1.0/math.sqrt(2.0) , 1.0j/math.sqrt(2.0)))],Np="automatic",wavelenghts_col=1,angles_col=4.0,refle_col=2,weight_col=1.0,angle_factor=math.pi/180.0,)

norm4=Variable(12.0,0.1,100,)

noise4=Variable(0.01314340812694,0.,0.3,)

fitkk=KK_ForPlot(feo_plus,500,900,2000,)

fit_ref=PPM_ComparisonTheoryExperiment(stack,[scan_ref4],[1.0],meritfunction="diffroot",normlist=[norm4],noise=[noise4],width=0.0,shiftlist=[0.0],)


tutti = bvararA+bvararB+bvararC

derivata=[]
Xs=[]
Ys=[]
fit_ref.error()
# raise "OK"
base = fit_ref.calculatedscan[0]

for var in tutti:
    Minimiser.colpo[0]=Minimiser.colpo[0]+1
    var.value=var.value+0.001
    fit_ref.error()

    deri = -(base-fit_ref.calculatedscan[0])/0.001
    derivata.append(deri)
    var.value=var.value-0.001

    Xs.append(var.X)
    Ys.append(var.value)


deri=array(deri)

Xs=array(Xs)

Ys=array(Ys)


f=open("Derivate4A","w")
import pickle

pickle.dump(derivata,f)
pickle.dump(Xs,f)
pickle.dump(Ys,f)
f.close()
   

