import  NumericA
from Numeric import *
from  PPMlayerclass import *
from Dabax import *
from Minimiser import *
import string
List=list
t0=Dabax_f0_Table("f0_WaasKirf.dat",)

t12=Dabax_f1f2_Table("f1f2_Henke.dat",)

roughtop=Variable(6.59737114424,1.0,20.0,)

roughbot=Variable(6.93234333927,1.0,20.0,)

thickness=Variable(81.0952324947,40.0,150.0,)

shiftbidon=Variable(-0.461460685693,-2.0,2.0,)

dens_alo=Variable(4.0,0.,0.,)

dens_feo=Variable(5.1,0.,0.,)

m_Al=AtomicProperties("Al","Density[g/ccm]",)

m_O=AtomicProperties("O","Density[g/ccm]",)

m_Fe=AtomicProperties("Fe","Density[g/ccm]",)

o_dens_feo=DependentVariable("par(dens_feo)*par(m_O)*4.0/(3*par(m_Fe)+4.0*par(m_O))",dictio=locals())

fe_dens_feo=DependentVariable("par(dens_feo)*par(m_Fe)*3.0/(3*par(m_Fe)+4.0*par(m_O))",dictio=locals())

al_dens_alo=DependentVariable("par(dens_alo)*par(m_Al)*2.0/(par(m_Al)*2.0+par(m_O)*3.0)",dictio=locals())

o_dens_alo=DependentVariable("par(dens_alo)*par(m_O)*3.0/(par(m_Al)*2.0+par(m_O)*3.0)",dictio=locals())

alo_ind=IndexFromTable(t0,t12,"Al",al_dens_alo,"O",o_dens_alo,)

feo_ind=IndexFromTable(t0,t12,"Fe",fe_dens_feo,"O",o_dens_feo,)

shb=Variable(-0.390319680143,-5.,5.,)

b_feo_sacchi_dat=BetaManipulator_ContributionsFromFile("fox3.dat",shift=shb,factor=0.012,rescaleXlambda=1,saturation=1.0,)

bfitted=BetaManipulator_ContributionsFromFile("x_y_beta_interp.dat",shift=0.0,factor=1,rescaleXlambda=0,saturation=1.0,)

bvararA=CreateVariableArray(Np=10.0,Xmin=700.0,Xmax=704.0,value=1.0,min=-0.0,max=20.0,)

bvararB=CreateVariableArray(Np=40,Xmin=704.1,Xmax=711.9,value=1.0,min=-0.0,max=20.0,)

bvararC=CreateVariableArray(Np=50,Xmin=712.0,Xmax=730.0,value=1.0,min=-0.0,max=20.0,)

b_var=BetaManipulator_ContributionsFromInterpolation(bfitted,shift=0.0,arrs=[bvararA, bvararB,bvararC],)

b_joined=BetaManipulator_BetaJoin(b_var,material=feo_ind,trim_left=0,trim_right=0,)

feokk=KK(filename_or_betaObject=b_joined,material=feo_ind,E1=600.0,E2=900.0,N=1000,e1=610.0,e2=790.0,Fact=1.0,Dx=0.0,)

subst=PPM_SimpleLayer(thickness=0.0,roughness=roughbot,material=alo_ind,)

feo_layer=PPM_SimpleLayer(thickness=thickness,roughness=roughtop,material=feokk,)

stack=SumThings(subst,feo_layer,)

scan_ref2=ScanReader("100Ath2_ref_.TXT",Np="automatic",wavelenghts_col=1,angles_col=2.0,refle_col=2,weight_col=1.0,angle_factor=math.pi/180.0,)

scan_ref4=ScanReader("100Ath4_ref_.TXT",Np="automatic",wavelenghts_col=1,angles_col=4.0,refle_col=2,weight_col=1.0,angle_factor=math.pi/180.0,)

fitkk=KK_ForPlot(feokk,500,1000,2000,)

norm4=Variable(3.60489231407,0.1,100.0,)

norm2=Variable(0.984351899276,0.1,100.0,)

noise4=Variable(0.0318744101322,0.,0.3,)

noise2=Variable(-0.0115190356193,-0.3,0.3,)

fit_ref_dup1=PPM_ComparisonTheoryExperiment(stack,[scan_ref4],[1.0],normlist=[norm4],noise=[noise4],width=0.0,shiftlist=[0.0],)

fit_ref=PPM_ComparisonTheoryExperiment(stack,[scan_ref2,scan_ref4],[1.0,1.0],normlist=[norm2,norm4],noise=[noise2,noise4],width=0.0,shiftlist=[shiftbidon,0.0],)

op_vars=List([bvararA,bvararB,roughtop,roughbot,thickness,shiftbidon,norm4,norm2,noise4,norm2,bvararC,])

Minimise(fit=fit_ref_dup1,list_of_variables=op_vars,tol=0.001,temperature=".05*exp(-0.2*x)",max_refusedcount=100,max_isthesame=10,)

