import  NumericA
from Numeric import *
from  PPMtens import *
from Dabax import *
from Minimiser import *
import string
List=list
scan_ref=ScanReader("SP/th2th_En776_5.dat",Polarisation=[(1.0, 0, (1.0/sqrt(2.0), complex(0,1.0)/sqrt(2.0)))],Np="automatic",wavelenghts_col=12398.52/776.5,angles_col=1,refle_col=2,weight_col=1.0,angle_factor=3.1415/180.0,)

scan0=BetaManipulator_ScanReader("SP/betapiu.dat",Np="automatic",Polarisation=[(1.0,1)],energies_col=1,data_col=2,weight_col=1.0,)

scan2=BetaManipulator_ScanReader(Polarisation=[(1.0,1)],energies_col=[700,900,0.2],)

t0=Dabax_f0_Table("f0_WaasKirf.dat",)

t12=Dabax_f1f2_Table("f1f2_Henke.dat",)

Co_dens=AtomicProperties("Co","Density[g/ccm]",)

Co_ind=IndexFromTable(t0,t12,"Co",Co_dens,)

b_minus=BetaManipulator_ContributionsFromFile("SP/absmeno.dat",shift=0.0,factor=0.12,rescaleXlambda=1,)

b_plus=BetaManipulator_ContributionsFromFile("SP/abspiu.dat",shift=-0.0,factor=0.102,rescaleXlambda=1,)

b_minus_joined=BetaManipulator_BetaJoin(b_minus,material=Co_ind,trim_left=0,trim_right=0,)

b_plus_joined=BetaManipulator_BetaJoin(b_plus,material=Co_ind,trim_left=1.5,trim_right=5,)

fit=BetaManipulator_Comparison( b_plus_joined,[scan0],[1.0],normlist=[1.0],printpartial=0,)

kkminus=KK(filename_or_betaObject=b_minus_joined,material=Co_ind,E1=600.0,E2=1000.0,N=2000,e1=700.0,e2=850.0,Fact=1.0,Dx=0.0,)

kkplus=KK(filename_or_betaObject=b_plus_joined,material=Co_ind,E1=600.0,E2=1000.0,N=2000,e1=700.0,e2=850.0,Fact=1.0,Dx=0.0,)

fit_kk=KK_ForPlot(kkplus,600,1100,2000,)

Si_dens=AtomicProperties("Si","Density[g/ccm]",)

Si_ind=IndexFromTable(t0,t12,"Si",Si_dens,)

Cu_dens=AtomicProperties("Cu","Density[g/ccm]",)

Cu_ind=IndexFromTable(t0,t12,"Cu",Cu_dens,)

Si_layer=PPM_SimpleLayer(thickness=0.0,roughness=2.0,material=Si_ind,)

Cu_layer=PPM_SimpleLayer(thickness=22.0,roughness=3.0,material=Cu_ind,)

Co_magB=MagScatterer(NameFilePlus=kkminus,NameFileMinus=kkplus,versor=[1.0,0.0,0.0],RelativeDensity=1.0,Saturation=-1.0,)

Co_magA=MagScatterer(NameFilePlus=kkminus,NameFileMinus=kkplus,versor=[1.0,0.0,0.0],RelativeDensity=1.0,Saturation=1.0,)

Co_layerB=PPM_SimpleLayer(thickness=11.0,roughness=3.0,material=Co_magB,)

Co_layerA=PPM_SimpleLayer(thickness=11.0,roughness=3.0,material=Co_magA,)

quadri=SumThings(Cu_layer,Co_layerA,Cu_layer,Co_layerB,)

multi_quadri=MultiplyAThing(10,quadri,)

stack=SumThings(Si_layer,Si_layer,)

fit_ref=PPM_ComparisonTheoryExperiment(stack,[scan_ref],[1.0],meritfunction="abslogdiff",normlist=[1.0],noise=[0.0],width=0,)


fit_ref.error()