##################################################################
# Alessandro MIRONE 2001
# ESRF
##################################################################

#########################
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.

## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt


import string
import copy
import glob
# tipi di variabile
#   "string_va"

headers=""

"""
 bla bla bla
"""
class property_class:
   """
   ###################################
   # this is just an utility for property
   # 
   """
   def __init__(self):
      pass



def property(**dic):
     """
       create a new property object with arbitraty properties
       that are set by a dictionary.
        A properties is something that is used to initialise an object_instruction
      
     """
     	
     res=property_class()
     # '''''''''''''''''''''''''''''''''''''''''''''''''''''
     # '' default values
     setattr(res, "type" , "None" )
     setattr(res, "value" , "None" )
     setattr(res, "argument_key" , "None" )
     setattr(res, "help" , "None" )
     count=0;
     for key in dic.keys():
        setattr(res,key, dic.values()[count])
        count+=1
     return res



def map_varname_2_instruction(varname):
  """
      returns the instruction that generate
      the variable having name varname
  """

  if(varname in property_container.instruction_for_variable.keys()):
     return property_container.instruction_for_variable[varname]
  else:
     return []


def map_typename_2_varnames(typename):
  """ returns the varnames whose instructions are of the type typename
  """
  if( isinstance(typename, type([]))):
     res=[]
     for tok in typename:
        res=res+map_typename_2_varnames(tok) 
  else:
    if(typename in property_container.space_of_variables.keys()):
       res=[]
       candidates= property_container.space_of_variables[typename]
       for name in candidates:
           if(name in property_container.instruction_for_variable.keys()):
              res.append(name)
       property_container.space_of_variables[typename]=res
    else:
       res= []
  return res





def get_varnames():
  """
      returns the varnames list
  """
  return  property_container.instruction_for_variable.keys()




class instruction_manager:
   """ instruction register to this class.
       Two subvariables are define:
         instruction={}  ==> instruction type to object
         instruction_classes={}  ===>  supertype to type instruction types

   """
   instruction={}
   instruction_classes={}


def register_instruction(inst_class):
   """ get a class defining an instruction
       and registers it in a dict
   """
   instruction_manager.instruction[inst_class.type ]=inst_class

   if( inst_class.supertype not in instruction_manager.instruction_classes.keys() ):
          instruction_manager.instruction_classes[inst_class.supertype]=[]
   instruction_manager.instruction_classes[inst_class.supertype].append( inst_class.type    ) 


class property_container:
   """
    properties are not manipulated directly but by property_container.
    property_container centralises the management of space_of_variables
    and instruction_for_variable dictionaries
   
   """

   """ Dictionary containing for a key type_name a list of var_names of that type 
   """
   space_of_variables={}

   """ Dictionary containing for a key var_name the instruction generating that 
       variable
   """
   instruction_for_variable={}

   def __init__(self, prop, instruction):
     self.property=prop
     self.instruction=instruction
     ##########################################################3
     # an instruction may generate variable of its type
     #
     if(instruction.generatedtype is not None):
        if(instruction.generatedtype not in self.space_of_variables.keys() ):
              self.space_of_variables[instruction.generatedtype]=[]
     else:
         if(instruction.type not in self.space_of_variables.keys() ):
              self.space_of_variables[instruction.type]=[]

   
   def get_type(self):
     """
      return the type of the variable (Numeric, String....) 
     """
     return self.property.type


   def get_help(self):
     """
      return the help associated with the property "
     """
     return self.property.help

   def get_value(self):
     """
        the value of the property if it is different than None.
        Otherwise the Null string
     """
     if(self.property.value != "None"):
        return self.property.value
     else:
        return ""

   def get_argument_key(self):
     """
        arguments are passed  by keyword.
        Returns the keyword associated with property     
     """
     if(self.property.argument_key=='width' and self.property.value=='1'):
        self.property.argument_key="printpartial"
     return self.property.argument_key

   def get_property_name(self):
     """
        arguments are edited by widgets that displays the property_name
         return self.property.property_name
        if not "None"
        otherwise
         return self.property.argument_key    
     """
     if( self.property.property_name != "None"):
       return self.property.property_name 
     else:
       return self.property.argument_key


   def get_description(self):
     """ short description base on what one finds 
         in the property object
     """
     return  (
	      #  "  type         = "    + self.property.type          +"\n"+
               "  value        = "    + self.property.value         +"\n"+ 
               "  argument_key = "    + self.property.argument_key  +"\n"+ 
               "  help         = "    + self.property.help          +"\n"
             )

   def set_value(self, value):
     #################################################################################################333
     """
      - avoids identity operations (self.property.value==value)
      ### IF self.property_type ==   "string_va"
      ##    we operate on the space of variables
             - avoids referencing two different objects with a same variable name
             - The instruction associated to a variable name is traced back by instruction_for_variable dic
     """
     ##############################################################################################3333333

     # remove unused names
     varnames= self.instruction_for_variable.keys()
     for tok in varnames:
        if ( self.instruction_for_variable[tok].active==0) :
           del self.instruction_for_variable[tok]

     value=str(value)
     if(value==""): value="None"

     print " SET VALUE ", value,  self.instruction_for_variable.keys()
     if(self.property.value == value): 
         return
     if( self.property.type ==   "string_va"):
        if(value in self.instruction_for_variable.keys()):
            return
            # raise " variable exists already "

        if(self.instruction.generatedtype is not None):
               dum=self.instruction.generatedtype
        else:
               dum=self.instruction.type

        if(self.property.value != "None"):
            self.space_of_variables[dum].remove(self.property.value)
            del self.instruction_for_variable[self.property.value]

        if(value!="None"):
          self.space_of_variables[dum].append(value)   
          self.instruction_for_variable[value]= self.instruction

     self.property.value = value
     self.instruction.propertychanged()
 
   def get_good_options(self):
     """
      returns the list of variable name that can fit the property
     """
     if(self.property.type=="any"):
       res=[]
       for key in self.space_of_variables.keys():
         res=res+ self.space_of_variables[key]
     elif(self.property.type=="notype"):
       res=[]
     else:
        print " guardo le variabili corrispondenti a " , self.property.type
        res=map_typename_2_varnames(self.property.type)
        print " res = " , res
     if(hasattr(self.property,"additionaloptions")):
        ao=self.property.additionaloptions
        if( isinstance(ao, type(()) ) ):
           res=ao
        else:
           res=res+ao
     return res



def  duplication(duplicanda):
  """
  This duplicates instructions
  """
  res=copy.deepcopy(duplicanda)
  if( hasattr(duplicanda,"duplicated")==0):
     duplicanda.duplicated=0
  duplicanda.duplicated+=1
  ndup=duplicanda.duplicated
  name = res.get_varname()
  name = "%s_dup%d"%(name, ndup)
  print " NAME ", name
  res.properties_list_fixed[0].property.value="None" 
  res.properties_list_fixed[0].set_value(name)
  
  duplicati=[res]
  for prop in res.get_properties_list(res.get_option())+res.properties_list_fixed[2:]:
     name = prop.get_value()
     print " vedo se ", name , " e da DUPLICARE "
     if(name in property_container.instruction_for_variable.keys()):
        namedinstr=property_container.instruction_for_variable[name]
        if( hastobeduplicated(namedinstr)>0):
           print " A  ", name , " CORRISPONDE  ", namedinstr
           newdups  = duplication(namedinstr) 
           newinstr = newdups[0]
           newname= newinstr.get_varname()
           prop.set_value(newinstr.get_varname())
           duplicati=duplicati+newdups
        
  return duplicati

def  hastobeduplicated(inst):
   if (inst.get_type()=="Variable") : return 1
   res=0
   for prop in inst.get_properties_list(inst.get_option())+inst.properties_list_fixed[2:]:
     name = prop.get_value()
     if(name in property_container.instruction_for_variable.keys()):
        namedinstr=property_container.instruction_for_variable[name]
        res=res+ hastobeduplicated(namedinstr)
   return res
   

class instruction_base:
  """
     This is the base class of the objects of type instruction.
     These objects manages the options that one can pass
     to an object generating instruction.
     Instruction generating new variables modify the space_of_variable
     dictionary, so that the result of such an instruction  can be
     used to initialise properties for other instructions.
  """

  
  
  help="object  of the class of type instruction base"


  type="base"

  supertype="base"

  generatedtype=None


  def __setstate__(self,dictio):
    self.__dict__=dictio

    new_ob=self.__class__()

    for tok in ["help", "type","supertype","generatedtype"    ]:
      if( getattr(self,tok) != getattr(new_ob,tok)   ):
       setattr(self,tok,getattr(new_ob,tok) )

    todo = [(self.properties_list_fixed,new_ob.properties_list_fixed ) ]

    # correcting a previous bug ... properties_list MUST be a dictionary
    if(type( self.properties_list)!=type({})):
	pass
#	self.properties_list=new_ob.properties_list
    else:
      for option in new_ob.option_dic.keys():
	if (option not in self.option_dic.keys() ):
	     self.option_dic[option]=new_ob.option_dic[option]
	     self.properties_list[option]= new_ob.properties_list[option]
        else:
	    if( type(self.properties_list)==type({})):
  	      todo.append(   (self.properties_list[option]      ,  new_ob.properties_list[option]     )    )
    

    for (propertiesA,propertiesB)  in todo:
        for i in range(len(propertiesA )):	
	     pA=propertiesA[i].property
             pB=propertiesB[i].property
	     for name in [ "property_name","type","argument_key","help","default", "additionaloptions"]:
                if(hasattr(pA,name)):            
 		   setattr(pA,name,getattr(pB,name) )

 	if( len(propertiesA)!=len(propertiesB)):
           for tok in propertiesB[len(propertiesA):]:
              tok.instruction = None   
              propertiesA.append(tok  )
              tok.instruction=self
##        if( len(propertiesA)!=len(propertiesB)):propertiesA.extend([(propertiesB[-1])])    


  def get_type(self):
      """ the variable type is the name of the instruction
      """
      return self.type



  def get_supertype(self):
      """ The string contained in supertype specifies the category
          to which this instruction belongs
      """
      return self.supertype


  def set_active(self):
    self.active=1


  def set_passive(self):
    self.active=0
    name = self.get_varname()
    if(name is not None and name !=""):
       del property_container.instruction_for_variable[name]


  def is_active(self):
    return self.active



  def get_help(self):
    """
      return the help associated with the instruction 
    """
    return self.help


  def get_description(self):
    """ returns the type of the object. The list of
        fixed properties.
        The choosen option.
        The list of properties for the chosen options
    """ 
    res=self.help+"\n"
    res=res+" The type of this object is named " + self.type +"\n"
    for prop in self.properties_list_fixed  :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()
    res=res+"XXXXXXXXXXXXXXXXXXXXXXXX:\n" 
    res=res+(" the chosen option is  %d " % self.option)  + "==> "+ self.option_dic[self.option] +"\n"


    for prop in self.properties_list[self.option] :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()

    res=res+"OOOOOOOOOOOOOOOOOOOOOOOO\n" 
 
    return res

  def __init__(self):
    self.associated_variable="None"
    self.properties_list_fixed=[]
    self.active=0
    self.duplicated=0

    self.ischild = 0
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="associated_variable",
                                  type         ="string_va", # se fosse string semplicemente
                                                             # gli daremo la possibilita di entrare delle variabili
                                                             # string gia definite
                                  value="None" ,             # value shall be a string
                                  argument_key="None",
				  help="The name of the variable which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Comments",
                                  type         ="string_dummy", # dummy  comments cannot be var   
                                  argument_key="None",
				  help="The comment  which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Bidon"

    self.option_dic={1:"base options"}
    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1

  def get_code(self):
     """
       get the code generated by the instruction object 
     """
     s=""
     if(self.properties_list_fixed[0].property.value != "None"):
       s=s+self.properties_list_fixed[0].property.value+"="
     print self.constructor
     s=s+self.constructor[self.option]+"("
     for properties in [self.properties_list_fixed[2:], self.get_properties_list(self.get_option()) ]:
         for p in properties:
           if(p.get_value() != "None" and p.get_value() !="" ):
              if(p.get_argument_key()!="None" and p.get_argument_key() is not None and p.get_argument_key()!=""):
                 s+=p.get_argument_key()+"="+ p.get_value()+","
              else:
                s+= p.get_value()+"," 
     if(hasattr(self,"dummy_arguments")):
       s=s+self.dummy_arguments
     s=s+")\n"
     return s
     
  def get_option(self):
     """
          Instruction objects may have several options. Each option is associated
          with a set of properties to be filled in
     """
     return self.option

  def set_option(self,op):
     """
         change the choosed option
     """
     self.option=op
  
  def get_properties_list(self,op):
     """
       get the option dependent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list[op]

  def  get_properties_list_fixed(self):
     """
       get the option independent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list_fixed

  def get_varname(self):
    """ gives the varname associated with this instruction 
    """
    return self.properties_list_fixed[0].get_value()
  
  def get_option_dic(self):
     """
       Returns the dictionary of options
     """
     return self.option_dic

  def remove_property(self, item):
    print " remove ==== do nothing as default "


  def propertychanged(self):
     pass


class List_instruction(instruction_base):
  """
     This is the base class of the objects of type List.
     It has needed a special treatment because:
        - constructor needs []
        - the option is the # of arguments, and it can be >>1
  """
  
  help="This class build List beans "


  type="List"

  supertype="Sequences"

  accepted_types="any"

  def get_description(self):
    """ returns the type of the object. The list of
        fixed properties.
        The choosen option.
        The list of properties for the chosen options
    """ 
    res=self.help+"\n"
    res=res+" The type of this object is named " + self.type +"\n"
    for prop in self.properties_list_fixed  :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()
    res=res+"XXXXXXXXXXXXXXXXXXXXXXXX:\n" 
    res=res+(" the chosen option is  %d " % self.option)  + "==> "+ self.option_dic[self.option] +"\n"


    for prop in self.properties_list :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()

    res=res+"OOOOOOOOOOOOOOOOOOOOOOOO\n" 
 
    return res

  def __init__(self):
    instruction_base.__init__(self)
    self.associated_variable="None"
    self.properties_list_fixed=[]
    self.active=0
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="associated_variable",
                                  type         ="string_va", # se fosse string semplicemente
                                                             # gli daremo la possibilita di entrare delle variabili
                                                             # string gia definite
                                  value="None" ,             # value shall be a string
                                  argument_key="None",
				  help="The name of the variable which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Comments",
                                  type         ="string_dummy", # dummy  comments cannot be var   
                                  argument_key="None",
				  help="The comment  which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(100):
       self.option_dic[i]= "%s"%i

  def get_code(self):
     """
       get the code generated by the instruction object 
     """
     s=""
     if(self.properties_list_fixed[0].property.value != "None"):
       s=s+self.properties_list_fixed[0].property.value+"="
     s=s+"List(["
     for properties in [self.properties_list_fixed[2:], self.properties_list  ]:
         for p in properties:
             s =s+  p.get_value()+","
     s=s+"])\n"
     return s
     
  def get_option(self):
     """
          Instruction objects may have several options. Each option is associated
          with a set of properties to be filled in
     """
     return self.option

  def set_option(self,op):
     """
         change the choosed option
     """
     for i in range(op,self.option): self.properties_list.pop()



     for i in range(self.option,op):
        newprop =property_container(
                           property(property_name="List entry",
                                type         = self.accepted_types,   
                                argument_key="None",
				help="List entry",
                                default="None"
                                ),
                                self 
                               )
        self.properties_list.append(newprop)
     self.option=op
    

  def remove_property(self, item):
        print " remove ==== do remove"
        print item
        if(item in self.properties_list):
          self.properties_list.remove(item) 
          self.option=self.option-1


  def get_properties_list(self,op):
     """
       get the option dependent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list

  def  get_properties_list_fixed(self):
     """
       get the option independent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list_fixed

  def get_varname(self):
    """ gives the varname associated with this instruction 
    """
    return self.properties_list_fixed[0].get_value()
  
  def get_option_dic(self):
     """
       Returns the dictionary of options
     """
     return self.option_dic

class ListLike_instruction(instruction_base):
  """
     This is the base class of the objects of type List.
     It has needed a special treatment because:
        - constructor does not needs []
        - but  the option is the # of arguments, and it can be >>1
        - the list of option may be  formed by a repeated group of options
  """
  
  help="This class build ListLike beans "


  type="ListLike"

  supertype="Sequences"

  accepted_types="any"

  constructor = "ListLike"

  def get_description(self):
    """ returns the type of the object. The list of
        fixed properties.
        The choosen option.
        The list of properties for the chosen options
    """ 
    res=self.help+"\n"
    res=res+" The type of this object is named " + self.type +"\n"
    for prop in self.properties_list_fixed  :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()
    res=res+"XXXXXXXXXXXXXXXXXXXXXXXX:\n" 
    res=res+(" the chosen option is  %d " % self.option)  + "==> "+ self.option_dic[self.option] +"\n"


    for prop in self.properties_list :
       res=res+"--------- :\n"
       res=res+" PROPERTY :\n"
       res=res+prop.get_description()

    res=res+"OOOOOOOOOOOOOOOOOOOOOOOO\n" 
 
    return res

  def __init__(self):
    self.associated_variable="None"
    self.properties_list_fixed=[]
    self.active=0
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="associated_variable",
                                  type         ="string_va", # se fosse string semplicemente
                                                             # gli daremo la possibilita di entrare delle variabili
                                                             # string gia definite
                                  value="None" ,             # value shall be a string
                                  argument_key="None",
				  help="The name of the variable which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )
    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Comments",
                                  type         ="string_dummy", # dummy  comments cannot be var   
                                  argument_key="None",
				  help="The comment  which is associated to the instruction ",
                                  default="None"
                                ),
                                self 
                               )
                             )



    self.variable_is_active=1
    self.properties_list=[]	
    self.option=0
    self.option_dic={}
    for i in range(10):
       self.option_dic[i]= "%s"%i

  def get_code(self):
     """
       get the code generated by the instruction object 
     """
     s=""
     if(self.properties_list_fixed[0].property.value != "None"):
       s=s+self.properties_list_fixed[0].property.value+"="
     s=s+self.constructor+"("
     for properties in [self.properties_list_fixed[2:], self.properties_list  ]:
         for p in properties:
             s =s+  p.get_value()+","
     s=s+")\n"
     return s
     
  def get_option(self):
     """
          Instruction objects may have several options. Each option is associated
          with a set of properties to be filled in
     """
     return self.option

  def set_option(self,op):
     """
         change the choosed option
     """
     if(op*len(self.groupedproperties)<len(self.properties_list)):
        nprop=(op)*len(self.groupedproperties)
        self.properties_list=self.properties_list[0:nprop]


     for i in range(self.option,op):
        for tok in self.groupedproperties:
          newprop =property_container(
                           property(property_name=tok[0],
                                type         = tok[1],
                                additionaloptions=tok[2],
                                argument_key="None",
				help=tok[3],
                                default="None"
                                ),
                                self 
                               )
          self.properties_list.append(newprop)
     self.option=op
    
  
  def get_properties_list(self,op):
     """
       get the option dependent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list

  def  get_properties_list_fixed(self):
     """
       get the option independent part of options list.
       Returns a list of property_container objects
     """
     return self.properties_list_fixed

  def get_varname(self):
    """ gives the varname associated with this instruction 
    """
    return self.properties_list_fixed[0].get_value()
  
  def get_option_dic(self):
     """
       Returns the dictionary of options
     """
     return self.option_dic




class BEAN_Duplicator(      instruction_base):
  help="This duplicates the instruction on which it is dropped. The objects of type variable thar are contained in the definition of self are duplicated too"
  type="Duplicator"
  supertype="Duplicators"

  def __init__(self):
    beans.instruction_base.__init__(self)
 
















class Insertion_instruction(instruction_base):
  """
     This is the base class of the objects of type Insertion.
     Inserts code that is read from a file 
  """
  
  help="This class inserts code read from a file "


  type="Insertion"

  supertype="Insertion"



  def __init__(self):
    instruction_base.__init__(self)
    self.associated_variable="None"
    self.properties_list_fixed=[]
    self.active=0
    

    
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="File",
                                  type         ="string", 
                                  argument_key="None",
				  help="File to read",
                                  default="None"
                                ),
                                self 
                               )
                             )

    self.lastfileread=""
    self.read=""

    self.variable_is_active=1


    self.option_dic={1:"No options"}
    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1

  def propertychanged(self):
     name=self.properties_list_fixed[0].get_value()
     if (name!=self.lastfileread):
        if( glob.glob(name)!=[]):
           self.read=open(name,"r").read()
           self.lastfileread=name
           
  def get_code(self):
     """
     get the code generated by the instruction object 
     """
     return self.read
  



class  BEAN_CreateVariableArray(instruction_base):

  help="create array  Variable"

  type="CreateVariableArray"

  supertype="Variables"

  def __init__(self):

    instruction_base.__init__(self)
    self.associated_variable="None"

    self.option_dic={1:"no options"}

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Np",
                                  type         ="numeric_i", 
                                  value="10" ,             
                                  argument_key="Np",
				  help="Number of grid points",
                                  default="10"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Xmin",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="Xmin",
				  help="beginning of the grid",
                                  default="0.0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Xmax",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="Xmax",
				  help="End of the grid",
                                  default="0.0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="value",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="value",
				  help="Beginning value for a variable to optimize",
                                  default="1.0"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="MinValue",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="min",
				  help="Minimum value for a variable to optimize",
                                  default="0.7"
                                ),
                                self 
                               )
                             )


    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="MaxValue",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="max",
				  help="Maximum value for a variable to optimize",
                                  default="1.4"
                                ),
                                self 
                               )
                             )

    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="CreateVariableArray"




class BEAN_Variable(      instruction_base):
  help="class Variable"
  type="Variable"
  supertype="Variables"

  def __init__(self):
    instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="startvalue",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="None",
				  help="Initial value for a variable to optimize",
                                  default="0.0"
                                ),
                                self 
                               )
                             )
    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="MinValue",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="None",
				  help="Minimum value for a variable to optimize",
                                  default="0.0"
                                ),
                                self 
                               )
                             )

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="MaxValue",
                                  type         ="numeric_f", 
                                  value="0." ,             
                                  argument_key="None",
				  help="Maximum value for a variable to optimize",
                                  default="0.0"
                                ),
                                self 
                               )
                             )

    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="Variable"



class BEAN_DependentVariable(      instruction_base):
  help=("class DependentVariable\n"
        "You can specify by mean of this class an object whose value \n"
        " is given by a matehmatical  expression function of other variables"
       ) 
  type="DependentVariable"
  supertype="Variables"
  def __init__(self):
    instruction_base.__init__(self)
    self.associated_variable="None"
    self.option_dic={1:"no options"}
    self.dummy_arguments="dictio=locals()"

    self.properties_list_fixed.append(
                               property_container(
                                property(property_name="Expression",
                                  type         ="string_dummy", 
                                  value="" ,             
                                  argument_key="None",
				  help=("example : \n\"2*par( yourvar )+3.1415\"\n"
				        " where yourvar is a variable object that you have specified\n"
                                        " somewhere previously.\n"
                                        " Remember the \"'s \n"
                                        " Expression can be big and contain a lot of other variables\n"
                                        " The token \"par\" is not an option : it is needed by the parser\n"
                                       )
,
                                  default="0.0"
                                ),
                                self 
                               )
                             )

    self.properties_list={}
    self.properties_list[1]=[]	
    self.option=1
    self.variable_is_active=1
    self.constructor={}
    self.constructor[1]="DependentVariable"





