"""
    ColormapEditorWidget.py
    Binding implementation of controls for ColormapSelect
        
"""

from PyDVT import __version__,__date__,__author__


import Tkinter


class ColormapEditorWidget(Tkinter.Frame):
    def __init__(self,parent,initial_colormap,**kw):
        Tkinter.Frame.__init__(self,parent,**kw)
        self.Parent=parent
        self.MinMax=initial_colormap["MinMax"]
        self.Scale=initial_colormap["Scale"]
        self.Colormap=initial_colormap["Colormap"]
        self.AutoScale=initial_colormap["AutoScale"]
        self.AbsoluteMinMax=initial_colormap["AbsoluteMinMax"]
        
        self.scale= Tkinter.IntVar()
        if self.Scale=="Linear": self.scale.set(0)
        if self.Scale=="Logarithmic": self.scale.set(1)
        if self.Scale=="Gamma": self.scale.set(2)
        
        self.rLinear = Tkinter.Radiobutton(self, text="Linear", variable=self.scale, value=0,command=self.Apply)
        self.rLinear.grid(row=0, column=0, columnspan=1, sticky=Tkinter.NW)
        self.rLoga = Tkinter.Radiobutton(self, text="Logarithmic", variable=self.scale, value=1,command=self.Apply)
        self.rLoga.grid(row=1, column=0, columnspan=1, sticky=Tkinter.NW)
        self.rGamma = Tkinter.Radiobutton(self, text="Gamma", variable=self.scale, value=2,command=self.Apply)
        self.rGamma.grid(row=2, column=0, columnspan=1, sticky=Tkinter.NW)
        
        
        Tkinter.Label(self, text="Min:").grid(row=0, sticky=Tkinter.NW,column=1)
        Tkinter.Label(self, text="Max:").grid(row=1, sticky=Tkinter.NW,column=1)

        self.Autoscale = Tkinter.Button(self, text="Autoscale",command=self.ApplyAutoscale)
        self.Autoscale.grid(row=2, column=2, columnspan=1, rowspan=1, sticky=Tkinter.NW)

        #self.auto= Tkinter.IntVar()
        #self.auto.set(self.AutoScale)        
        #self.cAuto = Tkinter.Checkbutton(self, text="Autoscale",variable=self.auto,command=self.Apply)
        #self.cAuto.grid(row=2, column=2, columnspan=1, sticky=Tkinter.NW)

        resol=min((self.AbsoluteMinMax[1]-self.AbsoluteMinMax[0])/100,1)
        self.scrollmin = Tkinter.Scale(self,orient=Tkinter.HORIZONTAL,from_ = self.AbsoluteMinMax[0], to=self.AbsoluteMinMax[1],resolution=resol)
        self.scrollmin.grid(row=0, column=2,  sticky=Tkinter.NW)
        self.scrollmax = Tkinter.Scale(self,orient=Tkinter.HORIZONTAL,from_ = self.AbsoluteMinMax[0], to=self.AbsoluteMinMax[1],resolution=resol)
        self.scrollmax.grid(row=1, column=2,  sticky=Tkinter.NW)
        if self.AutoScale:
            self.DefSliderMinMax(self.AbsoluteMinMax)
        else:
            self.DefSliderMinMax(self.MinMax)

        self.lbCE = Tkinter.Listbox(self)
        for item in ["GrayScale","Temperature","Red","Green","Blue","RevGrey"]:
            self.lbCE.insert(Tkinter.END, item)
            if item== self.Colormap: self.lbCE.select_set(self.lbCE.size()-1)
        
        self.lbCE.grid(row=0, column=3, rowspan=3, sticky=Tkinter.NW)
        #self.lbCE.select_set(self.Colormap-1)
        self.lbCE.bind("<ButtonRelease-1>", self.Apply)
        self.scrollmin.bind("<ButtonRelease-1>", self.ApplyNoAutoscale)
        self.scrollmax.bind("<ButtonRelease-1>", self.ApplyNoAutoscale)
        self.grid(row=0,col=0,sticky="nsew")

    def DefSliderMinMax(self,MinMax):
        self.scrollmin.set(MinMax[0])
        self.scrollmax.set(MinMax[1])

        
    def ApplyAutoscale(self, event=None):
        self.AutoScale=1
        self.Apply(event)

    def ApplyNoAutoscale(self, event=None):
        self.AutoScale=0
        self.Apply(event)
    
    def Apply(self, event=None):
            Scale=self.scale.get()
            
            if Scale==0:
                self.scrollmin.configure(state=Tkinter.NORMAL)                
                Scale="Linear"            
            else:
                self.scrollmin.configure(state=Tkinter.DISABLED)
                if Scale==2: Scale="Gamma"
                if Scale==1:  Scale="Logarithmic"
            MinMax=(self.scrollmin.get(),self.scrollmax.get())

            items = self.lbCE.curselection()
            try:
                items = map(int, items)
            except ValueError: pass
            Colormap=self.lbCE.get(items[0])
            #AutoScale=self.auto.get()
            AutoScale=self.AutoScale
            self.Parent.Apply({"MinMax":MinMax,"Scale":Scale,"Colormap":Colormap,"AutoScale":AutoScale})
            if self.AutoScale: self.DefSliderMinMax(self.AbsoluteMinMax)
