"""
    QtBinding.py
    Pyqt binding to View classes
"""

from PyDVT import __version__,__date__,__author__


import qt
import sys
import types


#Keyboard Codes
KeyCodes = {
    "KEY_LEFT"    : qt.Qt.Key_Left,
    "KEY_UP"      : qt.Qt.Key_Up,
    "KEY_RIGHT"   : qt.Qt.Key_Right,
    "KEY_DOWN"    : qt.Qt.Key_Down,
    }

################################################################################


class Pen:
    def __init__(self,color,width,style):
        self.color=color
        self.width=width
        self.style=style


    def GetStyle(self):
        if   self.style=="solid":          return qt.QPen.SolidLine
        elif self.style=="dashed":         return qt.QPen.DashLine
        elif self.style=="dotted":         return qt.QPen.DotLine
        elif self.style=="hidden":         return qt.QPen.NoPen
        else:                              raise  "QtBinding: Pen style error"

    def GetColor(self):
        return qt.QColor(self.color[0],self.color[1],self.color[2])

    def GetWidth(self):
        if self.width==1: return 0
        return self.width
        

class Brush:
    def __init__(self,color,style):
        self.color=color
        self.style=style
    
    def GetStyle(self):
        if   self.style=="fill_100":       return qt.QBrush.SolidPattern
        elif self.style=="fill_75":        return qt.QBrush.Dense3Pattern
        elif self.style=="fill_50":        return qt.QBrush.Dense4Pattern
        elif self.style=="fill_25":        return qt.QBrush.Dense5Pattern
        elif self.style=="fill_12":        return qt.QBrush.Dense6Pattern
        elif self.style=="fill_0":         return qt.QBrush.NoBrush
        else:                              raise  "QtBinding: Brush style error"


    def GetColor(self):
        return qt.QColor(self.color[0],self.color[1],self.color[2])


class Container(qt.QVBox):
    def __init__(self,parent=None,**kw):
        self.init=1
        qt.QVBox.__init__(self,parent)

    def GetHeight(self):
        return self.height()

    def GetWidth(self):
        return self.width()

    def IsVisible(self):
        return  self.isVisible() or self.init

    def Show(self):
        self.show()
        self.init=0

    def SetSize(self,width,height):
        self.resize(width,height)

    def SetPointer(self,pointer):
        if pointer=="arrow":self.Drawable.GetViewport().setCursor(qt.QCursor(0))
        elif pointer=="cross":self.Drawable.GetViewport().setCursor(qt.QCursor(2))
        elif pointer=="wait": self.Drawable.GetViewport().setCursor(qt.QCursor(3))
        elif pointer=="h_double_arrow":self.Drawable.GetViewport().setCursor(qt.QCursor(6))
        elif pointer=="v_double_arrow":self.Drawable.GetViewport().setCursor(qt.QCursor(5))
        



class Scrollbar(qt.QScrollBar):
    def __init__(self,parent,drawable,type="vertical"):
        self.parent=parent
        self.drawable=drawable
        self.type=type
        if type=="horizontal":
            qt.QScrollBar.__init__(self,qt.QScrollBar.Vertical,parent)
            #drawable.configure(xscrollcommand=self.set,xscrollincrement='1p')
        else:
            qt.QScrollBar.__init__(self,qt.QScrollBar.Horizontal,parent)
            #drawable.configure(yscrollcommand=self.set,yscrollincrement='1p')
        

    def SetContinousScroll(self,flag):
        pass

    def SetCommand(self,command):
        pass
    

    def GetHeight(self):
        return self.height()

    def GetWidth(self):
        return self.width()

    def Erase(self):
        self.hide()

    def Show(self):
        self.show()

    def GetPosition(self):
        pass
        
        

    def _EventScroll(self, *arguments, **keywords):
        pass        



class Menu(qt.QPopupMenu):
    def __init__(self,parent):
        qt.QPopupMenu.__init__(self,parent)
        self.setCheckable(1)
        self.parent=parent
        self.DispatchDict={}
        self.CascadeList=[]
        self.RadioDict={}

    def MenuDispatch(self,i):
        com= self.DispatchDict[i]
        for radio in self.RadioDict.keys():
            if self.RadioDict[radio]==i: self.SetCheckedRadio(radio)
        if (type(com) is  types.FunctionType)or ((type(com) is  types.MethodType)): com()
        else: com.func(*com.args,**com.kw)
        
    def AddCommand(self,label,command,style='command'):        
        if ((type(command) is  types.FunctionType)or ((type(command) is  types.MethodType)))and style!="radiobutton":
            index=self.insertItem(label,command)
        else:
            index=self.insertItem(label,self.MenuDispatch)
            self.DispatchDict[index]=command
            if style=="radiobutton":
                self.RadioDict[label]=index
                self.setItemParameter ( index, index )
            else:                                
                self.setItemParameter ( index, index )
                
        return index
            

    def AddCascade (self,label,menu):
        self.CascadeList.append(menu)
        return self.insertItem(label,menu)
        
    def AddSeparator (self):
        index=self.insertSeparator()
        return index

    def GetItemType(self,index):
        return self.type(index)
    
    def CheckItem(self,index,check):
        self.setItemChecked(index,check)

    def IsItemChecked(self,index):
        return self.isItemChecked(index)

    def SetCheckedRadio(self,name):
        for item in self.RadioDict.keys():
            if item==name:self.CheckItem(self.RadioDict[item],1)
            else:self.CheckItem(self.RadioDict[item],0)

    def DisableItem (self,index):
        self.setItemEnabled( index, 0 )        

    def EnableItem (self,index):
        self.setItemEnabled( index, 1 )        

    def DeleteItem (self,index):
        self.removeItem(index)

    def Show (self,Position):
        self.exec_loop(Position)

    def Destroy(self):
        for cascade in self.CascadeList:
            cascade.Destroy()
        self.DispatchDict=None

        
class Dialog(qt.QDialog):

    def __init__(self, parent, title = None, modal=0,resizable=0,expand_container=0):
        qt.QDialog.__init__(self, parent, title, modal)
        self.Destroyed=0
        self.modal=modal
        self.resizable=resizable
        self.setCaption(title)
        self.expand_container=expand_container
        #self.setSizePolicy(qt.QSizePolicy(qt.QSizePolicy.Fixed,qt.QSizePolicy.Fixed))

    def AddContainer(self,container):
        self.Container=container
    
    def Show(self):
        if self.modal:
            qt.QDialog.exec_loop(self)
        else:
            qt.QDialog.show(self)

    def showEvent(self,e):
        if not self.resizable:
            self.setMinimumSize(self.width(),self.height())
            self.setMaximumSize(self.width(),self.height())

    def SetSize(self,width,height):
        self.resize(width,height)      
    
    def hideEvent(self,e):
        self.Destroyed=1
        qt.QDialog.hideEvent(self,e)

    def resizeEvent(self,e):
        if self.expand_container and hasattr(self,"Container"): self.Container.SetSize(self.width(),self.height())        

    def IsDestroyed(self):
        return self.Destroyed

#class Label(qt.QStatusBar):
class Label(qt.QLabel):
    def __init__(self,parent):
        #qt.QStatusBar.__init__(self,parent,)
        qt.QLabel.__init__(self,parent,)
        
    def Show(self):
        if qt.qVersion()>="3.0.0": 
            self.setSizePolicy(qt.QSizePolicy(qt.QSizePolicy.Ignored,qt.QSizePolicy.Fixed))
        else:
            self.setSizePolicy(qt.QSizePolicy(qt.QSizePolicy.Expanding,qt.QSizePolicy.Fixed))
        self.show()

    def Hide(self):
        self.hide()

    def SetText(self,str):
        self.setText(str)
        self.repaint()
        #self.message(str)


class Timer (qt.QTimer):
    def __init__(self,parent,callback):
        self.callback=callback
        qt.QTimer.__init__(self,parent)
        self.connect( self, qt.SIGNAL("timeout()"), self.callback )

        
    def Start(self,interval,single_shot=0):
        qt.QTimer.start(self,interval,single_shot)

    def Stop(self):
        qt.QTimer.stop(self)

#Atention: qt.QColor.numBitPlanes just after qApp has been created.
#(QApplication object should be created before any PyDVT object)
def GetDisplayProperties():
    if qt.QColor.numBitPlanes()==8: DISPLAY_DEPTH=8
    else: DISPLAY_DEPTH=32
    return {"SPSLUT_MODE":"BGRX","ALIGN_8BIT_IMAGES":1,"DISPLAY_DEPTH":DISPLAY_DEPTH}