#include<iostream.h>
#include<math.h>
#include<nMatrix/nMatrix.h>
#include<nMatrix/nLapack.h>
extern "C" {

  void  MAIN__() { };
}

class accoppiata {
public:
  void  operator =(const accoppiata &a) ;
  int spin[100];
  int nmezzi;
  
};

int operator == (accoppiata &a,accoppiata & b) {
  if(a.nmezzi!=b.nmezzi) return 0;
  for(int i=0; i<a.nmezzi; i++) {
    if(a.spin[i]!=b.spin[i]) return 0;
  }
  return 1;
}

#define NACCMAX 1000

class buffer {
public:
  buffer();
  void aggiungi(accoppiata &a, double fact);
  void aggiungi(buffer &b) ;
  void operator=(buffer  &a);
  void normalizza();
  accoppiata acc[NACCMAX];
  double fact[NACCMAX];
  int nacc;
};

void buffer:: operator = ( buffer &a) {
  nacc=a.nacc;
  for(int i=0; i< nacc; i++) {
    fact[i]=a.fact[i];
    acc[i]=a.acc[i];
  }

}
 
double scalare ( buffer &a, buffer &b) {
  double somma=0;
  for(int i=0; i<a.nacc;i++) {
    for(int j=0; j<b.nacc;j++) {
      if(a.acc[i]==b.acc[j]) {
	somma+= a.fact[i]*b.fact[j];
      }
    }
  }
  return somma;
}

void buffer::normalizza() {
  double somma=0;
  for(int i=0; i<nacc;i++) {
    somma+= fact[i]*fact[i];
  }
  somma=sqrt(somma);
  for(int i=0; i<nacc;i++) {
    fact[i]/=somma;
  }
}



void operatoreLm(accoppiata &a, double f, buffer &buff) {
  accoppiata b;
  for(int i=0; i<a.nmezzi;i++) {
    if(a.spin[i]==1) {
      b=a;
      b.spin[i]=-1;
      buff.aggiungi(b,f);
    }
  }
}

void operatoreLp(accoppiata &a, double f, buffer &buff) {
  accoppiata b;
  for(int i=0; i<a.nmezzi;i++) {
    if(a.spin[i]==-1) {
      b=a;
      b.spin[i]=1;
      buff.aggiungi(b,f);
    }
  }
}


void rotazioneTheta(accoppiata &a, double f,double theta,  buffer &buff) {
  accoppiata b;
  buffer add1,add2,*ba,*bb;
  ba=&add1;
  bb=&add2;
  (*bb).nacc=0;
  (*ba).nacc=0;
  (*ba).aggiungi( a,f);
  for(int i=0; i<a.nmezzi;i++) {
    for(int j=0; j< (*ba).nacc; j++) {
      if((*ba).acc[j].spin[i]==1) {
	b=(*ba).acc[j];
	b.spin[i]=1;
	(*bb).aggiungi(b,(*ba).fact[j]*cos(theta/2));
	b=(*ba).acc[j];
	b.spin[i]=-1;
	(*bb).aggiungi(b,(*ba).fact[j]*sin(theta/2));
      }   
      if((*ba).acc[j].spin[i]==-1) {
	b=(*ba).acc[j];
	b.spin[i]=-1;
	(*bb).aggiungi(b,(*ba).fact[j]*cos(theta/2));
	b=(*ba).acc[j];
	b.spin[i]=1;
	(*bb).aggiungi(b,-(*ba).fact[j]*sin(theta/2));
      }   
    }
    buffer *dump;
    dump=ba;
    ba=bb;
    bb=dump;
    (*bb).nacc=0;
  }
  buff.aggiungi(*ba);
}


void  accoppiata::operator =(const accoppiata &a) {
  nmezzi=a.nmezzi;
  for(int i=0;i<nmezzi;i++) spin[i]=a.spin[i];
  return;
}
void buffer::aggiungi(buffer &b) 
{
  for(int i=0; i<b.nacc; i++) {
    aggiungi(b.acc[i],b.fact[i]);
  }

};


void buffer:: aggiungi(accoppiata &a, double f) {
  for(int i=0; i<nacc; i++) {
    if(a==acc[i]) {
      fact[i]+=f;
      return;
    }
  }
  if(nacc==NACCMAX) {
    cout << " KAPUTT\n";
    exit(0);
  }
  acc[nacc]=a;
  fact[nacc]=f;
  nacc++;
  return;
} 


buffer::buffer() {
  nacc=0;
}


void inizializzaTtop(accoppiata & a, int n) {
  a.nmezzi=n;
  for(int i=0; i<a.nmezzi; i++) {
    a.spin[i]=1;
  }
}




uMatrix<complex<double> > rotazione(double theta, double psi)  {
 
  accoppiata a;
  inizializzaTtop(a,4);
  uMatrix<complex<double> > rota(5,5);
  buffer stati[5];
  stati[4].aggiungi(a,1);
  
  
  for(int n=3; n>=0; n--) {
    for(int i=0; i<stati[n+1].nacc; i++) {
      operatoreLm(stati[n+1].acc[i],stati[n+1].fact[i], stati[n] );
    }
    stati[n].normalizza();
  }
  
  for(int n=4; n>=0;n--) {
    buffer res;
    res.nacc=0;
    for(int i=0; i< stati[n].nacc; i++) {
      rotazioneTheta(stati[n].acc[i] ,stati[n].fact[i] ,theta , res) ;
    }
    for(int j=4; j>=0; j--) {
      rota(j,n )=scalare(res, stati[j] )  ;
    }  
  }

  for(int j=4; j>=0; j--) {
    for(int n=4; n>=0;n--) {
      rota(j,n )=  rota(j,n )*exp( complex<double>(0,1)* (n-j)*psi   ) ;
    }
  }  
  
  return rota;
}


main() {


  /* Initialization of the C matrix ( see paper) */
  uMatrix<complex<double> > C(5,5), res(5,5),r;
  C=complex<double > (0.0);
  C(2,2)=1;

  /* COMPRESSED OCTAHEDRON a/c = 1.05 distances = R-05 
  double theta[]= { 0.0, M_PI, M_PI/2, M_PI/2, M_PI/2, M_PI/2 };
  double psi  []= { 0,    0, 0,        M_PI/2, M_PI, 3*M_PI/2 };  
  double peso []= { 1.28, 1.28, 1, 1, 1, 1 };
  int npunti=6;
  */

  /*
    specify here the position of the  Neighbouring atoms atoms.
    npunti is their number.
    peso is the array of weights.
    psi is the array of azimuth
    theta is the array of zenith ( 0 means vertical )
  */  

  /* REGULAR OCTAHEDRON 
  double theta[]= { 0.0, M_PI, M_PI/2, M_PI/2, M_PI/2, M_PI/2 };
  double psi  []= { 0.0, 0.0, 0.0, M_PI/2, M_PI, 3*M_PI/2 };
  double peso []= { 1, 1, 1, 1, 1, 1 };
  int npunti=6;
  */

  /* REGULAR TETRAHEDRON 
  double Theta =asin( sqrt(2.0)/sqrt(3.0) );
  double theta[]= { Theta, Theta, M_PI-Theta, M_PI - Theta };
  double psi  []= { M_PI/4, 5*M_PI/4,    3*M_PI/4,  7*M_PI/4   };  
  double peso[]= {  1, 1, 1, 1 };
  int npunti=4;
  */

  /* REGULAR A POSITIONS IN MANGANITES
  double Theta =asin( sqrt(2.0)/2.0 );
  double theta[]= { Theta, Theta, Theta, Theta, M_PI/2, M_PI/2, M_PI/2, M_PI/2, M_PI-Theta, M_PI-Theta, M_PI-Theta, M_PI-Theta };
  double psi[]= { 0.0, M_PI/2, M_PI, 3*M_PI/2, M_PI/4, 3*M_PI/4, 5*M_PI/4, 7*M_PI/4, 0.0, M_PI/2, M_PI, 3*M_PI/2, M_PI/4 };
  double peso[]= { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
  int npunti=12;
  */
    
  /* REGULAR OCTAHEDRON 
  double theta[]= { 0.0, M_PI, M_PI/2, M_PI/2, M_PI/2, M_PI/2 };
  double psi  []= { 0.0, 0.0, 0.0, M_PI/2, M_PI, 3*M_PI/2 };
  double peso []= { 0.17  ,  0.17 , 1, 1, 1, 1 };
  int npunti=6;
  */
  {
    /* LS Fe+6N ( Neisius, Vanko) */
    double theta[]= {0.79070244515054777, 0.79070076136033218, 1.6510523506733441, 1.6510512929048022, 2.3384901804941376, 2.3384831776145281};
    double psi  []= {-0.85454061796902969, 2.2870520356207633, 0.66381087260040439, -2.4777831147890748, -1.0299473022374279, 2.1116492402420124};
    double peso []= {1.1401402646783971, 1.1401288677256183, 0.95976408910255584, 0.95976135781085425, 0.98516401265782971, 0.98516382393180368};
    int npunti=6;

    res=complex<double > (0.0);
    
    
    /*
      for each neighbooring atom, we similitude-transform C
      and add it to res
    */
    for(int i=0; i<npunti; i++) {
      r=rotazione(theta[i]+0.001, psi[i]+0.9185); 
      // cout << r << endl<< endl;
      res+= peso[i]/1.*uInv(r)* C*r;
    }

    cout << res << endl;
  
  cout << " ############ \n" <<  imag(res)<< " ############ \n";
  uMatrix<double> rres=real(res);
  for(int i=0; i<5; i++) for(int j=0; j<5; j++) if(fabs(rres(i,j))<0.000001) rres(i,j)=0;
  cout << " ######################## Low SPIN ###########################\n";
  cout << rres << endl;
  }

  double iiimax=1000,iimax;
  // for(double dteta=0 ; dteta<0.1; dteta+=0.05)
  // for(double dpsi=0; dpsi<3.15; dpsi+=0.01)

  {
    /* HS Fe+6N ( Neisius, Vanko) */
    double theta[]= {0.82791682420278689, 0.82793207302502025, 1.7440974397294724, 1.7441259082503922, 2.3651438424073596, 2.3652042055783609};
    double psi  []= {-0.74028462440997544, 2.4013080291798179, 0.67670218064019505, -2.4648814575908737, -1.0647409482827332, 2.0768170046567067};
    double peso []= {0.84486588301137355, 0.84493687528636541, 0.56723152577390745, 0.56722629103264877, 0.54592095679030372, 0.54591110627630046};
    int npunti=6;
    
    
    res=complex<double > (0.0);
    
 
    /*
      for each neighbooring atom, we similitude-transform C
      and add it to res
    */
    for(int i=0; i<npunti; i++) {
      r=rotazione(theta[i], psi[i]+0.9185); 
      // cout << r << endl<< endl;
      res+= peso[i]/1.*uInv(r)* C*r;
    }
    cout << " ############ \n" <<  imag(res)<< " ############ \n";
    uMatrix<double> rres=real(res);
    for(int i=0; i<5; i++) for(int j=0; j<5; j++) if(fabs(rres(i,j))<0.000001) rres(i,j)=0;
    cout << " ######################## High SPIN ###########################\n";
    cout << rres << endl;    
    
  }
  
  
}
  
  













