/***************************************************************************
									    main.cpp  -  description
									    -------------------
									    begin                : Mon Jun 5 2000
									    copyright            : (C) 2000 by 
									    email                : 
***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include<nMatrix/nMatrix.h>
#include<nMatrix/nLapack.h>
#include<Sparsa/Sparsa.h>
#include"../atomosferico/fichier.h"
#include"../atomosferico/hfs.h"
#include"../atomosferico/integrate.h"
#include"../atomosferico/wigner.h"

#include"../libasfhfs/asfhfs.h"
#include<../LinearInterpolation/Linear_Interpolation.h>
char * utilizzo= "  D+ Dz D-        D+ Dz D-      NumeroIngredienti ..... mat1base   peso1 .... matnbase   peson     \n"
		"                               mat1exci  .... matnexci     \n"
		"                               mat1base2  .... matnbase2     \n"
		"  dene temp   ei1 ei2      npi    e1 e2 np  fileallargamentiexc    fileallargamentibase2     maxit tol\n";
char opzioni[]="nientemomenti";


int main(int argc, char *argv[])
{
  cout << "Hello, World!" << endl;
  if (argc==1) {
    cout << utilizzo << endl;
    exit(0);
  }
  
  Sparsa3A dipolia[3], dipolib[3];

  for(int i=0; i<3; i++) {
    dipolia[i].inizializza(argv[i+1]);
    cout << " dipolia[i].dim " << dipolia[i].dim << endl; 
  }

  for(int i=0; i<3; i++) {
    dipolib[i].inizializza(argv[i+4]);
	dipolib[i].transpose();
    cout << " dipolib[i].dim " << dipolib[i].dim << endl;

  }
  
  int nh;
  sscanf(argv[7],"%d",&nh);
  double pesi[nh];
  Sparsa3A Hbase, Hex, Hbase2;
  
  for(int i=0; i<nh; i++) {
    sscanf(argv[9+2*i],"%le",&pesi[i]);
  }
  
  for(int i=0; i<nh; i++) {
    cout << " aggiungo il file " << argv[8+2*i] << "  con peso " <<pesi[i] << endl;
    Hbase.sommaFast( argv[8+2*i], pesi[i] );
  }

  for(int i=0; i<nh; i++) {
    cout << " aggiungo il file " << argv[8+ 2*nh + i] << "  con peso " <<pesi[i] << endl;
    Hex.sommaFast( argv[8+ 2*nh  +i], pesi[i] );
  }

  for(int i=0; i<nh; i++) {
    cout << " aggiungo il file " <<argv[8+3*nh+i] << "  con peso " <<pesi[i] << endl;
    Hbase2.sommaFast( argv[8+3*nh+i], pesi[i] );
  }
  cout << Hbase.dim << " " << Hex.dim << " "<< Hbase2.dim << endl; 
  uMatrix<double> H2,eval,evect,Tevect;
  // Hbase2.ottieniuM(H2);
  // cout << Hbase2.dim << "  " << H2.rows() << " " << H2.columns() << endl;
  // uSymEig(H2,evect,eval);
  // Tevect=evect;
  // Tevect.transpose();

  double DENE, temp;
  sscanf( argv[8+4*nh],"%le",&DENE );
  sscanf( argv[8+4*nh+1],"%le",&temp );
  
  double ei1,ei2;
  int    npi ;
  
  double e1,e2,ene;
  int    np;
  
  sscanf( argv[8+4*nh+2],"%le",&ei1 );
  sscanf( argv[8+4*nh+3],"%le",&ei2 );
  sscanf( argv[8+4*nh+4],"%d",&npi );
  
  sscanf( argv[8+4*nh+5],"%le",&e1 );
  sscanf( argv[8+4*nh+6],"%le",&e2 );
  sscanf( argv[8+4*nh+7],"%d", &np );
  
  Linear_Interpolation<double,double>  allargamentiexc, allargamentibase;
  allargamentiexc.read_file(argv[8+4*nh+8]);
  allargamentibase.read_file(argv[8+4*nh+9]);
  
  int nit;
  sscanf(argv[8+4*nh+10],"%d",&nit);
  double tole;
  sscanf(argv[8+4*nh+11],"%le",&tole);
  
  
  cout << " nit " << nit << endl;
  cout << " tole " << tole << endl;
  
  uMatrix<double> eVect, eVal;
  Risolutore H;
  H.inizializza(Hbase);
  H.diagonalizzaH(DENE, eVect, eVal );
  
  double sommapart=0;
  for(int k=0; k< eVal.rows(); k++) {
    double expo=-(eVal(k) -eVal(0))/temp ;
    if(expo>-12) {
      sommapart+=exp( - (eVal(k)-eVal(0))/temp);
    }
  }
  
  double *dumai, *dumar,  *dumbr[3][3],  *dumbi[3][3],  *dum, *dumcr, *dumci, *res[3][3][3][3], *resi[3][3][3][3];
  
  dum  = new double [ Hex.dim];
  
  dumar= new double [Hex.dim];
  dumai= new double [Hex.dim];
  memset(dumai,0, 8*     Hex.dim);
  memset(dumar,0, 8*     Hex.dim);



  for(int idipa=0; idipa<3; idipa++) {	
    for(int idipb=0; idipb<3; idipb++) {	
      dumbr[idipa][idipb]= new double [Hbase2.dim];
      dumbi[idipa][idipb]= new double [Hbase2.dim];
      for(int idipa2=0; idipa2<3; idipa2++) {	
	for(int idipb2=0; idipb2<3; idipb2++) {	
	  res[idipa][idipb][idipa2][idipb2]= new double [np];
	  resi[idipa][idipb][idipa2][idipb2]= new double [np];
	  memset(            res[idipa][idipb][idipa2][idipb2], 0, np*8);
	  memset(            resi[idipa][idipb][idipa2][idipb2], 0, np*8);
	}
      }      
    }
  }
  
  dumcr= new double [Hbase2.dim];
  dumci= new double [Hbase2.dim];
  memset(dumcr,0, sizeof(double)*  Hbase2.dim);
  memset(dumci,0, sizeof(double)*  Hbase2.dim);

  FILE *out= fopen("risultato","w");
  
  for(int ne=0; ne<npi; ne++)
    {
      for(int k=0; k<np; k++)  
      for(int idipa=0; idipa<3; idipa++) {	
	for(int idipb=0; idipb<3; idipb++) {	
	  for(int idipa2=0; idipa2<3; idipa2++) {	
	    for(int idipb2=0; idipb2<3; idipb2++) {
	      for(int i=0; i<np; i++) res[idipa][idipb][idipa2][idipb2][k]=0;
	      for(int i=0; i<np; i++) resi[idipa][idipb][idipa2][idipb2][k]=0;
	    }
	  }
	}
      }
      
      for(int k=0; k< eVal.rows(); k++)
	{
	  double enebase, peso;
	  enebase=eVal(k);
	  double expo=-(enebase-eVal(0))/temp ;
	  if(expo<-12) continue;
	  peso=exp(-(enebase-eVal(0))/temp) /sommapart;
	  
	  ene= (ne*ei2 + (npi-ne-1)*ei1)/(npi-1);
	  
	  for(int idipa=0; idipa<3; idipa++)
	    {
              cout << " pol " << idipa << endl;		
	      memset(dum,0, Hex.dim*sizeof(double) );
	      dipolia[idipa].Moltiplica(dum,  eVect.address() + k*eVect.rows() );
	      
	      Sparsa3A dainvertire;
	      dainvertire.inizializza(Hex);
	      dainvertire.trasforma(1, -(enebase+ene) );
	      
	      double epsilon= allargamentiexc(ene);
	      cout << " ene " << ene << endl;
	      
	      dainvertire.solveCGSym2menoImag( dumai, dum, epsilon*epsilon , tole, nit, dumai);
	      cout << " ene OK " << ene << endl;
	      
	      memset(dumar,0, Hex.dim*sizeof(double) );
	      dainvertire.Moltiplica(dumar ,  dumai );
	      
	      normalizza(dumai, 1./epsilon  , Hex.dim);
	      
	      for(int idipb=0; idipb<3; idipb++) {
                cout << " idipb " << idipb<< endl;
		memset(dumbr[idipa][idipb],0, Hbase2.dim*sizeof(double) )
;
                 cout << " molt\n";
		dipolib[2-idipb].Moltiplica(dumbr[idipa][idipb],  dumar );
	         	
		memset(dumbi[idipa][idipb],0, Hbase2.dim*sizeof(double) );
                 cout << " molt\n";

		dipolib[2-idipb].Moltiplica(dumbi[idipa][idipb],  dumai );
                 cout << " OK\n"; 
	      }
              cout << " next pol\n";	
	    }
	  
	  
	  
	  for(int ne=0; ne<np; ne++)
	    {
                cout << " ne = " << ne << endl;
	      double enemis= (ne*e2 + (np-ne-1)*e1)/(np-1);
	      
	      Sparsa3A dainvertire;
	      dainvertire.inizializza(Hbase2);
	      dainvertire.trasforma(1, -(enebase+ene-enemis) );
	      
	      
	      double epsilon= allargamentibase(ene-enemis);
	      
	      for(int idipa=0; idipa<3; idipa++)
		{		
		  for(int idipb=0; idipb<3; idipb++)
		    {		
		      cout << " inversione " << enemis << endl;
		      
		      uMatrix<double> ar(   Hbase2.dim , 1  )     ;
		      uMatrix<double> ai(   Hbase2.dim , 1   ) ;
		      uMatrix<double> cr(   Hbase2.dim , 1   )  ;
		      uMatrix<double> ci(   Hbase2.dim , 1   ) ;
		      memcpy(&ar(0), dumbr[idipa][idipb], Hbase2.dim*8);
		      memcpy(&ai(0), dumbi[idipa][idipb], Hbase2.dim*8);
		      
		      dainvertire.solveCGSym2menoImag( dumci,dumbr[idipa][idipb],epsilon*epsilon , tole, nit, dumci);
		      dainvertire.solveCGSym2menoImag( dumcr, dumbi[idipa][idipb],epsilon*epsilon , tole, nit, dumcr);
		      cout << " cucu " << endl;
		      // ci=Tevect*ai;
		      // for(int i=0; i<Hbase2.dim; i++) {
		      //	ci(i) =ci(i)*epsilon /( (eval(i,i) -(enebase+ene-enemis))*
		      //				(eval(i,i) -(enebase+ene-enemis))+epsilon*epsilon     );
		      // }
		      // ci=evect*ci;
		      // cr=Tevect*ar;
		      // for(int i=0; i<Hbase2.dim; i++) {
		      //	cr(i) =cr(i)*epsilon /( (eval(i,i) -(enebase+ene-enemis))*
		      //				 (eval(i,i) -(enebase+ene-enemis))+epsilon*epsilon     );
		      // }
		      // cr=evect*cr;
		      
		      // memcpy(dumcr,&cr(0), Hbase2.dim*8);
		      // memcpy(dumci,&ci(0), Hbase2.dim*8);
		      // cout << " inversione  OK" << endl;
		      
		      normalizza(dumci, 1/epsilon, Hbase2.dim );
		      normalizza(dumcr,-1/epsilon, Hbase2.dim );
		      
		      for(int idipa2=0; idipa2<3; idipa2++)
			{		
			  for(int idipb2=0; idipb2<3; idipb2++)
			    {		
			      res[idipa][idipb][idipa2][idipb2][ne]+= peso* (  scalare(dumcr,dumbr[idipa2][idipb2], Hbase2.dim )+
									       scalare(dumci ,dumbi[idipa2][idipb2], Hbase2.dim )  )  ;
			      resi[idipa][idipb][idipa2][idipb2][ne]+= peso* (  scalare(dumci,dumbr[idipa2][idipb2] , Hbase2.dim )-
									       scalare(dumcr ,dumbi[idipa2][idipb2] , Hbase2.dim )  )  ;
			    }
			}
		    }
		}
	      
	    }
	}
      for(int ne=0; ne<np; ne++) {					
	double enemis= (ne*e2 + (np-ne-1)*e1)/(np-1);
	fprintf(out,"%e %e ",ene*27.2,enemis*27.2 );
	for(int idipa=0; idipa<3; idipa++)
	  {		
	    for(int idipb=0; idipb<3; idipb++)
	      {		
		  for(int idipa2=0; idipa2<3; idipa2++)
		    {		
		      for(int idipb2=0; idipb2<3; idipb2++)
			{		
			  	 fprintf(out,"        %e         ",    res[idipa][idipb][idipa2][idipb2][ne]);
			  	 fprintf(out,"        %e         ",    resi[idipa][idipb][idipa2][idipb2][ne]);
			}
		    }
	      }
	  }
	
	fprintf(out,"\n " );
	
      }
    }
  
  fclose(out);  
  return EXIT_SUCCESS;
}
