import sys
from PyQt4.Qt import *
from general_Tree import Tree
from Tree_View import TreeView


class DocMenager(QObject):
	def __init__(self,parent,*args):
		apply(QObject.__init__,(self,)+args)
		self.parent=parent
		self.viewManager=parent.viewsSpace # ????

		self._docToView={}
		self._viewToDoc={}

	def _createView(self,document,viewClass):
	#def _createView(self,document,,viewClass):
		view=viewClass(document,self.parent.actions,self.viewManager)#on a cree l'instance de QTextEdit
		view.show()
		view.setCaption(document.title)# il faut creer cette propriete !!!
		#view.setMaximumSize(self.parent.maxSizeForDoc)
		#view.setMinimumSize (self.parent.maxSizeForDoc)

		self.emit(PYSIGNAL('sigCreatview'),(view,))
		return view

	#creation des documents
	def createDocument(self,docClass=Tree,viewClass=TreeView):
		document=docClass()# on a cree une instence du Tree
		view=self._createView(document,viewClass)#on a cree le view pour ce document
		#on a ajoute dans les dict de liens
		if self._docToView.has_key(document):
			self._docToView[document].append(view)
		else:
			self._docToView[document]=[view]
		self._viewToDoc[view]=document

		self.emit(PYSIGNAL('sigCreatDoc'),(document,))
		self.emit(PYSIGNAL('sigChangedNumberOfDoc'),())
		return document

	def numberOfDocuments(self):
		return len(self._docToView)

	def numberOfView(self):
		return len(self._viewToDoc)

	#renvoie la liste de touts les view (c'est pour le cas general)
	def view(self,document):
		views=[]
		if self._docToView.has_key(document):
			views=self._docToView[document]
		return views

	#renvoie le document correspondant a ce view
	def document(self,view):
		#print self._viewToDoc.keys()
		document=None
		if self._viewToDoc.has_key(view):
			document=self._viewToDoc[view]
		#print "documnet", document
		return document

	def documentWhithName(self,fileName):
		res=None
		listOfDoc=self._docToView.keys()#la liste de touts les doc.
		i=0
		n=len(listOfDoc)
		while(i<n and listOfDoc[i].getFileName()!=fileName):
			i+=1
		if (i!=n):
			res=listOfDoc[i]
		return res


	# verifie si le document a ete modifie, dans ce cas il demande a utilisateur
	'''def _queryCloseDocument(self,document):
		closeDocument=1
		if (document.isModified()):
			closeDocument=self.parent.queryCloseDocument(document)
		return closeDocument'''

	def _removeView(self,document,view):
		try:
			# il faut l'enlee dans les 2 dicts
			self._docToView[document].remove(view)
			del self._viewToDoc[view]
		except: pass

	def closeView(self,view):
		view.closeView=1
  		document=self._viewToDoc[view]
		if (len(self._docToView[document])==1): #le cas de fermeture du dernier view
			#if(self._queryCloseDocument(document)):# l'utilisateur a permi de fermer ce document
			if(self.parent.queryCloseDocument(document)):# l'utilisateur a permi de fermer ce document
				self._removeView(document,view)
				del self._docToView[document]
				self.emit(PYSIGNAL('sigChangedNumberOfDoc'),())
			else:
				view.closeView=0
		else: # c'est pas le dernier view
			self._removeView(document,view)
		#il faut changer actifView dans App si on a ferme le view
		if (view.closeView and len(self._viewToDoc)>0):
			self.parent.actifView=None #self._viewToDoc[-1]
		return view.closeView

	def closeDocument(self,document):
		closeDoc=1
		listOfViews=self._docToView[document]
		for view in listOfViews:
			self.parent.setActifView(view)
			if (not view.close(1)): # a verifier si cela provoque closeView
				closeDoc=0
		return closeDoc


	def closeAll(self):
		closeAll=1
		for document in self._docToView.keys():
			if (not self.closeDocument(document)):
				closeAll=0
				strWarning="Document "+ document.title+" can't be close !"
				self.emit(PYSIGNAL('sigMessageWarning'),(strWarning,))#a connecter dans TreeApp
		return closeAll

