from numpy.oldnumeric  import *
from  PPMlayerclassTens import *
from dabax import *
from minimiser import *
import string

stacks=[ PPM_Stack()  for i in range(10)  ]
scan2stack={}
scanlist=[]
cutoffs_list=[]
scannoises_list=[]
scannorms_list=[]
angleshift_list=[]
tf0=Dabax_f0_Table("f0_WaasKirf.dat")
tf12=Dabax_f1f2_Table("f1f2_Windt.dat")
Co_ind_one=IndexFromTable(tf0, tf12,"Co",1.0)
Si_ind_one=IndexFromTable(tf0, tf12,"Si",1.0)
betaCominus=BetaManipulator_ContributionsFromFile("cobetam",shift=0.0,factor=1/8.,rescaleXlambda=0)
betaCoplus=BetaManipulator_ContributionsFromFile("cobetap",shift=0.0,factor=1/8.,rescaleXlambda=0)
cobetamedio=BetaManipulator_SumOfContributions(betaCominus,0.5,betaCoplus,0.5)
symbol_tmp0=BetaManipulator_BetaJoin(cobetamedio,material=Co_ind_one,trim_left=0,trim_right=0)
CoAve=KK(filename_or_betaObject=symbol_tmp0,E1=400,E2=1300,N=1000,e1=700,e2=900,Fact=1.0,Dx=0.0,maglia=betaCominus,Nmaglia=3,material=Co_ind_one)
symbol_tmp1=IndexFromTable(tf0, tf12,"Si",2.3)
symbol_tmp2=PPM_SimpleLayer(roughness=0.0,thickness=0.0,material=symbol_tmp1)
LSi0_roughness=Variable(0.1,0.0,30.0)
LSi0_thickness=Variable(28.82136,20.0,40.0)
symbol_tmp3=IndexFromTable(tf0, tf12,"Si",2.3)
symbol_tmp4=PPM_SimpleLayer(roughness=LSi0_roughness,thickness=LSi0_thickness,material=symbol_tmp3)
stacks[0]=SumThings(stacks[0], symbol_tmp2,symbol_tmp4)
RCO_0=Variable(0.1,0.0,20.0)
RCO_1=Variable(0.1,-10.0,10.0)
RSI_0=Variable(0.1,0.0,20.0)
RSI_1=Variable(0.1,-10.0,10.0)
RCO_X=DependentVariable("par(RCO_0)+self.VarCounter()*par(RCO_1)",dictio=locals(),)
RSI_X=DependentVariable("par(RSI_0)+self.VarCounter()*par(RSI_1)",dictio=locals(),)
CoSicomp=Variable(0.73,0.5,1.0)
Co_eqpart_dens=DependentVariable("par(CoSicomp)*8.71",dictio=locals(),)
Si_eqpart_dens=DependentVariable("2.3-2.3*par(CoSicomp)",dictio=locals(),)
CoSionSicompInterf=Variable(0.73,0.0,1.0)
Co_CoSionSi_interf_dens=DependentVariable("par(CoSionSicompInterf)*8.71",dictio=locals(),)
Si_CoSionSi_interf_dens=DependentVariable("2.3-2.3*par(CoSionSicompInterf)",dictio=locals(),)
SionCoSicompInterf=Variable(0.73,0.0,1.0)
Co_SionCoSi_interf_dens=DependentVariable("par(SionCoSicompInterf)*8.71",dictio=locals(),)
Si_SionCoSi_interf_dens=DependentVariable("2.3-2.3*par(SionCoSicompInterf)",dictio=locals(),)
Rinterf_0=Variable(0.1,0.0,20.0)
Rinterf_1=Variable(0.1,-10.0,10.0)
Rinterf_X=DependentVariable("par(Rinterf_0)+self.VarCounter()*par(Rinterf_1)",dictio=locals(),)
Int_CoSI_on_SI_thick=Variable(6,0.0,15.0)
symbol_tmp5=IndexFromObjects(CoAve,Co_CoSionSi_interf_dens,Si_ind_one,Si_CoSionSi_interf_dens)
symbol_tmp6=PPM_SimpleLayer(roughness=Rinterf_X,thickness=Int_CoSI_on_SI_thick,material=symbol_tmp5)
LCoSI_thickness=Variable(45,30.0,60.0)
symbol_tmp7=IndexFromObjects(CoAve,Co_eqpart_dens,Si_ind_one,Si_eqpart_dens)
symbol_tmp8=PPM_SimpleLayer(roughness=RCO_X,thickness=LCoSI_thickness,material=symbol_tmp7)
Int_Si_on_CoSI_thick=Variable(6,0.0,15.0)
symbol_tmp9=IndexFromObjects(CoAve,Co_SionCoSi_interf_dens,Si_ind_one,Si_SionCoSi_interf_dens)
symbol_tmp10=PPM_SimpleLayer(roughness=Rinterf_X,thickness=Int_Si_on_CoSI_thick,material=symbol_tmp9)
LSi_thickness=Variable(33.67569,20.0,40.0)
symbol_tmp11=IndexFromTable(tf0, tf12,"Si",2.33)
symbol_tmp12=PPM_SimpleLayer(roughness=RSI_X,thickness=LSi_thickness,material=symbol_tmp11)
stacks[0]=SumThings(stacks[0], MultiplyAThing(10,SumThings(symbol_tmp6,symbol_tmp8,symbol_tmp10,symbol_tmp12)))
Polarisation=([(1,0,(1.0/math.sqrt(2.0),1.0j/math.sqrt(2.0)))])
scan=ScanReader(wavelenghts_col=12398.52/776.2,angles_col=[0.01,20.0,0.01],angle_factor=1.0*arccos(-1)/180.0,Polarisation=Polarisation)
Polarisation=([(1,0,(1.0/math.sqrt(2.0),1.0j/math.sqrt(2.0))),(1,0,(1.0/math.sqrt(2.0),1.0j/math.sqrt(2.0)))])
scan2=ScanReader(wavelenghts_col=12398.52/776.2,angles_col=[0.01,20.0,0.01],angle_factor=1.0*arccos(-1)/180.0,Polarisation=Polarisation)
scanlist.extend([scan,scan2])
scannoises_list.extend([0.0,0.0,])
scannorms_list.extend([1.0,1.0,])
cutoffs_list.extend([1.0e-12,1.0e-12,])
scan2stack[len(scanlist)-2]=0
scan2stack[len(scanlist)-1]=0

symbol_tmp13=KK_write(CoAve,500,1200,700,"Coave2.dat")
symbol_tmp14=Beta_write(betaCominus,600,1000,400,"beta_write.dat")
variables_list=[LSi0_roughness,LSi0_thickness,RCO_0,RCO_1,RSI_0,RSI_1,CoSicomp,CoSionSicompInterf,SionCoSicompInterf,Rinterf_0,Rinterf_1,Int_CoSI_on_SI_thick,LCoSI_thickness,Int_Si_on_CoSI_thick,LSi_thickness,]

variables_names=["LSi0_roughness","LSi0_thickness","RCO_0","RCO_1","RSI_0","RSI_1","CoSicomp","CoSionSicompInterf","SionCoSicompInterf","Rinterf_0","Rinterf_1","Int_CoSI_on_SI_thick","LCoSI_thickness","Int_Si_on_CoSI_thick","LSi_thickness",]

fit2=PPM_ComparisonTheoryExperiment(stacks,scan2stack, scanlist,[1]*len(scanlist), normlist=scannorms_list, noise=scannoises_list,printpartial=[variables_list, variables_names],CutOffRatio=cutoffs_list,width=0)
symbol_tmp15=writeFit2File(fit2,"res")
variables_list=[LSi0_roughness,LSi0_thickness,RCO_0,RCO_1,RSI_0,RSI_1,CoSicomp,CoSionSicompInterf,SionCoSicompInterf,Rinterf_0,Rinterf_1,Int_CoSI_on_SI_thick,LCoSI_thickness,Int_Si_on_CoSI_thick,LSi_thickness,]
