from pymol.cgo import *
from pymol import cmd
import math
import whrandom
from pymol.opengl.gl import *

import Numeric
print sys.argv
if(len(sys.argv)!=5):
     # print help
     raise " PROGRAM STOPPED"
file=open(sys.argv[2],"r")
sforexec=file.read()
exec(sforexec)
file.close()
file=open(sys.argv[3],"r")
sforexec=file.read()
exec(sforexec)
file.close()



import pickle
import Numeric


fd=open(sys.argv[4],"r")
cella=pickle.load(fd)
M=pickle.load(fd)
Q=pickle.load(fd)


positions=[]
for tok in cella.PositionsList:
   for t in tok:
     positions.append(t)

positions=Numeric.array(positions)




# NPscan=24
# NPvector=41
# fampli= 2.0

q=Q[NPscan]


evalsL=[]
evectL=[]
###############################################################3333
# 

for i in range(len(Q)):
   print i
   evalsL.append(pickle.load(fd))
   evectL.append(pickle.load(fd))



def retrieve(ns,nv):
    e=evectL[ns][nv] * M* math.sqrt( 1.0 / 6.0221367e23 )

    e3=Numeric.reshape(e,[len(e)/3,3])
    q=Q[ns]

    factors=Numeric.exp(complex(0.0,1.0)*   Numeric.sum ( Numeric.transpose(q*positions)) )
    e3=Numeric.transpose( factors*Numeric.transpose( e3 )  )

    return e3






shift_cell = []

e3=retrieve(NPscan, NPvector)

for i in range(-nneig[0], nneig[0]+1):
   for j in range(-nneig[1], nneig[1]+1):
        for k in range(-nneig[2], nneig[2]+1):
		shift_cell.append(Numeric.array([i,j,k]) )


for i in range(len(cella.atomlist)):
 print " per l atomo ",   cella.atomlist[i][0]
 print " nella posizione ", positions[i]
 print " displacement = ", e3[i]



for iph in range (10):
 obj = []
 theta=math.pi*2.0*iph/10.0
 for shift in shift_cell:
  for i in range(len(cella.atomlist)):
   # print " ############################################################################ "
   atomname=cella.atomlist[i][0]
   ja=cella.AtomNames.index(atomname)
   radius = Rendering_Radii[ja]
   color=colors[ja]

   displacement = e3[i]

   pos=positions[i]

   obj.extend( [ COLOR ]+color )

   Rshift=Numeric.dot( -0.5+shift, cellvectors  ) 
   factor = Numeric.exp(complex(0.0,1.0)*   Numeric.sum ( (q*Rshift)) )

   pos = pos + Rshift +(factor*displacement*Numeric.exp( complex(0.0,1.0)*theta  )).real
   obj.extend( [ SPHERE ]+pos.tolist() +[radius] )
 cmd.load_cgo(obj,'cgo03',iph+1)



cmd.reset()
cmd.zoom('cgo03',3.0)

cmd.clip('far',-12.0)


cmd.turn('z',30)
cmd.turn('x',-60)

cmd.mplay()
   
        





