/*
 * Alessandro MIRONE
 * June the 7th 2001, 
 * ESRF
 */

#include"Python.h"
#include "structmember.h"
#include<stdio.h>
#include<iostream.h>
#include<string.h>

#include "Numeric/arrayobject.h"
#include <math.h>
#include<complex.h>

#define DEBUG(a) printf(a); printf("\n");

/*
 * The error object to expose 
 */

static PyObject *ErrorObject;
#define onError(message)\
  { PyErr_SetString(ErrorObject, message); return NULL;}



static char OP_fastRsum_doc[] = "\n"
"/*  11  arguments are taken by the function :\n"
" * KcrX , PyInteger. Scan for the x-coordinate of the cell-loop will go from -KcrX to + KcrX\n"
" * KcrY , idem for Y\n"
" * KcrZ , idem for Z\n"
" * \n"
" * CellX Array3: cell vectors\n"
" * CellY\n"
" * CellZ\n"
" * Q      Array NX3, the wavenumbers of the scan  \n"
" * DR     Array3. the distance from the fixed atom to the looping one\n"
" *\n"
" * sigma           float, sigma charge\n"
" *\n"
" * TermtoaddtoInsect    has to be dimensioned to Complex64 len(Q)X3X3\n"
" * Cself                has to be dimensioned to Complex64 3X3\n"
" *\n"
" * RETURN VALUE\n"
" *    None\n"
" *    Result are in  TermtoaddtoInsect and Cself\n"
" *    Cself has to be dimensioned to Complex64 3X3\n"
" *    TermtoaddtoInsect  has to be dimensioned to Complex64 len(Q)X3X3\n"
" */\n"
;



static PyObject *
OP_fastRsum(PyObject *self, PyObject *args)
{
  PyArrayObject *CellX,*CellY,*CellZ,*Q,*DR,*TermtoaddtoInsect,*Cself;
  double  sigma;
  int KcrX,KcrY,KcrZ;



  if(!PyArg_ParseTuple(args,"iiiOOOOOdOO:OP_fastRsum",  &KcrX, &KcrY, &KcrZ,
                        &CellX, &CellY, &CellZ,
                         &Q, &DR,
                         &sigma,  &TermtoaddtoInsect, &Cself)
     )
    return NULL;

  /* check the Objects */
  if(!PyArray_Check((PyObject *)CellX ))    onError("not a PyArray, argument 4");
  if(!PyArray_Check((PyObject *)CellY))     onError("not a PyArray, argument 5");
  if(!PyArray_Check((PyObject *)CellZ))     onError("not a PyArray, argument 6");
  if(!PyArray_Check((PyObject *)Q))          onError("not a PyArray, argument 7");
  if(!PyArray_Check((PyObject *)DR))         onError("not a PyArray, argument 8");
  if(!PyArray_Check((PyObject *)TermtoaddtoInsect))        onError("not a PyArray, argument 10");
  if(!PyArray_Check((PyObject *)Cself))        onError("not a PyArray, argument 11");

  /* check the types */
  if( CellX->descr->type_num != PyArray_DOUBLE ) onError(" arg 4 is not double " ) ;
  if( CellY->descr->type_num != PyArray_DOUBLE ) onError(" arg 5  is not double " ) ;
  if( CellZ->descr->type_num != PyArray_DOUBLE ) onError(" arg 6 is not double " ) ;

  if( Q->descr->type_num != PyArray_DOUBLE ) onError(" arg 7 is not double " ) ;
  if( DR->descr->type_num != PyArray_DOUBLE ) onError("  arg 9  is not double " ) ;
  if( TermtoaddtoInsect->descr->type_num != PyArray_CDOUBLE ) onError("  arg 10  is not cdouble " ) ;
  if( Cself->descr->type_num != PyArray_CDOUBLE ) onError("  arg 11  is not cdouble " ) ;



  /* check the dimensions */
  if( CellX->nd != 1 )
    onError("The CellX (arg. 4) has not the right number of dimensions");
  if( CellY->nd != 1 )
    onError("The CellY (arg. 5) has not the right number of dimensions");
  if( CellZ->nd != 1 )
    onError("The CellZ (arg. 6) has not the right number of dimensions");

  if( Q->nd != 2 )
    onError("The Q (arg. 7) has not the right number of dimensions");
  if( DR->nd != 1 )
    onError("The DR (arg. 8) has not the right number of dimensions");

  if(TermtoaddtoInsect ->nd != 3 )
    onError("The TermtoaddtoInsect (arg. 10) has not the right number of dimensions");

  if( Cself->nd != 2 )
    onError("The Cself (arg. 11) has not the right number of dimensions");



  
  int numQ;
  numQ=Q->dimensions[0];

  if(TermtoaddtoInsect->dimensions[0] != numQ )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");
  if(TermtoaddtoInsect->dimensions[1] != 3 )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");
  if(TermtoaddtoInsect->dimensions[2] != 3 )
    onError("The TermtoaddtoInsect  array (arg. 10  has not the right  dimension");

  if(Cself->dimensions[0] != 3 )
    onError("The Cself  array (arg. 11  has not the right  dimension");
  if(Cself->dimensions[1] != 3 )
    onError("The Cself  array (arg. 11  has not the right  dimension");


  if(CellX->dimensions[0] != 3 )
    onError("The  CellX array (arg. 4  has not the right  dimension");
  if(CellY->dimensions[0] != 3 )
    onError("The CellY  array (arg. 5  has not the right  dimension");
  if(CellZ->dimensions[0] != 3 )
    onError("The CellZ  array (arg. 6  has not the right  dimension");
  if(Q->dimensions[1] != 3 )
    onError("The Q  array (arg.  7  has not the right  dimension");
  if(DR->dimensions[0] != 3 )
    onError("The DR  array (arg.  8  has not the right  dimension");


  /* check for contiguity */

  PyArrayObject *toverify[]={CellX,CellY,CellZ,DR,TermtoaddtoInsect,Cself,NULL};
  PyArrayObject **ptr;
  ptr=toverify;
  while(*ptr) {
    if((*ptr)->flags %2 == 0) onError(" All arrays have to be contiguous");
    ptr++;
  }


  /* After having verified everything we can finally do fast calculations */


  double *q =   (double*) Q->data;  
  double *cellX =   (double*) CellX->data;  
  double *cellY =   (double*) CellY->data;  
  double *cellZ =   (double*) CellZ->data;  
  double *dr =   (double*) DR->data;  

  complex<double> *toadd =   (complex<double>*) TermtoaddtoInsect->data;  
  complex<double> *cself =   (complex<double>*) Cself->data;  
  
  
  double   r0,r1,r2,  espo,esp, integral, R2,R;
  double p;
  double fatt_1,  fatt_2, Der1, Der2, L, T, qdr,r0r0,r0r1,r0r2,r1r1,r1r2,r2r2;


  p=1.0/(2.0*sigma*sigma);  
  fatt_1=sqrt(M_PI/4.0/p);
  fatt_2=2*sqrt(p/M_PI);
  
  for(int ix=-KcrX; ix<=KcrX; ix++) 
    for(int iy=-KcrY; iy<=KcrY; iy++) 
      for(int iz=-KcrZ; iz<=KcrZ; iz++) {
	  
	  r0=dr[0]+ix*cellX[0]+iy*cellY[0]+iz*cellZ[0];
	  r1=dr[1]+ix*cellX[1]+iy*cellY[1]+iz*cellZ[1];
	  r2=dr[2]+ix*cellX[2]+iy*cellY[2]+iz*cellZ[2];
	  
          R2 = r0*r0+r1*r1+r2*r2;
          if(R2==0.0) continue;
          R = sqrt(R2);
 
	  
          espo = p*R*R;
          if(espo>80) espo=80;
	  
	  esp = exp(-p*R*R);
	  
	  integral = fatt_1  * (1-erf(sqrt(p) * R )) ;
	  
          Der1=-1.0/R*(integral/R + esp  );
	  Der2= 2*( 1.0/R/R*(integral/R + esp ) + p*esp);
	  
	  L= fatt_2* Der2;
	  T= fatt_2* Der1/R;

          r0r0= r0*r0 /R2  ;
          r0r1= r0*r1 /R2  ;
          r0r2= r0*r2 /R2  ;
          r1r1= r1*r1 /R2  ;
          r1r2= r1*r2 /R2  ;
          r2r2= r2*r2 /R2  ;

	  q =   (double*) Q->data;  
	  toadd =   (complex<double>*) TermtoaddtoInsect->data;  

	  for( int nscan=0; nscan<numQ; nscan++) {    
	    qdr=  q[0]*r0 +  q[1]*r1+  q[2]*r2  ; 
	    toadd[ 0* 3 + 0 ] += -((L-T)*r0r0+T) *exp( complex<double>(0.0, qdr)   )     ;
	    toadd[ 0* 3 + 1 ] += -((L-T)*r0r1) *exp( complex<double>(0.0, qdr)   )      ;
	    toadd[ 0* 3 + 2 ] += -((L-T)*r0r2) *exp( complex<double>(0.0, qdr)   )      ;
	    toadd[ 1* 3 + 1 ] += -((L-T)*r1r1  +T) *exp( complex<double>(0.0, qdr)   )    ;
	    toadd[ 1* 3 + 2 ] += -((L-T)*r1r2) *exp( complex<double>(0.0, qdr)   )      ;
	    toadd[ 2* 3 + 2 ] += -((L-T)*r2r2  +T) *exp( complex<double>(0.0, qdr)   )    ;
            toadd+=9;
            q+=3;
          }
	  cself[ 0* 3 + 0 ] += -((L-T)*r0r0   +T)    ;
	  cself[ 0* 3 + 1 ] += -((L-T)*r0r1     )    ;
	  cself[ 0* 3 + 2 ] += -((L-T)*r0r2     )    ;
	  cself[ 1* 3 + 1 ] += -((L-T)*r1r1   +T)    ;
	  cself[ 1* 3 + 2 ] += -((L-T)*r1r2     )    ;
	  cself[ 2* 3 + 2 ] += -((L-T)*r2r2   +T)    ;
	  
      }

  cself[ 1* 3 + 0 ] =cself[ 0* 3 + 1 ];
  cself[ 2* 3 + 0 ] =cself[ 0* 3 + 2 ];
  cself[ 2* 3 + 1 ] =cself[ 1* 3 + 2 ];


  
  toadd =   (complex<double>*) TermtoaddtoInsect->data;  
  for( int nscan=0; nscan<numQ; nscan++) {    



    toadd[ 1* 3 + 0 ] = toadd[ 0* 3 + 1 ]     ;
    toadd[ 2* 3 + 0 ] = toadd[ 0* 3 + 2 ]      ;
    toadd[ 2* 3 + 1 ] = toadd[ 1* 3 + 2 ]      ;
    toadd+=9; 
  }
  
  
  
  Py_INCREF(Py_None);
  return Py_None;
}





static PyMethodDef OP_fastRsum_functions[] = {
  {"OP_fastRsum", OP_fastRsum, METH_VARARGS ,OP_fastRsum_doc },
  { NULL, NULL}
};


extern "C" {
void 
initOP_fastRsum();
}

void 
initOP_fastRsum()
{
  PyObject *m, *d;
  m = Py_InitModule("OP_fastRsum", OP_fastRsum_functions);
  d = PyModule_GetDict(m);
  ErrorObject = Py_BuildValue("s","OP_fastRsum.error");
  PyDict_SetItemString(d,"error", ErrorObject);
  if(PyErr_Occurred())
    Py_FatalError("can't initialize module OP_fastRsum ");

#ifdef import_array
  import_array();
#endif
}

































