#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.



## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt


import  Numeric 
import  LinearAlgebra
import arrayfns
import  sys
import  math
import  cPickle
import  MLab
import string
from Dabax import * 
from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions

TR=Numeric.transpose

help= " execute this program with two arguments: The name of the storeall file, the Number of histograms\n"

if(len(sys.argv)!=3):
  print help
  raise "PROGRAM STOPS"

#################################################################
# opens the file where cella, M, Q, evals+evects are stored
#

storeall=open(sys.argv[1],"r")
cella=cPickle.load(storeall)
ussqM=cPickle.load(storeall)  #1/sqrt(Mass)
Q=cPickle.load(storeall)

print " LENGHT Q=", len(Q)
Sum=0
Nsampling=cPickle.load(storeall)


#######################################
# Reads the definition of Q2I_Foo
#

Q2I_String=cPickle.load(storeall)
print " FUNCTION ", Q2I_String
exec(Q2I_String)  

transformations=cPickle.load(storeall)




##########################################################
# build a matrix by which the q's can be decomposed  on
# the Brillouin vectors basis. 
# Useful to display result in units which are integer on
#  the reciprocal lattice sites, or even more useful
# when we want reduce a big vector in the 000 cell
#

brill=cella.Brillvectors
brilldecomposition=LinearAlgebra.inverse(TR(brill))

Eval_L =[]
Evec_L =[]

for iq in range(0,len(Q)):
  print iq
  Eval_L.append(  cPickle.load(storeall) )
  # print Eval_L[-1]
  Evec_L.append(  cPickle.load(storeall) )

Eval_L=Numeric.array(Eval_L)

# we donot need to rescale evect because they are normalised to 1

Evec_L=Numeric.array(Evec_L)



######################################################
# Histogram_s initialisation
#
Nhisto=string.atoi(sys.argv[2])
Histograms={}
for group in cella.grouplist:
  Histograms[group]=Numeric.zeros(Nhisto,'d')

################################################################
# maximum frequency. 
Eval_L_1d=Numeric.reshape( Eval_L ,[  Numeric.multiply.reduce( Numeric.shape(Eval_L) ) ]   )
MaxW =math.sqrt(max(Eval_L_1d))
Whisto=MaxW





####################################################
# Now loop on all q of the first zone
#
for iFz in range(0, len(Q)):
   q1=Q[iFz]
   
   ###########################################################
   # Find the weigth and check the Q2I_Foo at the same time
   #
   # print " q1 = ", q1

   q1_onBrill    = Numeric.dot  (  brilldecomposition,  q1  )

   # print " q1_onBrill = ", q1_onBrill
   (iFz_supposed ,weightFz) = Q2I_Foo(q1_onBrill,Nsampling)
   if(iFz_supposed != iFz):
      s=(" iFz_supposed != iFz  %d %d" %(iFz_supposed , iFz))
      print s
      raise s
   
   fA    = Numeric.sqrt(Eval_L [iFz])
   vects = Evec_L [iFz]
   vects = (vects*Numeric.conjugate(vects)).real
   shpv  = Numeric.shape(vects)
   Wvects = TR( Numeric.sum( TR(Numeric.reshape(vects,shpv[:-1] +(shpv[-1]/3,3))) )       )
   ###########################################################################
   #  add contributions to the histogram

   for atom in cella.atomlist:
      group=cella.DGroups[atom]
      position=cella.atomlist.index(atom)
      hix = Numeric.floor( (( fA* (Nhisto-1))/MaxW)+0.5 ).astype('l')
      # print  Wvects[:,position] 
      addendum = arrayfns.histogram(hix, Wvects[:,position]   )
      
      Numeric.add(Histograms[group][0:len(addendum)]  , addendum*weightFz ,Histograms[group][0:len(addendum)]  )
 

for group in cella.grouplist:
  fd=open("DOS_%s"%group,"w")
  for i in range(0,len(Histograms[group])):
    fd.write("%e %e\n" %(i*Whisto/Nhisto  ,Histograms[group][i]) )

 
print " Sum ", Sum










