#########################3
##Disclaimer
##==========
##
## This  software is provided without warranty of any kind.
## No liability is taken for any loss or damages, direct or
## indirect, that may result through the use of it. No warranty
## is made with respect to this documantation, or the programs
## and functions therein.
## There are no warranties that the programs or their documentation
## are free of error, or that it is consistent with any standard,
## or that it will meet the requirement for a particular application.

 
  
   
## Copyright
## =========
##
## We have adopted the GNU LIBRARY GENERAL PUBLIC LICENSE to apply to
## the this software.
## For more information on the license terms, see
## http://www.gnu.org/copyleft/lgpl.txt
    
import  Numeric 
import  LinearAlgebra
import  sys
import  math
import  pickle
import  MLab
from Dabax import * 
from    OP_simmetrie import OP_cella, OP_ComparisonCellRotatedCell, OP_isDifferent, OP_FindSymmetries, OP_TellAbout
import copy
from contributions import contributions

TR=Numeric.transpose

help="To be called with two arguments, the name of the storeall file and the name of a file like this:\n"
help_file=("BrillShift_List=[(6,0,0)]\n"
"scatt_dictio_f0={ 'Cu_G0':'Cu1+', 'O_G0':'O','O_G1':'0','Nd_G0':'Nd','Nd_G1':'Nd'   }\n"
"scatt_dictio_f12={ 'Cu_G0':'Cu', 'O_G0':'O','O_G1':'0','Nd_G0':'Nd','Nd_G1':'Nd'   }\n"
"Lambda=0.783867\n"\
"Temp = 15.0\n"
)

if(len(sys.argv)!=3):
   print help
   print " "
   print help_file
   raise "STOPPING THE PROGRAM "

#################################################################
# opens the file where cella, M, Q, evals+evects are stored
#
storeall=open(sys.argv[1],"r")
cella=pickle.load(storeall)
ussqM=pickle.load(storeall)

storeLDA=open("storeLDA","r")

Q=pickle.load(storeLDA)



####################################################################
s=open(sys.argv[2],"r").read()
exec(s)


#######################################################################33
# specify here the scatterers
#

###################################################33
# here the objects that you associate to a given entry
# can be whatever object, given that it has a method
# F_Lambda(self,  Lambda, theta=None )
# with lambda in Angstroems and theta in radians
# Theta is the "bragg angle" i.e. : q= 2*sin(theta)*2*PI/lambda
#


Table_f0= Dabax_f0_Table("f0_WaasKirf.dat")
Table_f1f2=Dabax_f1f2_Table("f1f2_Windt.dat")

 
scatterer_for_type={}
for key in scatt_dictio_f0.keys():
  scatterer_for_type[key]=Dabax_Scatterer([ Table_f0.Element(scatt_dictio_f0[key])  ], [1.0],   [  Table_f1f2.Element(scatt_dictio_f12[key]) ]  ,  [1.0] )



###########################################################################
# input here your lambda in Angstroems 
#
# Lambda=0.783867
###########################################################################
# input here your Temperature in Kelvin of the SAMPLE
#
# Temp = 15.0

##################################
# Planck's constant over two pi in erg*sec
#
hbar=1.054571596e-27

##################################
# Boltzmann constant in erg/Kelvin
Kb=1.38e-16

###########################################################33
# the classical radius of the electron (e*e/m/c/c)
# re= 2.817940285(31)X10-15 m 

er0=2.817940285e-13
                                         


####################################################
# The Q given in dispersion is in Angstroems-1
# We put it in cm-1
#
Q=Q*1.0e8

####################################################
# the list of 3D positions in Angstroems in cm
#
Positions= Numeric.array(map(cella.FindPosition,cella.atomlist ))*1.0e-8

if (USE_SUPERCELL ==1):
  cella.atomlist=cella.atomlist*SUPERCELL_MULT
  R_displacement =  Numeric.dot(TR(cella.cellvectors)  , SUPER_DIR )    *1.0e-8
  toconcatenate = [  Positions + sprcl * R_displacement    for sprcl in range(SUPERCELL_MULT)             ]
  Positions = Numeric.concatenate( toconcatenate )
  ussqM   =  Numeric.concatenate( [ussqM]*SUPERCELL_MULT)


  Q=Q[:len(Q)/SUPERCELL_MULT]

#####################################################################################3
# build up a list whose ith element is the scattering function for the type ( like Nd_G0)
# corresponding to the ith site ( coordinate from 3*i to 3*i+2 in the vectors)
# This list will be used to estabilish the array of scattering factor using dabax
# It is just a commodity list to be used when lloping on the contributions
scatterers=[]
for A in cella.atomlist:
   print cella.DGroups[A]
   scatterers.append(scatterer_for_type[cella.DGroups[A]] )




########################################################
# the list giving the theta
# Q=2*sin(theta)*2*Pi/lambda

thetalist = Numeric.arcsin(Numeric.sqrt(Numeric.sum(TR(Q*Q)))*Lambda*1.0e-8/2.0/math.pi/2.0)


##########################################################
# build a matrix by which the q can be decompose on
# the Brillouin vectors basis. 
# Useful to display result in units which are integer on
# for the reciprocal lattice sites
#
brill=cella.Brillvectors
brill=brill*1.0e8   # it was A-1
brilldecomposition=LinearAlgebra.inverse(TR(brill))



######################################################
# now we loop for every shift that you specify here
#
countbrillshift=0
res_file=open("scatt_results","w")

for BrillShift in BrillShift_List:
  print "Q=",Q
  print "countbrillshift", countbrillshift
  if(countbrillshift!=0):
    storeall.close()
    storeLDA=open("storeLDA","r")

    pickle.load(storeLDA) # questo est per i Qs

  countbrillshift=countbrillshift+1
  ###########################################################3
  #
  # The results file
  #
  Qshift=Numeric.dot(BrillShift, brill)

  thetalist = Numeric.arcsin(Numeric.sqrt(Numeric.sum(TR((Q+Qshift)*(Q+Qshift))))*Lambda*1.0e-8/2.0/math.pi/2.0)


  #######################################
  # now we loop for every q in Q
  #
  for iq in range(0,len(Q)):

    exch_q=Q[iq]+Qshift
    print " ############################# ", exch_q

    evals =pickle.load(storeLDA)
    evects=pickle.load(storeLDA)
  


    evects=evects*Numeric.reshape(
                                  Numeric.reshape(
                                            Numeric.exp(Numeric.sum(TR(complex(0.0,-1.0)*Qshift*Positions)) )
                                        ,[len(Positions),1]
                                  )* Numeric.array( [1,1,1] )
                     , [3*len(Positions)]
                  )





    theta=thetalist[iq]
    scattering_powers=Numeric.array(map( lambda x, Lambda=Lambda, theta=theta: x.F_Lambda(Lambda,theta),  scatterers))
    ##########################################################
    # now are looping  over all the dispersion branches
    #
    w=Numeric.sqrt(evals)  # this actually is a vector
    print w
    #################################################
    # occupation numbers
    #
    espo= Numeric.minimum(  hbar/(Kb*Temp)* w , 80)
    print espo
    expmhw_kt = Numeric.exp(-espo) 
    nq=  expmhw_kt/(1-expmhw_kt)                   # this is a vector too
  
    print nq
    #######################*********************
    # ussqM is the vector containing 1/sqrt(Mk)
    evects=evects*ussqM  

    #############################################
    # get a matrix having on a given  each row 
    # the list of scalar product (q,Rk)
    #
    qe = Numeric.reshape(evects,[len( evects),len( evects)/3,3])*exch_q
    qe=TR(Numeric.sum(TR(qe)))
    ###########################################################################3
    #
    # The optical path factors for the different positions in the cell
    #
    path_facts=1
    #Numeric.exp( complex(0.0,-1.0)*Numeric.sum(TR( Positions*exch_q     ))     )
    #################################################################################
    # SUM to be squared (for every branch)
    #

    sumtobe2 = Numeric.sum(TR(   scattering_powers *     qe * path_facts      ))
    sum2ed   = (sumtobe2*Numeric.conjugate(sumtobe2)).real / w

    #######################################################################
    # result is the transition probability per unit cell of the sample
    # to be multiplied by the delta
  
    Ncells=1.0e22

    result= er0*er0*hbar*sum2ed*Ncells

    ##########################################################333
    # decompose the q vector on the Brillouin vectors basis
    #
    dec_q=Numeric.dot(  brilldecomposition, exch_q ) 

    res_file.write("%e %e %e "%(dec_q[0], dec_q[1], dec_q[2], ) )
    for iw in range(0,len(w)):
       res_file.write("  %e %e  %e"%(w[iw], result[iw]*(nq[iw]+1),result[iw]*(nq[iw])  ) )
    res_file.write("\n")

############################
res_file.close()












