from PyDisWindow import *
from PyDVT.View import View
from PyDVT.FitFilter import FitFilter
from PyDVT.Binding import FitParametersDialog,GraphStyleDialog
from EventHandler import EventHandler
import PyDVT

__version__=  '1.0.2'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


class PyDisFit1D(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnFinishInit (self,app_window):
        self.app_window=app_window
        self.FitPen=Pen((255,0,0),0,"solid")
        self.eh=EventHandler()
        self.eh.register("graphElementStyleChangedEvent",self._ChangePen)
        self.PenDlg=None
            

    def OnInitWindowPopupMenu (self,window):
        if isinstance(window.View,PyDVT.GraphView.GraphView):
            window.View.AddMenuSeparator()
            window.View.AddMenuPopupItem("Add Fit",Command.Command(self.AddFit,window))
            window.View.AddMenuPopupItem("Set Fit Pen",Command.Command(self.SetFitPen,window))
        
    def GetInfoString(self):
        return "v. "+__version__

    ########################################################
    ### Private methods
    ########################################################
    def AddFit(self,window):
        if hasattr(window,"ParDlg")==0 or window.ParDlg.View is None:
            fit_filter=FitFilter(window.Filter)
            window.ParDlg=FitParsWindow (self.app_window.mdi,FitParsView,'Fit Parameters - '+ str(window.caption()),{},master_window=window)
            fit_filter.ConnectParameterEditor(window.ParDlg.View.Drawable)
            window.View.SetSource((window.Filter,GraphView.GraphFilter("G2",fit_filter,pen=self.FitPen)))
            
    def SetFitPen(self,window):
        if self.PenDlg==None or self.PenDlg.IsDestroyed():
            cnf={'style':self.FitPen.style,'width':self.FitPen.width,'color':self.FitPen.color}            
            self.PenDlg=GraphStyleDialog(window,self.eh,"Fit Pen",cnf)
        self.PenDlg.Show()
        self.PenActiveWindow=window

        
    def _ChangePen(self,graphName,graphCnf):
        self.FitPen=Pen(graphCnf['color'],int(str(graphCnf['width'])),str(graphCnf['style']))
        try: self.PenActiveWindow.View.SetPen("G2",self.FitPen)
        except: pass
    	



class FitParsView(View):
    def CreateDrawable(self):
        self.Drawable=FitParametersDialog(self.parent,None)		
        self.Drawable.Show()

    def resizeEvent(self,e):
        self.Drawable.resize(self.width(),self.height())        

class FitParsWindow(ViewWindow):
    def closeEvent(self,ce):
        self.master_window.View.SetSource(self.master_window.Filter)
        ViewWindow.closeEvent(self,ce)


plugin=PyDisFit1D()
