/* spslut_py.c VERSION 4.0 */
/* $Revision: 1.7 $
 * $Log: spslut_py.c,v $
 * Revision 1.7  2005/02/10 23:37:48  sole
 * minor changes
 *
 * Revision 1.6  2005/02/10 17:44:58  sole
 * *** empty log message ***
 *
 * Revision 1.5  2005/02/10 16:17:15  sole
 * Removed some unused variables
 **/
/* CHANGES:

	[05-09-2002] A. Gobbo
	- Included min and max values to 8 bit colormaps 
  
	[11-03-2002] A. Gobbo
	- Included modes BGR and BGRX 

	[12-12-2001] A. Gobbo
	- Dimentions inverted in the returned array
	- Corrected memory leak bug     
*/
#include <stdio.h>      
#include <stdio.h>
/* AS + AM */
#ifdef __linux__
	#warning "Assuming LINUX and using the functions lrint() and lrintf ()."
	#define	_ISOC9X_SOURCE	1
	#define _ISOC99_SOURCE	1

	#define	__USE_ISOC9X	1
	#define	__USE_ISOC99	1

	#include	<math.h>
    #define FLOAT_TO_INT(in,out) \
        __asm__ __volatile__("fistpl %0" : "=m" (out) : "t" (in) : "st") ;
	
#elif (defined (WIN32) || defined (_WIN32))
	#include	<math.h>

	/*	Win32 doesn't seem to have these functions. 
	**	Therefore implement inline versions of these functions here.
	*/
	
	__inline long int 
	lrint (double flt) ;
	{	int intgr;

		_asm
		{	fld flt
			fistp intgr
			} ;
			
		return intgr ;
	} 
	
	__inline long int 
	lrintf (float flt)
	{	int intgr;

		_asm
		{	fld flt
			fistp intgr
			} ;
			
		return intgr ;
	}

#else
	#warning "Don't have the functions lrint() and lrintf ()."
	#warning "Replacing these functions with a standard C cast."

	#include	<math.h>

	#define	lrint(dbl)		((int)(dbl))
	#define	lrintf(flt)		((int)(flt))

#endif

#include <Python.h>         
#include <Numeric/arrayobject.h>
#include <sps_lut.h>

static PyObject *SPSLUTError;

PyObject *new_pyimage(const char *mode, unsigned xsize, unsigned ysize, 
		      void *data)
{
  return PyString_FromStringAndSize ((const char *)data, 
				     strlen(mode) * xsize * ysize);
}
   
static int natbyteorder()
{
  union {
    struct {
      unsigned char b1;
      unsigned char b2;
      unsigned char b3;
      unsigned char b4;
    } c;
    unsigned long p;
  } val;

  val.p = 1;
  if (val.c.b4 == 1) {
    return SPS_MSB;
  } else {
    return SPS_LSB;
  }
}

static PyObject *spslut_transform(self, args)
     PyObject *self, *args;
     
{
  char *key, *value;
  void *data;
  int type, cols, rows, reduc, fastreduc, meth, autoscale, mapmin=0, mapmax=255;
  int palette_code;
  double gamma, min, max;
  XServer_Info Xservinfo;
  void *palette;
  int prows, pcols, pal_entries;
  int byteorder, pixelsize;
  unsigned long redmask, greenmask, bluemask;
  void *r/*, *res*/;
  char *mode;
  PyArrayObject *src;
  PyObject *in_src;
  PyObject *res,*aux;

  if (!PyArg_ParseTuple(args, "O(ii)(id)sii(dd)|(ii)", &in_src, &reduc, 
			&fastreduc, &meth, &gamma, &mode, &palette_code,
			&autoscale, &min, &max,&mapmin, &mapmax)) 
		return NULL;
  
  if (strcmp(mode, "RGB") == 0) {
    Xservinfo.red_mask = 0x0000ff;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0xff0000;
    Xservinfo.pixel_size = 3;
    Xservinfo.byte_order = natbyteorder();
  } else if (strcmp(mode, "RGBX") == 0) {
    Xservinfo.red_mask = 0x0000ff;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0xff0000;
    Xservinfo.pixel_size = 4;
    Xservinfo.byte_order = natbyteorder();
  } 
  
  //###CHANGED - ALEXANDRE 11/03/2002 - Qt uses different order than Tkinter
  else if (strcmp(mode, "BGR") == 0) {
    Xservinfo.red_mask = 0xff0000;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0x0000ff;
    Xservinfo.pixel_size = 3;
    Xservinfo.byte_order = natbyteorder();
  } else if (strcmp(mode, "BGRX") == 0) {
    Xservinfo.red_mask = 0xff0000;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0x0000ff;
    Xservinfo.pixel_size = 4;
    Xservinfo.byte_order = natbyteorder();
  } 

    else if (strcmp(mode, "L") == 0 || strcmp(mode, "P") == 0  ) {
    Xservinfo.pixel_size = 1;
    Xservinfo.byte_order = natbyteorder();
    //mapmin = 0;
    //mapmax = 255;
  } else {
    PyErr_SetString(SPSLUTError, "Mode must be RGB, RGBX, BGR, BGRX, L or P");
    return NULL;
  }

  if (!(src = (PyArrayObject*) PyArray_ContiguousFromObject(in_src, 
   			    PyArray_NOTYPE, 2, 2))) {
    PyErr_SetString(SPSLUTError, "Input Array could is not a 2x2 array");
    return NULL;
  }

  switch (src->descr->type_num) {
  case PyArray_UINT:
    type = SPS_ULONG; break;
  case PyArray_USHORT:
    type = SPS_USHORT; break;
  case PyArray_LONG: 
  case PyArray_INT: 
    type = SPS_LONG; break;
  case PyArray_SHORT: 
    type = SPS_SHORT; break;
  case PyArray_UBYTE: 
    type = SPS_UCHAR; break;
  case PyArray_SBYTE: 
    type = SPS_CHAR; break;
  case PyArray_FLOAT: 
    type = SPS_FLOAT; break;
  case PyArray_DOUBLE: 
    type = SPS_DOUBLE; break;
  default:
    PyErr_SetString(SPSLUTError, "Input Array type not supported");
    return NULL;
  }
  
  data = src->data;
  cols = src->dimensions[1];  /*FIX THIS cols and rows are turned around */
  rows = src->dimensions[0];  /*###CHANGED - ALEXANDRE 24/07/2001*/


  
  r = SPS_PaletteArray (data, type, cols, rows, reduc, fastreduc, meth, gamma, 
			autoscale, mapmin, mapmax, Xservinfo, palette_code,
			&min, &max, &pcols, &prows, &palette, &pal_entries);
  if (r == 0) {
    PyErr_SetString(SPSLUTError, "Error while trying to calculate the image");
    return NULL;
  }
   /*###CHANGED - ALEXANDRE 24/07/2001*/
  aux=new_pyimage(mode, (unsigned) pcols, (unsigned) prows, r);
  res = Py_BuildValue("(O(i,i)(d,d))",aux,pcols, prows, min, max);
  free(r);
  Py_DECREF(aux);

  /*###CHANGED - ALEXANDRE 28/06/2002*/  
  Py_DECREF(src);


  return res;
 
  /*
  res = Py_BuildValue("(O(i,i)(d,d))",  new_pyimage(mode, (unsigned) pcols, 
		(unsigned) prows, r), pcols, prows, min, max);
		(unsigned) prows, r), pcols, prows, min, max);
  free(r);  
  return res;
  */
}


static PyObject *spslut_transformarray(self, args)
     PyObject *self, *args;
     
{
  void *data;
  int type, cols, rows, reduc, fastreduc, meth, autoscale, mapmin=0, mapmax=255;
  int palette_code;
  double gamma, min, max;
  XServer_Info Xservinfo;
  void *palette;
  int prows, pcols, pal_entries;
  void *r/*, *res*/;
  char *mode;
  unsigned char *as_pointer, *as_r;
  int as_dim[3];
  PyArrayObject *src;
  PyObject *in_src;
  PyArrayObject *aux;

  if (!PyArg_ParseTuple(args, "O(ii)(id)sii(dd)|(ii)", &in_src, &reduc, 
			&fastreduc, &meth, &gamma, &mode, &palette_code,
			&autoscale, &min, &max,&mapmin, &mapmax)) 
		return NULL;
  
  if (strcmp(mode, "RGB") == 0) {
    Xservinfo.red_mask = 0x0000ff;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0xff0000;
    Xservinfo.pixel_size = 3;
    Xservinfo.byte_order = natbyteorder();
  } else if (strcmp(mode, "RGBX") == 0) {
    Xservinfo.red_mask = 0x0000ff;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0xff0000;
    Xservinfo.pixel_size = 4;
    Xservinfo.byte_order = natbyteorder();
  } 
  
  //###CHANGED - ALEXANDRE 11/03/2002 - Qt uses different order than Tkinter
  else if (strcmp(mode, "BGR") == 0) {
    Xservinfo.red_mask = 0xff0000;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0x0000ff;
    Xservinfo.pixel_size = 3;
    Xservinfo.byte_order = natbyteorder();
  } else if (strcmp(mode, "BGRX") == 0) {
    Xservinfo.red_mask = 0xff0000;
    Xservinfo.green_mask = 0x00ff00;
    Xservinfo.blue_mask = 0x0000ff;
    Xservinfo.pixel_size = 4;
    Xservinfo.byte_order = natbyteorder();
  } 

    else if (strcmp(mode, "L") == 0 || strcmp(mode, "P") == 0  ) {
    Xservinfo.pixel_size = 1;
    Xservinfo.byte_order = natbyteorder();
    //mapmin = 0;
    //mapmax = 255;
  } else {
    PyErr_SetString(SPSLUTError, "Mode must be RGB, RGBX, BGR, BGRX, L or P");
    return NULL;
  }

  if (!(src = (PyArrayObject*) PyArray_ContiguousFromObject(in_src, 
   			    PyArray_NOTYPE, 2, 2))) {
    PyErr_SetString(SPSLUTError, "Input Array could is not a 2x2 array");
    return NULL;
  }

  switch (src->descr->type_num) {
  case PyArray_UINT:
    type = SPS_ULONG; break;
  case PyArray_USHORT:
    type = SPS_USHORT; break;
  case PyArray_LONG: 
  case PyArray_INT: 
    type = SPS_LONG; break;
  case PyArray_SHORT: 
    type = SPS_SHORT; break;
  case PyArray_UBYTE: 
    type = SPS_UCHAR; break;
  case PyArray_SBYTE: 
    type = SPS_CHAR; break;
  case PyArray_FLOAT: 
    type = SPS_FLOAT; break;
  case PyArray_DOUBLE: 
    type = SPS_DOUBLE; break;
  default:
    PyErr_SetString(SPSLUTError, "Input Array type not supported");
    return NULL;
  }
  
  data = src->data;
  cols = src->dimensions[1];  /*FIX THIS cols and rows are turned around */
  rows = src->dimensions[0];  /*###CHANGED - ALEXANDRE 24/07/2001*/


  
  r = SPS_PaletteArray (data, type, cols, rows, reduc, fastreduc, meth, gamma, 
			autoscale, mapmin, mapmax, Xservinfo, palette_code,
			&min, &max, &pcols, &prows, &palette, &pal_entries);
  if (r == 0) {
    PyErr_SetString(SPSLUTError, "Error while trying to calculate the image");
    return NULL;
  }
   /*###CHANGED - ALEXANDRE 24/07/2001*/
  as_dim[0] = strlen(mode);
  as_dim[1] = prows * pcols;
/*  printf("dim[0] = %d dim[1] = %d \"%s\" \n",as_dim[0],as_dim[1],mode); */
  aux = (PyArrayObject*) PyArray_FromDims(2,as_dim, PyArray_CHAR);
  if (aux == NULL){
      free(r);
      Py_DECREF(src);
      return NULL;  
  }
  as_pointer = (char *) aux -> data; 
  as_r = (char *) r;  
  memcpy(as_pointer, as_r, as_dim[0] * as_dim[1]);
  free(r);
  Py_DECREF(src);
  PyArray_Return(aux);
}

unsigned long RGB256[] = 
    {0x0000ff, 0x0004ff, 0x0008ff, 0x000cff, 0x0010ff, 0x0014ff, 0x0018ff, 0x001cff,
 0x0020ff, 0x0024ff, 0x0028ff, 0x002cff, 0x0030ff, 0x0034ff, 0x0038ff, 0x003cff,
 0x0040ff, 0x0044ff, 0x0048ff, 0x004cff, 0x0050ff, 0x0054ff, 0x0058ff, 0x005cff,
 0x0060ff, 0x0064ff, 0x0068ff, 0x006cff, 0x0070ff, 0x0074ff, 0x0078ff, 0x007cff,
 0x0080ff, 0x0084ff, 0x0088ff, 0x008cff, 0x0090ff, 0x0094ff, 0x0098ff, 0x009cff,
 0x00a0ff, 0x00a4ff, 0x00a8ff, 0x00acff, 0x00b0ff, 0x00b4ff, 0x00b8ff, 0x00bcff,
 0x00c0ff, 0x00c4ff, 0x00c8ff, 0x00ccff, 0x00d0ff, 0x00d4ff, 0x00d8ff, 0x00dcff,
 0x00e0ff, 0x00e4ff, 0x00e8ff, 0x00ecff, 0x00f0ff, 0x00f4ff, 0x00f8ff, 0x00fcff,
 0x00fffe, 0x00fffa, 0x00fff6, 0x00fff2, 0x00ffee, 0x00ffea, 0x00ffe6, 0x00ffe2,
 0x00ffde, 0x00ffda, 0x00ffd6, 0x00ffd2, 0x00ffce, 0x00ffca, 0x00ffc6, 0x00ffc2,
 0x00ffbe, 0x00ffba, 0x00ffb6, 0x00ffb2, 0x00ffae, 0x00ffaa, 0x00ffa6, 0x00ffa2,
 0x00ff9e, 0x00ff9a, 0x00ff96, 0x00ff92, 0x00ff8e, 0x00ff8a, 0x00ff86, 0x00ff82,
 0x00ff7e, 0x00ff7a, 0x00ff76, 0x00ff72, 0x00ff6e, 0x00ff6a, 0x00ff66, 0x00ff62,
 0x00ff5e, 0x00ff5a, 0x00ff56, 0x00ff52, 0x00ff4e, 0x00ff4a, 0x00ff46, 0x00ff42,
 0x00ff3e, 0x00ff3a, 0x00ff36, 0x00ff32, 0x00ff2e, 0x00ff2a, 0x00ff26, 0x00ff22,
 0x00ff1e, 0x00ff1a, 0x00ff16, 0x00ff12, 0x00ff0e, 0x00ff0a, 0x00ff06, 0x00ff02,
 0x02ff00, 0x06ff00, 0x0aff00, 0x0eff00, 0x12ff00, 0x16ff00, 0x1aff00, 0x1eff00,
 0x22ff00, 0x26ff00, 0x2aff00, 0x2eff00, 0x32ff00, 0x36ff00, 0x3aff00, 0x3eff00,
 0x42ff00, 0x46ff00, 0x4aff00, 0x4eff00, 0x52ff00, 0x56ff00, 0x5aff00, 0x5eff00,
 0x62ff00, 0x66ff00, 0x6aff00, 0x6eff00, 0x72ff00, 0x76ff00, 0x7aff00, 0x7eff00,
 0x82ff00, 0x86ff00, 0x8aff00, 0x8eff00, 0x92ff00, 0x96ff00, 0x9aff00, 0x9eff00,
 0xa2ff00, 0xa6ff00, 0xaaff00, 0xaeff00, 0xb2ff00, 0xb6ff00, 0xbaff00, 0xbeff00,
 0xc2ff00, 0xc6ff00, 0xcaff00, 0xceff00, 0xd2ff00, 0xd6ff00, 0xdaff00, 0xdeff00,
 0xe2ff00, 0xe6ff00, 0xeaff00, 0xeeff00, 0xf2ff00, 0xf6ff00, 0xfaff00, 0xfeff00,
 0xfffc00, 0xfff800, 0xfff400, 0xfff000, 0xffec00, 0xffe800, 0xffe400, 0xffe000,
 0xffdc00, 0xffd800, 0xffd400, 0xffd000, 0xffcc00, 0xffc800, 0xffc400, 0xffc000,
 0xffbc00, 0xffb800, 0xffb400, 0xffb000, 0xffac00, 0xffa800, 0xffa400, 0xffa000,
 0xff9c00, 0xff9800, 0xff9400, 0xff9000, 0xff8c00, 0xff8800, 0xff8400, 0xff8000,
 0xff7c00, 0xff7800, 0xff7400, 0xff7000, 0xff6c00, 0xff6800, 0xff6400, 0xff6000,
 0xff5c00, 0xff5800, 0xff5400, 0xff5000, 0xff4c00, 0xff4800, 0xff4400, 0xff4000,
 0xff3c00, 0xff3800, 0xff3400, 0xff3000, 0xff2c00, 0xff2800, 0xff2400, 0xff2000,
 0xff1c00, 0xff1800, 0xff1400, 0xff1000, 0xff0c00, 0xff0800, 0xff0400, 0xff0000,
 0xff0000};

#ifndef DBL_MAX
#define DBL_MAX 1.7976931348623157e+308
#endif

#ifndef FLT_MAX
#define FLT_MAX 3.40282347e+38
#endif

#define FINDMINMAX(ty, maxval) \
{\
 register ty *c1=(ty *)data;\
 register int i;\
 register ty mmin, mmax, mminplus;\
 int size = cols*rows; \
 mmax = mmin = *c1;\
 mminplus = maxval;\
 if (dominmax && dominplus) { \
   for (i=size;i;i--,c1++) {\
     if (*c1 < mmin)\
       mmin = *c1;\
     if (*c1 > mmax)\
       mmax = *c1;\
     if ((*c1 < mminplus) && (*c1 > 0))\
       mminplus = *c1;\
   }\
 } else if (dominmax) {\
   for (i=size;i;i--,c1++) {\
     if (*c1 < mmin)\
       mmin = *c1;\
     if (*c1 > mmax)\
       mmax = *c1;\
   }\
 } else if (dominplus) {\
   if (mmin > 0) \
     mminplus = mmin;\
   else \
     for (i=size;i;i--,c1++) {\
       if ((*c1 < mminplus) && (*c1 > 0))\
         mminplus = *c1;\
   }\
 }\
 dmin = (double)mmin;\
 dmax = (double)mmax;\
 dminplus = (double)mminplus;\
}
 
static PyObject *spslut_transformsimple(self, args)
     PyObject *self, *args;     
{
  void *data;
  int type, cols, rows, reduc, fastreduc, meth, autoscale, mapmin=0, mapmax=255;
  int palette_code;
  double gamma, min, max;
  XServer_Info Xservinfo;
  void *palette;
  int prows, pcols, pal_entries;
  void *r/*, *res*/;
  char *mode ;
  unsigned long *as_pointer;
  double  *as_r, a,b;
  int as_dim[3];
  int i,j,clean = 0;
  int dominmax =  1;
  int dominplus = 0;
  double dmin,dmax,dminplus;
  double delta;
  
  PyArrayObject *src;
  PyObject *in_src;
  PyArrayObject *aux;

  if (!PyArg_ParseTuple(args, "O|iddii", &in_src,
			                &autoscale, &min, &max,&mapmin, &mapmax)) 
		return NULL;

  src = (PyArrayObject*) in_src;
  if (src->descr->type_num != PyArray_DOUBLE) {
      /* I should use the standard method */
      if (!(src = (PyArrayObject*) PyArray_ContiguousFromObject(in_src, 
   			        PyArray_DOUBLE, 0, 0))) {
        PyErr_SetString(SPSLUTError, "Input Array could is not a 2x2 array");
        return NULL;
      }
      clean=1;
  }
  data = src->data;
  cols = src->dimensions[1];  /*FIX THIS cols and rows are turned around */
  rows = src->dimensions[0];  /*###CHANGED - ALEXANDRE 24/07/2001*/

  as_dim[0] = 4;
  as_dim[1] = rows * cols;
/*  printf("dim[0] = %d dim[1] = %d \"%s\" \n",as_dim[0],as_dim[1],mode); */
  aux = (PyArrayObject*) PyArray_FromDims(2,as_dim, PyArray_CHAR);
  if (aux == NULL){
    if (clean)
      Py_DECREF(src);
    return NULL;  
  }
  /*
switch (type) {
   case SPS_DOUBLE :
     FINDMINMAX(double, DBL_MAX);
     break;
   case SPS_FLOAT :
     FINDMINMAX(float, FLT_MAX);
     break;
   case SPS_LONG :
     FINDMINMAX(long, LONG_MAX);
     break;
   case SPS_ULONG :
     FINDMINMAX(unsigned long, ULONG_MAX);
     break;
   case SPS_SHORT :
     FINDMINMAX(short, SHRT_MAX);
     break;
   case SPS_USHORT :
     FINDMINMAX(unsigned short, USHRT_MAX);
     break;
   case SPS_CHAR :
     FINDMINMAX(char, SCHAR_MAX);
     break;
   case SPS_UCHAR :
     FINDMINMAX(unsigned char, UCHAR_MAX);
     break;
 }*/
 
 #if 0
    FINDMINMAX(double, DBL_MAX);
 #endif
 #if 0
    /* naif */
    as_r = (double *) src->data;
    dmin = dmax = *as_r;
    for (i=0; i< as_dim[1]; i++){
        if (*(as_r) < dmin){
            dmin = *(as_r);
        }else{
            if (*(as_r) > dmax)
                dmax = *(as_r);    
        }
        as_r++;
    }
 #endif
 #if 1 
   /* slightly faster */
  as_r = (double *) src->data;
  j = 0;
  dmin = DBL_MAX;
  dmax = -DBL_MAX;
  
  if (as_dim[1] % 2){
    dmax = *as_r;
    j++;
    as_r++;
  }
  
  for (i=j; i<(rows * cols-j)/2; i++){ 
    if (*(as_r) < *(as_r+1)){
       a = *(as_r);
       b = *(as_r++);
    }else{
       b = *(as_r);       
       a = *(as_r++);
    }
    as_r++;
    if (a < dmin) dmin = a;
    if (b > dmax) dmax = b;    
  }
 #endif
  as_r = (double *) src->data;
  as_pointer = (unsigned long *) aux -> data;
  delta      = 255. / (dmax - dmin);
  dmin = (dmin - 1) * delta;  
  for (i=0; i<as_dim[1]; i++){
   /* #ifdef __linux__
        FLOAT_TO_INT((dmin + delta * (*as_r)),j);
        *as_pointer = RGB256[j];
    #else
        *as_pointer = RGB256[lrint(dmin + delta * (*as_r))];
    #endif
    */
    *as_pointer = RGB256[lrint(dmin + delta * (*as_r))];
    as_pointer++;
    as_r++;
  }
  if (clean)
    Py_DECREF(src);
  PyArray_Return(aux);
}


/* The simple palette always returns 4 bytes per entry */
static PyObject *spslut_palette(self, args)
     PyObject *self, *args;
     
{
  int entries, palette_code;
  XServer_Info Xservinfo;
  void *r;
  char *mode;
  PyObject *res;

  if (!PyArg_ParseTuple(args, "ii", &entries, &palette_code)) 
    return NULL;
  
  mode = "RGBX";
  Xservinfo.red_mask = 0x0000ff;
  Xservinfo.green_mask = 0x00ff00;
  Xservinfo.blue_mask = 0xff0000;
  Xservinfo.pixel_size = 4;
  Xservinfo.byte_order = natbyteorder();

  r = SPS_SimplePalette ( 0, entries - 1, Xservinfo, palette_code); 
  
  if (r == 0) {
    PyErr_SetString(SPSLUTError, "Error calculating the palette");
    return NULL;
  }
  
  return new_pyimage(mode, 1, entries, r);
}


                                                                               
static PyMethodDef SPSLUTMethods[] = {
  { "transform", spslut_transform, METH_VARARGS},
  { "palette", spslut_palette, METH_VARARGS},
  { "transformArray", spslut_transformarray, METH_VARARGS},
  { "transformSimple", spslut_transformsimple, METH_VARARGS},
  { NULL, NULL}
};
  
void initspslut()
{
  PyObject *d, *m;
  /* Create the module and add the functions */
  m = Py_InitModule ("spslut", SPSLUTMethods);
  
  /* Add some symbolic constants to the module */
  d = PyModule_GetDict(m);

  PyDict_SetItemString(d, "LINEAR", PyInt_FromLong(SPS_LINEAR));
  PyDict_SetItemString(d, "LOG", PyInt_FromLong(SPS_LOG));
  PyDict_SetItemString(d, "GAMMA", PyInt_FromLong(SPS_GAMMA));

  PyDict_SetItemString(d, "GREYSCALE", PyInt_FromLong(SPS_GREYSCALE));
  PyDict_SetItemString(d, "TEMP", PyInt_FromLong(SPS_TEMP));
  PyDict_SetItemString(d, "RED", PyInt_FromLong(SPS_RED));
  PyDict_SetItemString(d, "GREEN", PyInt_FromLong(SPS_GREEN));
  PyDict_SetItemString(d, "BLUE", PyInt_FromLong(SPS_BLUE));
  PyDict_SetItemString(d, "REVERSEGREY", PyInt_FromLong(SPS_REVERSEGREY));
  PyDict_SetItemString(d, "MANY", PyInt_FromLong(SPS_MANY));

  SPSLUTError = PyErr_NewException("spslut.error", NULL, NULL);
  PyDict_SetItemString(d, "error", SPSLUTError);
  import_array();
}
