from Tkinter import *
from Tkinter import _cnfmerge
import ScrollFrame
import Selector
import tkSimpleDialog
import string
DEBUG=0

class Parameters(ScrollFrame.ScrollFrame):
    """Parameter class provides for each parameters :
       - info display
       - value entry
       - constraints parameters select button
    """ 
    def __init__(self,master,paramlist=[],cnf={},**kw):
        """
        Class constructor.
        Create a widget containing the parameters.
        paramlist is the list of parameters names.
        """
        self.master=master
        cnf = _cnfmerge((cnf,kw))
        ScrollFrame.ScrollFrame.__init__(self,master,cnf)
        #self.param_win = Parameter(self,param,relief='ridge',bd=2)
        #apply(ScrollFrame.ScrollFrame.__init__,(self,master,) + args)
        self.labels=['Parameter','Estimation','Fit Value','Sigma',
                     'Restrains','Min/Parame','Max/Factor/Delta/']
        self.code_options=["FREE","POSITIVE","QUOTED",
                 "FIXED","FACTOR","DELTA","SUM","IGNORE","ADD","SHOW"]
        if kw.has_key('labels'):
            self.labels=kw['labels']
        i=0
        lbl=[]
        for label in self.labels:
            lbl.append(Label(self,text=label,width=15,relief='groove'))
            lbl[i].grid(row=0,column=i,sticky='e')
            i=i+1                
        self.parameters={}
        self.paramlist=paramlist
        #if kw.has_key('paramlist'):
        #    self.paramlist = kw['paramlist']
        #    print kw['paramlist']
        self.numrows=0
        #self.config(width=500,height=300)
        #self.columnconfigure((1,2,3),weight=1)
        self.build()
        #self.connect(self,SIGNAL("valueChanged(int,int)"),self.myslot)


    def build(self):
        line = 1
        oldlist=list(self.paramlist)
        self.paramlist=[]
        for param in oldlist:
            self.newparameterline(param,line)
            line=line+1

    #def numRows(self):
    #    return self.numrows

    def newparameterline(self,param,line):
        #get current number of lines
        #nlines=self.numRows()
        #print "nlines =",nlines
        #if the number of lines is smaller than line resize table
        #if (line > nlines):
        #    self.setNumRows(line)
        #self.show()
        #fill the line
        linew=line-1
        name=StringVar()
        name.set(param)
        estimation  = StringVar()
        fitresult   = StringVar()
        sigma       = StringVar()
        code        = 'FREE'
        val1        = StringVar()
        val2        = StringVar()
        vmin        = 0
        vmax        = 1
        relatedto   = ''
        factor      = 1.0
        delta       = 0.0
        sum         = 0.0
        group       = 0
        xmin        = None
        xmax        = None
        self.parameters[param]={'line':linew,
                                'fields':['name',
                                          'estimation',
                                          'fitresult',
                                          'sigma',
                                          'code',
                                          'val1',
                                          'val2'],
                                'estimation':estimation,          
                                'fitresult':fitresult,
                                'sigma':sigma,
                                'code':code,
                                'val1':val1,
                                'val2':val2,
                                'cons1':0,
                                'cons2':0,
                                'vmin':vmin,
                                'vmax':vmax,
                                'relatedto':relatedto,
                                'factor':factor,
                                'delta':delta,
                                'sum':sum,
                                'group':group,
                                'name':name,
                                'xmin':xmin,
                                'xmax':xmax}
        self.paramlist.append(param)

        #to configure
        self.setReadWrite(param,['estimation','val1','val2'])
        self.setReadOnly(param,['name','fitresult','sigma'])

        #the code
        col=self.parameters[param]['fields'].index('code')
        self.parameters[param]['code_item']=Selector.Selector(self,
                             self.code_options,
                             command=lambda i, j=self, k=line, l=col: j.codeslot(i,k,l))
        self.parameters[param]['code_item'].grid(row=line,
                        column=self.parameters[param]['fields'].index('code'),
                        sticky="ew")
        self.parameters[param]['relatedto_item']=None
        #slot like operation
        #for field in  self.parameters[param]['fields']:
        #    if (field is not 'name') and (field is not 'code'):
        #           self.parameters[param][field].trace('w',self.myslot(line,col))
                                
    def setReadOnly(self,parameter,fields):
        if DEBUG:
            print "parameter ",parameter,"fields = ",fields,"asked to be read only"
        self.setfield(parameter,fields,0)
        
    def setReadWrite(self,parameter,fields):
        if DEBUG:
            print "parameter ",parameter,"fields = ",fields,"asked to be read write"
        self.setfield(parameter,fields,1)

    def setfield(self,parameter,fields,EditType):
        width=15
        if DEBUG:
            print "setfield. parameter =",parameter,"fields = ",fields
        if type(parameter) == type (()) or \
           type(parameter) == type ([]):
            paramlist=parameter
        else:
            paramlist=[parameter]
        if type(fields) == type (()) or \
           type(fields) == type ([]):
            fieldlist=fields
        else:
            fieldlist=[fields]

        for param in paramlist:
            if param in self.paramlist:            
                try:
                    row=self.paramlist.index(param)
                except ValueError:
                    row=-1
                if row >= 0:
                    for field in fieldlist:
                        if field in self.parameters[param]['fields']:
                            col=self.parameters[param]['fields'].index(field)
                        if field != 'code':
                            key=field+"_item"
                            #print "to be done!!!!!!!!"
                            if EditType == 0:
                                #Read only -> Label
                                self.parameters[param][key]=Label(self,
                                    textvariable=self.parameters[param][field],
                                    anchor='e',bd=1,
                                    relief='ridge',
                                    bg='#ffffff',width=width)
                            else:
                                #ReadWrite -> Entry
                                self.parameters[param][key]=Entry(self,
                                    textvariable=self.parameters[param][field],
                                    bg='#eec',width=width,
                                    justify='right')
                                self.parameters[param][key].bind("<Return>",
                                    lambda i,j=self,k=row+1,
                                    l=col:j.entryslot(i,k,l))
                                #self.parameters[param][key].bind("<Enter>",
                                #    self.setoldentryvalue)
                                #    #lambda i,j=self,k=row+1,
                                #    #l=col:j.entryslot(i,k,l))
   
                            self.parameters[param][key].grid(row=row+1,column=col)
                                                        
    def configure(self,*vars,**kw):
        if DEBUG:
            print "configure called with **kw = ",kw
        name=None
        error=0
        if kw.has_key('name'):
            name=kw['name']
        else:
            return 1
        if self.parameters.has_key(name):
            row=self.parameters[name]['line']
            for key in kw.keys():
              if key is not 'name':
                if key in self.parameters[name]['fields']:
                    col=self.parameters[name]['fields'].index(key)
                    if key is 'code':
                        newvalue=str(kw[key])
                    else:
                        oldvalue=self.parameters[name][key].get()
                        try:
                            newvalue=string.atof(str(kw[key]))
                            if key is 'sigma':
                                newvalue= "%6.3g" % newvalue
                            else:
                                newvalue= "%8g" % newvalue
                        except:
                            #I passed a parameter name
                            newvalue=str(kw[key])
                        #newvalue=QString(newvalue)
                    #avoid endless recursivity
                    if key is not 'code':
                        if self.validate(name,key,oldvalue,newvalue):
                            #self.setText(row,col,newvalue)
                            self.parameters[name][key].set(newvalue)
                            if key == 'estimation':
                                self.parameters[name]['old_estimation']=newvalue
                        else:
                            #self.setText(row,col,oldvalue)
                            self.parameters[name][key].set(oldvalue)
                            error=1
                    #else:
                    #    self.parameters[name][key]=newvalue
                    #    self.parameters[name]['code_item'].setCurrentItem(newvalue)
                elif key in self.parameters[name].keys():
                    #newvalue=QString(str(kw[key]))
                    self.parameters[name][key]=str(kw[key])
                    #if key == 'relatedto':
                    #    self.parameters[name]['relatedto_item'].setCurrentItem(newvalue)    
            if DEBUG:
                print "error = ",error
            #if error == 0:
            if 1:
                if 'code' in kw.keys():
                    newvalue=str(kw['code'])
                    self.parameters[name]['code']=newvalue
                    self.parameters[name]['code_item'].value.set(newvalue)
                    if str(self.parameters[name]['code']) == 'QUOTED':
                      if 'val1'in kw.keys():
                        self.parameters[name]['vmin']=str(kw['val1'])
                      if 'val2'in kw.keys():
                        self.parameters[name]['vmax']=str(kw['val2'])
                        #print "vmin =",str(self.parameters[name]['vmin'])
                    if str(self.parameters[name]['code']) == 'DELTA':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=str(kw['val1'])
                          else:
                            self.parameters[name]['relatedto']=\
                                self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['delta']=\
                            self.parameters[name]['val2'].get()
                    if str(self.parameters[name]['code']) == 'SUM':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=str(kw['val1'])
                          else:
                            self.parameters[name]['relatedto']=\
                                     self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['sum']=\
                            self.parameters[name]['val2'].get()
                    if str(self.parameters[name]['code']) == 'FACTOR':
                      if 'val1'in kw.keys():
                          if kw['val1'] in self.paramlist:
                            self.parameters[name]['relatedto']=str(kw['val1'])
                          else:
                            self.parameters[name]['relatedto']=\
                                     self.paramlist[int(string.atof(str(kw['val1'])))]
                      if 'val2'in kw.keys():
                        self.parameters[name]['factor']=\
                            self.parameters[name]['val2'].get()
                else:
                    #Update the proper parameter in case of change in val1 and val2
                    if str(self.parameters[name]['code']) == 'QUOTED':
                        self.parameters[name]['vmin']=self.parameters[name]['val1'].get()
                        self.parameters[name]['vmax']=self.parameters[name]['val2'].get()
                        #print "vmin =",str(self.parameters[name]['vmin'])
                    if str(self.parameters[name]['code']) == 'DELTA':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1'].get()
                        self.parameters[name]['delta']=self.parameters[name]['val2'].get()
                    if str(self.parameters[name]['code']) == 'SUM':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1'].get()
                        self.parameters[name]['sum']=self.parameters[name]['val2'].get()
                    if str(self.parameters[name]['code']) == 'FACTOR':
                        self.parameters[name]['relatedto']=self.parameters[name]['val1'].get()
                        self.parameters[name]['factor']=self.parameters[name]['val2'].get()
         
            if(1):
                #Update val1 and val2 according to the parameters
                #and Update the table
                if str(self.parameters[name]['code']) == 'FREE' or \
                   str(self.parameters[name]['code']) == 'POSITIVE' or \
                   str(self.parameters[name]['code']) == 'IGNORE' or\
                   str(self.parameters[name]['code']) == 'FIXED' :
                    self.parameters[name]['val1'].set('')
                    self.parameters[name]['val2'].set('')                   
                    self.parameters[name]['cons1']=0                   
                    self.parameters[name]['cons2']=0                   
                    self.setReadWrite(name,'estimation')
                    self.setReadOnly(name,['fitresult','sigma','val1','val2'])
                elif str(self.parameters[name]['code']) == 'QUOTED':
                    self.parameters[name]['val1'].set(str(self.parameters[name]['vmin']))
                    self.parameters[name]['val2'].set(str(self.parameters[name]['vmax']))
                    try:
                        self.parameters[name]['cons1']=\
                            string.atof(str(self.parameters[name]['val1'].get()))
                    except:
                        self.parameters[name]['cons1']=0
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2'].get()))
                    except:
                        self.parameters[name]['cons2']=0
                    if self.parameters[name]['cons1'] > self.parameters[name]['cons2']:
                        buf=self.parameters[name]['cons1']
                        self.parameters[name]['cons1']=self.parameters[name]['cons2']
                        self.parameters[name]['cons2']=buf
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'FACTOR':
                    self.parameters[name]['val1'].set(str(self.parameters[name]['relatedto']))
                    self.parameters[name]['val2'].set(str(self.parameters[name]['factor']))
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1'].get()))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2'].get()))
                    except:
                        error=1
                        print "Forcing factor to 1" 
                        self.parameters[name]['cons2']=1.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'DELTA':
                    self.parameters[name]['val1'].set(str(self.parameters[name]['relatedto']))
                    self.parameters[name]['val2'].set(str(self.parameters[name]['delta']))
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1'].get()))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2'].get()))
                    except:
                        error=1
                        print "Forcing delta to 0" 
                        self.parameters[name]['cons2']=0.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                elif str(self.parameters[name]['code']) == 'SUM':
                    self.parameters[name]['val1'].set(str(self.parameters[name]['relatedto']))
                    self.parameters[name]['val2'].set(str(self.parameters[name]['delta']))
                    self.parameters[name]['cons1']=\
                        self.paramlist.index(str(self.parameters[name]['val1'].get()))
                    try:
                        self.parameters[name]['cons2']=\
                            string.atof(str(self.parameters[name]['val2'].get()))
                    except:
                        error=1
                        print "Forcing sum to 0" 
                        self.parameters[name]['cons2']=0.0
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])
                else:
                    self.setReadWrite(name,['estimation','val1','val2'])
                    self.setReadOnly(name,['fitresult','sigma'])                                 
        return error
        
    def cget(self,param):
        """
        Return tuple estimation,constraints where estimation is the
        value in the estimate field and constraints are the relevant
        constraints according to the active code
        """
        estimation=None
        constraints=None
        if param in self.parameters.keys():
            buf=str(self.parameters[param]['estimation'].get())
            if len(buf):
                estimation=string.atof(buf)
            else:
                estimation=0
            self.parameters[param]['code_item']
            if str(self.parameters[param]['code']) in self.code_options:
                code = self.code_options.index(str(self.parameters[param]['code']))
            else:
                code = str(self.parameters[param]['code'])
            cons1=self.parameters[param]['cons1']
            cons2=self.parameters[param]['cons2']
            constraints = [code,cons1,cons2]
        return estimation,constraints 

    def fillfromfit(self,fitparameterslist):
        self.parameters={}
        self.paramlist=[]
        line=1
        for param in fitparameterslist:
            self.newparameterline(param['name'],line)
            line=line+1
        for param in fitparameterslist:
            name=param['name']
            code=str(param['code'])
            if code not in self.code_options:
                code=self.code_options[int(code)]
            val1=param['cons1']
            val2=param['cons2']
            estimation=param['estimation']
            group=param['group']
            sigma=param['sigma']
            fitresult=param['fitresult']
            if param.has_key('xmin'):
                xmin=param['xmin']
            else:
                xmin=''
            if param.has_key('xmax'):
                xmax=param['xmax']
            else:
                xmax=''
            self.configure(name=name,
                           code=code,
                           val1=val1,val2=val2,
                           estimation=estimation,
                           fitresult=fitresult,
                           sigma=sigma,
                           group=group,
                           xmin=xmin,
                           xmax=xmax)

    def fillfitfromtable(self):
        fitparameterslist=[]
        for param in self.paramlist:
            fitparam={}
            #name=self.parameters['name']
            name=param
            estimation,[code,cons1,cons2]=self.cget(name)
            buf=str(self.parameters[param]['fitresult'])
            xmin=self.parameters[param]['xmin']
            xmax=self.parameters[param]['xmax']            
            if len(buf):
                fitresult=string.atof(buf)
            else:
                fitresult=0.0
            buf=str(self.parameters[param]['sigma'])
            if len(buf):
                sigma=string.atof(buf)
            else:
                sigma=0.0
            buf=str(self.parameters[param]['group'])
            if len(buf):
                group=string.atof(buf)
            else:
                group=0
            fitparam['name']=name
            fitparam['estimation']=estimation
            fitparam['fitresult']=fitresult
            fitparam['sigma']=sigma
            fitparam['group']=group
            fitparam['code']=code
            fitparam['cons1']=cons1
            fitparam['cons2']=cons2
            fitparam['xmin']=xmin
            fitparam['xmax']=xmax
            fitparameterslist.append(fitparam)
        return fitparameterslist
    
    def codeslot(self,item,row,col):
        self.myslot(row,col)
        
    def entryslot(self,item,row,col):
        self.myslot(row,col)

    def getoldentryvalue(self,item,row,col):
        param=self.paramlist[row-1]
        field=self.parameters[param]['fields'][col]
        oldvalue=self.parameters[param][field].get()
        if field == 'estimation':
            #nothing to be done :(
            pass
        elif (self.parameters[param]['code'] == 'DELTA') | \
             (self.parameters[param]['code'] == 'SUM')   | \
             (self.parameters[param]['code'] == 'FACTOR'):
                if field == 'val1':
                    oldvalue=self.parameters[param]['relatedto']
                else:
                    oldvalue=self.parameters[param]['relatedto']
        elif self.parameters[param]['code'] == 'DELTA':
            pass
        return oldvalue
        
    def myslot(self,row,col):
        if DEBUG:
            print "Passing by myslot"        
        param=self.paramlist[row-1]
        field=self.parameters[param]['fields'][col]
        if field == 'val1':
            if (self.parameters[param]['code'] == 'DELTA') | \
               (self.parameters[param]['code'] == 'SUM')   | \
               (self.parameters[param]['code'] == 'FACTOR'):
                oldvalue=str(self.parameters[param]['relatedto'])
            else:
                oldvalue=str(self.parameters[param]['cons1'])
        elif field == 'val2':
            oldvalue=str(self.parameters[param]['cons2'])
        elif field == 'code':
            oldvalue=self.parameters[param]['code']
        elif field == 'estimation':
            if self.parameters[param].has_key('old_estimation'):
                oldvalue=self.parameters[param]['old_estimation']
            else:
                oldvalue='0'
        if field == 'code':
            newvalue=self.parameters[param][field+'_item'].value.get()
        else:            
            newvalue=self.parameters[param][field+'_item'].get()
        if DEBUG:
            print "old value = ",oldvalue
            print "new value = ",newvalue
        if self.validate(param,field,oldvalue,newvalue):
            #self.parameters[param][field]=newvalue
            if DEBUG:
                print "Change is valid"
            exec("self.configure(name=param,%s=newvalue)" % field)
        else:
            if DEBUG:
                print "Change is not valid"
            if field == 'code':
                self.parameters[param]['code_item'].value.set(oldvalue)
            else:
                #self.setText(row,col,oldvalue)
                exec("self.configure(name=param,%s=oldvalue)" % field)
    
    def validate(self,param,field,oldvalue,newvalue):
        if field == 'code':
            pass
            return self.setcodevalue(param,field,oldvalue,newvalue)
        if ((str(self.parameters[param]['code']) == 'DELTA') or\
            (str(self.parameters[param]['code']) == 'FACTOR') or\
            (str(self.parameters[param]['code']) == 'SUM')) and \
            (field == 'val1'):
                best,candidates=self.getrelatedcandidates(param)
                print "best =",best
                print "candidates = ",candidates
                if str(newvalue) in candidates:
                    return 1
                else:
                    return 0
        else:
            try:
                string.atof(str(newvalue))
            except:
                return 0
        return 1

    def setcodevalue(self,workparam,field,oldvalue,newvalue):
        if   str(newvalue) == 'FREE':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')                          
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'POSITIVE':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'QUOTED':
            #I have to get the limits
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=self.parameters[workparam]['vmin'],
                           #cons2=self.parameters[workparam]['vmax'])
                           #,
                           #val1=self.parameters[workparam]['vmin'],
                           #val2=self.parameters[workparam]['vmax'])
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)
            return 1
        elif str(newvalue) == 'FIXED':
            self.configure(name=workparam,
                           code=newvalue)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'FACTOR':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)    
            return 1
        elif str(newvalue) == 'DELTA':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'SUM':
            #I should check here that some parameter is set
            best,candidates=self.getrelatedcandidates(workparam)
            if len(candidates) == 0:
                return 0
            self.configure(name=workparam,
                           code=newvalue,
                           relatedto=best)
                           #,
                           #cons1=0,
                           #cons2=0,
                           #val1='',
                           #val2='')
            if str(oldvalue) == 'IGNORE':
                self.freerestofgroup(workparam)                
            return 1
        elif str(newvalue) == 'IGNORE':
            # I should check if the group can be ignored
            # for the time being I just fix all of them to ignore
            group=int(str(self.parameters[workparam]['group'].get()))
            candidates = []
            for param in self.parameters.keys():
                if group == int(str(self.parameters[param] ['group'].get())):
                    candidates.append(param)
            #print candidates 
            #I should check here if there is any relation to them
            for param in candidates:
                self.configure(name=param,
                               code=newvalue)
                               #,
                               #cons1=0,
                               #cons2=0,
                               #val1='',
                               #val2='')
            return 1
        elif str(newvalue) == 'ADD':
            group=int(string.atof(str(self.parameters[workparam]['group'].get())))
            if group == 0:
                #One cannot add a background group
                return 0
            i=0
            for param in self.paramlist:
                if i <=  int(string.atof(str(self.parameters [param] ['group'].get()))):
                    i = i + 1
            self.addgroup(i,group)
            return 0

        elif str(newvalue) == 'SHOW':
            print self.cget(workparam)
            return 0

        else:
            print "None of the others!"

    def addgroup(self,newg,gtype):
        line = 0
        newparam=[]
        oldparamlist=list(self.paramlist)
        for param in oldparamlist:
            line = line + 1
            paramgroup = int(string.atof(str(self.parameters [param] ['group'])))
            if paramgroup  == gtype:
                #Try to construct an appropriate name
                #I have to remove any possible trailing number
                #and append the group index
                xmin=self.parameters[param]['xmin']
                xmax=self.parameters[param]['xmax']
                j=len(param)-1
                while ('0' < param[j]) & (param[j] < '9'):
                    j=j-1
                    if j == -1:
                        break
                if j >= 0 :
                    newparam.append(param[0:j+1] + `newg`)
                else:
                    newparam.append(`newg`)
        for param in newparam:
            line=line+1
            self.newparameterline(param,line)
        for param in newparam:
            self.configure(name=param,group=newg,xmin=xmin,xmax=xmax)

    def freerestofgroup(self,workparam):
        if workparam in self.parameters.keys():
            group=int(string.atof(str(self.parameters[workparam]['group'])))
            for param in self.parameters.keys():
                if param != workparam:
                    if group == int(string.atof(str(self.parameters[param]['group']))):
                        self.configure(name=param,
                                       code='FREE',
                                       cons1=0,
                                       cons2=0,
                                       val1='',
                                       val2='')
                                       
    def getrelatedcandidates(self,workparam):
        best=None
        candidates = []
        for param in self.paramlist:
            if param != workparam:
                if str(self.parameters[param]['code']) != 'IGNORE' and \
                   str(self.parameters[param]['code']) != 'FACTOR' and \
                   str(self.parameters[param]['code']) != 'DELTA'  and \
                   str(self.parameters[param]['code']) != 'SUM' :
                        candidates.append(param)
        #Now get the best from the list
        if candidates == None:
            return best,candidates
        #take the previous one if possible
        if str(self.parameters[workparam]['relatedto']) in candidates:
            best=str(self.parameters[workparam]['relatedto'])
            return best,candidates
        #take the first with similar name
        for param in candidates:
                j=len(param)-1
                while ('0' < param[j]) & (param[j] < '9'):
                    j=j-1
                    if j == -1:
                        break
                if j >= 0 :
                    try:
                        pos=string.index(workparam,param[0:j+1])
                        if pos == 0:
                            best=param
                            return best,candidates
                    except:
                        pass
        #take the first
        return candidates[0],candidates             
         
    def setvalue(self,item,workparam):
        if (item == 'FREE'):
            self.parameters[workparam]['code']=item
            #put all the group FREE if it was a IGNORE group
            group = self.parameters[workparam]['group']
            for param in self.paramlist:
                if group == self.parameters[param]['group']:
                    code = self.parameters[param]['code']
                    if code == 'IGNORE':
                        self.parameters[param]['code']='FREE'

            #pass
        elif (item == 'POSITIVE'):
            self.parameters[workparam]['code']=item
            #put all the group FREE if it was a IGNORE group
            group = self.parameters[workparam]['group']
            for param in self.paramlist:
                if group == self.parameters[param]['group']:
                    code = self.parameters[param]['code']
                    if code == 'IGNORE':
                        self.parameters[param]['code']='FREE'

            #pass
        elif (item == 'QUOTED'):
            self.parameters[workparam]['code']=item
            #put all the group FREE if it was a IGNORE group
            group = self.parameters[workparam]['group']
            for param in self.paramlist:
                if group == self.parameters[param]['group']:
                    code = self.parameters[param]['code']
                    if code == 'IGNORE':
                        self.parameters[param]['code']='FREE'

            text=['1st limit','2nd limit']
            a = ParameterDialog(self,text=text,title=workparam)
            if a.result is not None:
                self.configure(name=workparam,
                               cons1=min(a.output),
                               cons2=max(a.output),
                               vmin=min(a.output),
                               vmax=max(a.output))
        elif (item == 'FIXED'):
            self.parameters[workparam]['code']=item
            #put all the group FREE if it was a IGNORE group
            group = self.parameters[workparam]['group']
            for param in self.paramlist:
                if group == self.parameters[param]['group']:
                    code = self.parameters[param]['code']
                    if code == 'IGNORE':
                        self.parameters[param]['code']='FREE'

            #pass
        elif (item == 'FACTOR') | (item == 'DELTA') | (item == 'SUM') :
            #print "previous code was ",self.parameters[workparam]['code'].get()
            self.parameters[workparam]['code'].set(item)
            #put all the group FREE if it was a IGNORE group
            group = self.parameters[workparam]['group']
            for param in self.paramlist:
                if group == self.parameters[param]['group']:
                    code = self.parameters[param]['code']
                    if code == 'IGNORE':
                        self.parameters[param]['code']='FREE'

            #print "Working parameter number is",workparam
            options = []
            text = []
            for param in self.paramlist:
                #print 'param ', param
                #print 'self.cget(param)',self.cget(param)
                if self.cget(param)[1] [0]  < 4:
                    if self.parameters [param]['code'] != 'IGNORE':
                        options.append(param)
            if options != []:
                text.append('Parameter')
                if item == 'FACTOR':
                    text.append('Factor')
                elif item == 'DELTA':
                    text.append('Delta')
                elif item == 'SUM':
                    text.append('Sum')
                a = ParameterDialog(self,text=text,options1=options,
                    title=workparam)
                #print "a.result",a.result
                #print "a.output",a.output
                if a.result is not None:
                    i = 0
                    cons1 = []
                    cons2 = a.output [1]
                    for param in self.paramlist:
                        if a.output [0] == param:
                            cons1 = i
                        else:
                            i = i + 1
                    if cons1 == []:
                        print 'a.output [0] = ',a.output [0]
                        for param in self.paramlist:
                            print 'param = ',param,'test = ',a.output[0] == param
                    else:
                        self.configure(name=workparam,
                           cons1=cons1,
                           cons2=cons2,
                           relatedto=a.output[0])
                else:
                    print 'WARNING parameter %s set to FREE' % workparam
                    self.parameters[workparam]['code']='FREE'
                #print "Working parameter number is",workparam
                #print "Its associated info is ",self.cget(workparam)
                #print "More detailed"
                #print "code",self.parameters[workparam]['code'].get()
                #print "cons1",self.parameters[workparam]['cons1'].get()
                #print "cons2",self.parameters[workparam]['cons2'].get()
                #print "relatedto",self.parameters[workparam]['relatedto'].get()
        if item == 'IGNORE':
            group = self.parameters [workparam] ['group']
            #print "I should ignore the group ",group
            self.ignoregroup(group)
        elif item == 'ADD':
            group = self.parameters [workparam] ['group']
            if group == 0:
                #One cannot add a background group
                self.parameters[workparam]['code']='FREE'
                return    
            i=0
            for param in self.paramlist:
                if i <=  self.parameters [param] ['group']:
                    i = i + 1
            group = self.parameters [workparam] ['group']
            code='FREE'
            #print "try to reset the code to free unless group ignored"
            for param in self.paramlist:
                if self.parameters[param]['group'] == group:
                    if self.parameters[param]['code'] == 'IGNORE':
                        code='IGNORE'
            self.parameters[workparam]['code']=code
            #add the group i, of type group
            self.addgroup(i,group)

    def addgroup(self,newg,gtype):
        line = 0
        newparam=[]
        for param in self.paramlist:
            line = line + 1
            paramgroup = self.parameters [param] ['group']
            if paramgroup  == gtype:
                #Try to construct an appropriate name
                #I have to remove any possible trailing number
                #and append the group index
                j=len(param)-1
                while ('0' < param[j]) & (param[j] < '9'):
                    j=j-1
                    if j == -1:
                        break
                if j >= 0 :
                    newparam.append(param[0:j+1] + `newg`)
                else:
                    newparam.append(`newg`)
        width=15
        for param in newparam:
            line=line+1
            self.constrains.append([0,0,0])
            self.paramlist.append(param)
            self.parameterline(param,line,width)
            self.configure(name=param,group=newg)


class ParameterDialog(tkSimpleDialog.Dialog):

    def __init__(self,master,text=None,options1=None,options2=None,**kw):
        if text is not None:         
            self.text=text
        else:
            self.text=["Label 1","Label 2"]

        if options1 is not None:
            self.options1 = options1
            self.selector1 = 1
        else:
            self.selector1 = 0

        if options2 is not None:
            self.options1 = kw["options2"]
            self.selector2 = 1
        else:
            self.selector2 = 0
        
        self.output = [[],[]]
        self.result = None    

        tkSimpleDialog.Dialog.__init__(self,master,**kw)
        
    def body(self,master):
    
        Label(master,text=self.text[0]).grid(row=0)
        Label(master,text=self.text[1]).grid(row=1)

        if self.selector1 == 1:
            self.output [0] = self.options1[0]
            self.e1  = Selector.Selector(master, self.options1,
                           command=lambda i, j = self, k = 0: j.setvalue(i,k))
            #              command=self.printitem)
        else:
            self.e1=Entry(master)

 
        if self.selector2 == 1:
            self.output [1] = self.options2[0]
            self.e2  = Selector.Selector(master ,self.options2,
                           command=lambda i, j = self, k = 1: j.setvalue(i,k))
            self.e2.value = self.options2[0]
            #              command=self.printitem)
        else:
            self.e2=Entry(master)

        self.e1.grid(row=0,column=1)
        self.e2.grid(row=1,column=1)
        return self.e1 # initial focus
        
    def setvalue(self,item,k):
        self.output [k] = item
    
    def apply(self):
        if self.selector1 == 1:
            pass
        else:
            self.output [0] = self.e1.get()
        if self.selector2 == 1:
            pass
        else:
            self.output [1] = self.e2.get()
        self.result = self.output




def paramtest():
    """
    Parameter class test function.
    """
    root = Tk()
    ###########
    #tp=Toplevel(root)
    root.geometry("600x400+50+50")
    tab=Parameters(root,paramlist=['Height','Position','FWHM'])
    tab.grid(row=0,column=0,sticky='nsew')
    root.rowconfigure(0,weight=1)
    root.columnconfigure(0,weight=1)

    #tab.showGrid()
    if (0):
        tab.setText(0,3,QString('Hello World!'))
        tab.setItem(0,1,qttable.QTableItem(tab,1,QString('a try')))
        check=qttable.QCheckTableItem(tab,QString("Check me!"))
        tab.setItem(0,2,check)
        a=QStringList()
        a.append("1")
        a.append("2")    
        checklist=qttable.QComboTableItem(tab,a)
        tab.setItem(0,0,checklist)
    tab.configure(name='Height',estimation='1234',group=0)    
    tab.configure(name='Position',code='FIXED',group=1)
    tab.configure(name='FWHM',group=1)
    #for item,value in tab.parameters['Position'].items():
    #    print item,value
    if 1:
        import specfile
        import Specfit
        from Numeric import sqrt,equal,array,Float,concatenate,arange,take,nonzero
        sf=specfile.Specfile('02021201.dat')
        scan=sf.select('14')
        #sf=specfile.Specfile('02022101.dat')
        #scan=sf.select('11')
        nbmca=scan.nbmca()
        mcadata=scan.mca(1)
        y=array(mcadata)
        #x=arange(len(y))
        x=arange(len(y))*0.0200511-0.003186
        fit=Specfit.Specfit()
        fit.setdata(x=x,y=y)
        fit.importfun("SpecfitFunctions.py")
        fit.settheory('Hypermet')
        fit.configure(Yscaling=1.,
                      WeightFlag=1,
                      PosFwhmFlag=1,
                      HeightAreaFlag=1,
                      FwhmPoints=50,
                      PositionFlag=1,
                      HypermetTails=1)        
        fit.setbackground('Linear')
        if 0:
            mcaresult=fit.mcafit(x=x,xmin=x[70],xmax=x[500])
        else:
            fit.estimate()
            tab.fillfromfit(fit.paramlist)
            #fit.startfit()
        #tab.grid()
        #tab.fillfromfit(fit.paramlist)
    root.mainloop()


if __name__ == '__main__':
    paramtest()
