/* file: mari.h
 * author: mcb (Sun May 27 02:45:23 MEST 2001)
 * type: C header to mari.c
 * what it is:
 */

/* error_base */
#define ERROR_BASE_MARI (error_t)3000

/* common error_codes */
#define NOT_IMPL_MARI_ERR ERROR_BASE_MARI + 1

/* structures */
typedef struct MarCCDDefault *MarDefPtr;
typedef struct MarCCDDefault {
  size_t dataword;
  size_t nx;
  size_t ny;
  size_t nn;
  size_t nbytes;
  size_t dataoffset;
  int_t binning;
} MarDef;


/* declarations */
extern MarDef get_mardef(int_t binning);
extern void printMarDef(MarDef md);
extern error_t uint16_mar_i(char *gfp, uint16_t *buffer,
                            int_t binning, size_t swap);
extern error_t sint32_mar_i(char *gfp, sint32_t *buffer,
                            int_t binning, size_t swap);
extern error_t double_mar_i(char *gfp, double_t *buffer,
                            int_t binning, size_t swap);
