from PyDisWindow import *
import PyDVT
import sys
import sps
import qt

__version__=  '1.0.0'
__author__ =  'EP - GB'


class PyDisImageGrab(Plugin):

	def OnStartInit(self):
		if "-grab" in sys.argv:
			name= sys.argv[sys.argv.index("-grab")+1]
			(spec,array)= name.split(":")
			if spec in sps.getspeclist():
				if array in sps.getarraylist(spec):
					return self.InitVar(spec, array)
				else:
					qt.QMessageBox.critical(None, "GRAB ERROR", \
						"Grab not used: array <%s> not found"%array)
			else:
				qt.QMessageBox.critical(None, "GRAB ERROR", \
					"Grab not used: spec <%s> not found"%spec)
		return 0

	def InitVar(self, spec, array):
		self.grabSpecName= spec
		self.grabArrayName= array

		self.select= {}
		self.rectMenuItem= {}
		self.pointMenuItem= {}

		return self.UpdateSpecArray("null", "null", "null", (0,0), (0,0))

	def OnFinishInit(self, app_window):
		self.app_window= app_window

	def GetInfoString(self):
		return "v. "+__version__

	def OnInitWindowPopupMenu(self, window):
		if isinstance(window.View, PyDVT.ImageView.ImageView) and \
		   hasattr(window, "Data") and isinstance(window.Data, PyDVT.SPSData.SPSData):
			view= window.View
			view.AddMenuSeparator()
			self.rectMenuItem[view]= view.AddMenuPopupItem("Rectangle Grab",
				Command.Command(self.CreateViewSelect, "rect", window), "checkbutton")
			view.MenuPopup.CheckItem(self.rectMenuItem[view], 0)
			self.pointMenuItem[view]= view.AddMenuPopupItem("Point Grab",
				Command.Command(self.CreateViewSelect, "point", window), "checkbutton")
			view.MenuPopup.CheckItem(self.pointMenuItem[view], 0)

	def CreateViewSelect(self, type, window):
		view= window.View
		rectChecked= view.MenuPopup.IsItemChecked(self.rectMenuItem[view])
		pointChecked= view.MenuPopup.IsItemChecked(self.pointMenuItem[view])

		if self.select.has_key(view):
			self.select[view].Destroy()
			view.MenuPopup.CheckItem(self.rectMenuItem[view],0)
			view.MenuPopup.CheckItem(self.pointMenuItem[view],0)
		if type=="rect" and not rectChecked:
			self.select[view]= PyDVT.ImageViewSelect.ImageViewSelectRect(window.Data,
							self._ViewSelectRect)
			self.select[view].ConnectView(view)
			view.MenuPopup.CheckItem(self.rectMenuItem[view], 1)
		elif type=="point" and not pointChecked:
			self.select[view]= PyDVT.ImageViewSelect.ImageViewSelectPoint(window.Data,
							self._ViewSelectPoint)
			view.MenuPopup.CheckItem(self.pointMenuItem[view], 1)
			self.select[view].ConnectView(view)

	def _ViewSelectRect(self, select):
		(pos1, pos2)= select.GetSelection()["BoundingRect"]
		(coord1, coord2)= (pos1.PageCoord, pos2.PageCoord)
		info= select.GetData().GetPageInfo(0)
		if self.UpdateSpecArray(info["SourceName"], info["Key"], "rect", coord1, coord2):
			self.app_window.statusBar().message("Rectangle Grab from %s to %s"%\
						(str(coord1), str(coord2)), 4000)

	def _ViewSelectPoint(self, select):
		(pos1, pos2)= select.GetSelection()["BoundingRect"]
		(coord1, coord2)= (pos1.PageCoord, pos2.PageCoord)
		info= select.GetData().GetPageInfo(0)
		if self.UpdateSpecArray(info["SourceName"], info["Key"], "point", coord1, coord2):
			self.app_window.statusBar().message("Point Grab at %s "%str(coord1), 4000)

	def UpdateSpecArray(self, spec, array, type, pt1, pt2):
		try:
			x1= min(pt1[0], pt2[0])
			x2= max(pt1[0], pt2[0])
			y1= min(pt1[1], pt2[1])
			y2= max(pt1[1], pt2[1])
			sps.putenv(self.grabSpecName, self.grabArrayName, "spec", str(spec))
			sps.putenv(self.grabSpecName, self.grabArrayName, "array", str(array))
			sps.putenv(self.grabSpecName, self.grabArrayName, "type", str(type))
			sps.putenv(self.grabSpecName, self.grabArrayName, "x1", str(pt1[0]))
			sps.putenv(self.grabSpecName, self.grabArrayName, "y1", str(pt1[1]))
			sps.putenv(self.grabSpecName, self.grabArrayName, "x2", str(pt2[0]))
			sps.putenv(self.grabSpecName, self.grabArrayName, "y2", str(pt2[1]))
			return 1
		except:
			qt.QMessageBox.critical(None, "GRAB ERROR", \
				"Cannot update shared grab array\nspec=%s ; array=%s"%\
				(self.grabSpecName, self.grabArrayName))
			return 0

plugin=PyDisImageGrab()
