"""
    PyDisEdfStack.py
    PyDis plugin to EdfFile Stack displaying 
"""
from PyDisWindow import *

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'
    


class PyDisEdfStackPlugin(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnStartInit (self):
        self.Semaphore=0
        return 1

    def OnInitMenuBar (self,menu_bar):
        menuFile=menu_bar.children()[0]
        menuFile.insertSeparator(4)
        menuFile.insertItem('Open S&tack',self.OpenStack,0,-1,4)
        
    def OnFinishInit (self,app_window):
        self.app_window=app_window
                
    def GetInfoString(self):
        return "v"+__version__

    ########################################################
    ### Private methods
    ########################################################
    def OpenStack(self):
        filter="EDF files (*.edf);;EDF files  (*);;"        
        fn = qt.QFileDialog.getOpenFileNames(filter,qt.QString(self.app_window.CurPath), self.app_window, None,qt.QString.null)                          
        files=[] 
        for file in fn: files.append(str(file))
        if len(files)==0: return
        files.sort()        
        window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,"Stack",{"AddSelection":0,"SelectionCallback":self.app_window.EventSelection,"UseColormapWidget":1,"AddReduc":1})
        window.shortName="Stack"
        window.fileName=files
        window.Data=EdfFileData.EdfFileData()
        window.DataSelection=DataSelection.RectSelection(window.Data)
        window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
        window.View.SetSource(window.Filter)        
        window.NumImages=len(files)
        self.SetStackViewMenu(window)
        self.PageSelect(window,0)
        self.app_window.CurPath=os.path.dirname(files[0])

    
    def SetStackViewMenu(self,window):        
        window.View.AddMenuSeparator()
        cascademenu=Menu(window.View.GetPopupMenu())
        cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        cascademenu.AddSeparator()
        if window.NumImages > 1:
            cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=self.EventDepthSelection),"radiobutton")        
            cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddSeparator()
        cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        cascademenu.SetCheckedRadio("Clear Selection")
        window.View.AddMenuPopupCascade("Selection",cascademenu)
        self.app_window.Set2DViewMenu(window)
        window.View.AddMenuSeparator()
        if window.NumImages > 1:
            window.image_selection_menu=Menu(window.View.GetPopupMenu())
            for i in range(window.NumImages):
                    window.image_selection_menu.AddCommand(os.path.split(window.fileName[i])[1],Command.Command(self.PageSelect,window,i),"radiobutton")
            window.image_selection_menu.SetCheckedRadio("1")
            window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            self.app_window.AddImageSlider(window,self.onImageSelectionSliderChanged)

    def onImageSelectionSliderChanged(self,page):
        window=self.app_window.mdi.activeWindow()
        if page != window.SelectedPage: self.PageSelect(window,page)

    def PageSelect(self,window,page):        
        if window.NumImages > 1:
            window.SelectedPage=page        
            short_name=os.path.split(window.fileName[page])[1]
            window.SetTitle(window.shortName + " - %d/%d - %s" % (page+1,window.NumImages,short_name))
            window.image_selection_menu.SetCheckedRadio(short_name)
            window.SliderLabel.setText("Image: %d" %(page+1,))            
            if window.Slider.value() != page: window.Slider.setValue(page)
        window.Data.SetSource(window.fileName[page])
        window.Data.LoadSource(0)



    def EventDepthSelection  (self,source):
        sel=source.GetDataSelection()
        origin=self.app_window.mdi.activeWindow()
        if sel==None or origin==None or hasattr(origin,"View")==0:return
        if origin.View.__class__ is not ExtendedImageView.ExtendedImageView or hasattr(origin,"sufix"):return
        if self.Semaphore: return
        self.Semaphore=1
        try:            
            pos = source.GetSelection()["BoundingRect"][0]
            if source.GetType()=="Point":
                windowname=str(origin)+" - Depth Point"
                sufix=" - Depth Point Selection (x=%d y=%d)" % pos.PageCoord                
                classname=GraphView.GraphView
                opts={"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
            else:
                if source.GetType()=="VLine":   
                    windowname=str(origin)+" - Depth VLine"                    
                    sufix=" - Depth Vertical Selection (x=%d)" % (pos.PageCoord[0],)
                else:
                    windowname=str(origin)+" - Depth HLine"                    
                    sufix=" - Depth Horizontal Selection (y=%d)" % (pos.PageCoord[1],)
                classname=ExtendedImageView.ExtendedImageView
                ###I'm setting "UseImageValues" to 1 because I don't have so far a DataSelection with coords convertion for cross-page selection
                opts={"UseImageValues":1,"AddSelection":0,"SelectionCallback":self.app_window.EventSelection,"UseColormapWidget":1}
            window=self.app_window.GetWindow(windowname)
            if window is None:
                window=ViewWindow (self.app_window.mdi,classname,windowname,opts,master_window=origin)
                if source.GetType()=="Point":
                    window.View.SetStyle("PointsLine")
                    self.app_window.Set1DViewMenu(window)
                else:
                    self.app_window.Set2DViewMenu(window)
            window.SetTitle(origin.shortName,sufix=sufix)
            
            if hasattr(window,"Data")==0 or window.Data is None: window.Data=EdfFileData.EdfFileData()
            if source.GetType()=="Point":
                window.View.SetLabels(x_label="Image",y_label="Value")
                append=0
                for file in origin.fileName:
                    window.Data.SetSource(file)
                    window.Data.LoadSource(0,pos=pos.PageCoord, size=(1,1),append=append,invalidate=0)
                    append=1
                if not hasattr(window,"pen"): window.pen=Pen((255,0,0),2,"solid")
                if hasattr(window,"DataSelection")==0:
                    window.DataSelection=DataSelection.DataSelection(window.Data,(0,0),(1,1),"ALL",1)                        
                    window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                    window.View.SetSource(window.Filter)
                else:
                    window.Data.Invalidate()
            else:
                append=0
                for file in origin.fileName:
                    window.Data.SetSource(file)
                    if source.GetType()=="VLine": window.Data.LoadSource(0,pos=(pos.PageCoord[0],0), size=(1,"ALL"),append=append,invalidate=0)
                    else:window.Data.LoadSource(0,pos=(0,pos.PageCoord[1]), size=("ALL",1),append=append,invalidate=0)
                    append=1
                if hasattr(window,"DataSelection")==0:
                    if source.GetType()=="VLine": window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),(1,"ALL"),"ALL")
                    else:window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),("ALL",1),"ALL")
                    window.Filter=ImageView.ColormapFilter("",window.DataSelection)
                    window.View.SetSource(window.Filter)
                else:
                    window.Data.Invalidate()            
        except: pass
        self.Semaphore=0

    
plugin=PyDisEdfStackPlugin()