"""
    Drawable1D.py
    1D Graphics displaying widget
        
"""

from PyDVT import __version__,__date__,__author__


import Tkinter
import Numeric
import string
import BltGraph
#import tkFont
from Binding import Pen,Brush

class Drawable_1D(BltGraph.BltGraph):
    def __init__(self,parent,zoom_mode="ON",scroll_mode="ON",**kw):
        BltGraph.BltGraph.__init__(self, parent,kw)
        self.parent=parent
        self.ScrollMode=scroll_mode
        if self.ScrollMode!="OFF":
            self.VScroll= Tkinter.Scrollbar(self.parent, orient='vertical')
            self.HScroll= Tkinter.Scrollbar(self.parent, orient='horizontal')

            self.VScroll.configure(command=self.vscroll)
            self.HScroll.configure(command=self.hscroll)
            self.HScroll.set(0, 1)
            self.VScroll.set(0, 1)

        self.bind('<ButtonPress-3>',self._RightButtonPress)
        #if self.popup_properties:
            #self.bind('<Double-Button-1>', self.popup_properties)	
        self.bind("<Motion>", self._Motion, "+")
        self.bind("<B1-Motion>", self._PressMotion, "+")
        self.bind("<ButtonRelease-1>", self._LeftButtonRelease, "+")
        self.bind("<ButtonPress-1>", self._LeftButtonPress, "+")
        self.bind("<Double-Button-1>", self._DoubleClick, "+")

        self.functions={}
        self.graphobjects={}
        self.nbsymbol=0

        self.xmintot, self.xmaxtot= 0, 1
        self.ymintot, self.ymaxtot= 0, 1
        self.y2mintot, self.y2maxtot= None, None

        self.viewinit= 0

        self.style= "Line"

        self.parent.SetZoomStyle(None, Brush((0,0,0),"fill_12"))



    def Show(self):
        self.grid(row=0,column=0,sticky="nsew")
        if self.ScrollMode!="OFF" and self.ScrollMode!="AUTO":
            self.VScroll.grid(row=0,column=1,sticky="ns")
            self.HScroll.grid(row=1,column=0,sticky="ew")

    def GetHeight(self):
        return self.winfo_height()

    def GetWidth(self):
        return self.winfo_width()

    def ToggleGridlines(self):
        self.gridlines.toggle()

    def SetLabels(self,title_label=None,x_label=None,y_label=None,y2_label=None):
        if title_label is not None: self.configure(title=title_label)
        if x_label is not None: self.axis['x']['title']= x_label
        if y_label is not None: self.axis['y']['title']= y_label
        if y2_label is not None: self.axis['y2']['title']= y2_label

    def SetEnv(self,xmin,xmax,ymin,ymax,y2min=None,y2max=None,reset_zoom=0):
        self.xmintot= xmin
        self.xmaxtot= xmax
        self.ymintot= ymin
        self.ymaxtot= ymax
        self.y2mintot= y2min
        self.y2maxtot= y2max
        if reset_zoom:
            self.ResetZoom()
        if not self.viewinit:
            self.ResetZoom()

    def SetLogX(self,on,minvalue=1):
        try:
            self.axis['x']['logscale']= on
        except:
            pass

    def SetLogY(self,on,minvalue=0.000001):
        try:
            self.axis['y']['logscale']= on
            self.axis['y2']['logscale']= on
        except:
            pass

    def SetPolarEnv(self,value):
        pass #TODO

    def EnableLegend(self,enable,position="bottom"):
        pass #TODO

    def RemoveGraphicObjects(self):
        pass #TODO

    def RemoveFunction(self,name=None):
        if name==None:       self.functions={}
        else:
            if name in self.functions.keys():  del self.functions[name]
            
    def SetFunction(self,name,function_pars):
        self.functions[name]=function_pars

    def SetFunctionItem(self,name,item,val):
        if name in self.functions.keys():
            self.functions[name][item]=val

    def hscroll(self, *args):
        if not self.viewinit: return
        if args[0]=='moveto':
            pos= float(args[1])
            (lo, hi)= self.HScroll.get()
        elif args[0]=='scroll':
            (lo, hi)= self.HScroll.get()
            if args[2]=='pages': pos= 0.2*int(args[1])+lo
            else:                pos= 0.1*int(args[1])+lo
        else:
            return
        if pos<0 and self.xmin>self.xmintot+.001:		pos= 0.
        if pos+(hi-lo)>1 and self.xmax<self.xmaxtot-.001:	pos= 1.-(hi-lo)
        if pos>=0 and pos+(hi-lo)<=1:
            newx= (pos*(self.xmaxtot-self.xmintot))+self.xmintot
            self.xmax= newx+(self.xmax-self.xmin)
            self.xmin= newx
            self.axis['x'].configure(min=self.xmin, max=self.xmax)
            self.sethscroll()

    def sethscroll(self):
        if not self.viewinit: return
        if (self.xmin, self.xmax)==(self.xmintot, self.xmaxtot):
            if self.ScrollMode=="AUTO":
                self.HScroll.grid_forget()
            else:
                self.HScroll.set(0, 1)
        else:
            range= self.xmaxtot-self.xmintot
            lo= (self.xmin-self.xmintot)/range
            hi= (self.xmax-self.xmintot)/range
            self.HScroll.set(lo, hi)
            if self.ScrollMode=="AUTO":
                 self.HScroll.grid(row=1,column=0,sticky="ew")

    def vscroll(self, *args):
        if not self.viewinit: return
        if args[0]=='moveto':
            (lo, hi)= self.VScroll.get()
            pos= float(args[1])
        elif args[0]=='scroll':
            (lo, hi)= self.VScroll.get()
            if args[2]=='pages': pos= 0.2*int(args[1])
            else:                pos= 0.1*int(args[1])
        else:
            return

        if pos<0 and self.ymax<self.ymaxtot-.001:		pos= 0.
        if pos+(hi-lo)>1 and self.ymax>self.ymintot+.001:	pos= 1.-(hi-lo)

        if pos>=0 and pos+(hi-lo)<=1:
            newy= self.ymaxtot-(pos*(self.ymaxtot-self.ymintot))
            self.ymin= newy-(self.ymax-self.ymin)
            self.ymax= newy
            self.axis['y'].configure(min=self.ymin, max=self.ymax)
            if self.y2mintot!=None and self.y2maxtot!=None:
                self.y2min= (float(self.ymin)-self.ymintot)*(float(self.y2maxtot)-self.y2mintot)/ \
                    (float(self.ymaxtot)-self.ymintot)+self.y2mintot
                self.y2max= (float(self.ymax)-self.ymintot)*(float(self.y2maxtot)-self.y2mintot)/ \
                    (float(self.ymaxtot)-self.ymintot)+self.y2mintot
                self.axis['y2'].configure(min=self.y2min, max=self.y2max)
            self.setvscroll()

    def setvscroll(self):
        if not self.viewinit: return
        if (self.ymin, self.ymax)==(self.ymintot, self.ymaxtot):
            if self.ScrollMode=="AUTO":
                 self.VScroll.grid_forget()
            else:
                 self.VScroll.set(0, 1)
        else:
            range= self.ymaxtot-self.ymintot
            lo= (self.ymaxtot-self.ymax)/range
            hi= (self.ymaxtot-self.ymin)/range
            self.VScroll.set(lo, hi)
            if self.ScrollMode=="AUTO":
                 self.VScroll.grid(row=0,column=1,sticky="ns")

    def Redraw(self):
        # --- create plot lists
        newnames= self.functions.keys()
        oldnames= self.getplotnames()

        # --- delete plots
        delnames= [ name for name in oldnames if name not in newnames ]
        for name in delnames:
            self.delplot(name)

        # --- add/update plots
        for (name, func) in self.functions.items():
            ydata= func['data']
            xdata= func['xdata']

            if func['yscale']:	yaxis= 'y2'
            else:		yaxis= 'y'

            cnf= self._get_plotconf(func)
            self.setplot(name, xdata, ydata, yaxis, **cnf)


    def IncrementalUpdate(self,function_name,range,restart=0):
        #TODO: Not yet implement, and "valid_range" keyword neither
        self.Redraw()

    def _get_plotconf(self, func):
        cnf= func['pen'].GetBlt()
        if func['symbol']==None or func['symbol']=='None': cnf['symbol']='none'
        else: cnf['symbol']=func['symbol']

        if self.style=='Points':
            cnf['linewidth']= 0
            cnf['dashes']= ""
        if self.style=='Points' or self.style=='PointsLine':
            #if func['symbol'] is not None: cnf['symbol']=func['symbol']
            #else: cnf['symbol']='circle'
            cnf['symbol']='circle'
        #else:
        #    cnf['symbol']= ""
        return cnf

    #TODO: Add bars
    def SetStyle(self,style):
        if style!=self.style:
            self.style=style
            for (name, func) in self.functions.items():
                cnf= self._get_plotconf(func)
                self.elements[name].configure(**cnf)

    def __SetScroll(self):
        self.sethscroll()
        self.setvscroll()

    def SetZoom (self,(x0,y0),(x1,y1)):
        if min(x0,x1)<max(x0,x1) and min(y0,y1)<max(y0,y1):
            self.xmin, self.xmax= min(x0,x1), max(x0,x1)
            self.ymin, self.ymax= min(y0,y1), max(y0,y1)
        
            self.axis['x'].configure(min=self.xmin, max=self.xmax)
            self.axis['y'].configure(min=self.ymin, max=self.ymax)
            if self.y2mintot!=None and self.y2maxtot!=None:
                self.y2min= (float(self.ymin)-self.ymintot)*(float(self.y2maxtot)-self.y2mintot)/ \
                    (float(self.ymaxtot)-self.ymintot)+self.y2mintot
                self.y2max= (float(self.ymax)-self.ymintot)*(float(self.y2maxtot)-self.y2mintot)/ \
                    (float(self.ymaxtot)-self.ymintot)+self.y2mintot
                self.axis['y2'].configure(min=self.y2min, max=self.y2max)
            if self.ScrollMode!="OFF":
                self.__SetScroll()

    def ResetZoom(self):
        self.axis['x'].configure(min=self.xmintot, max=self.xmaxtot)
        self.axis['y'].configure(min=self.ymintot, max=self.ymaxtot)
        if self.y2mintot!=None and self.y2maxtot!=None:
            self.axis['y2'].configure(min=self.y2mintot, max=self.y2maxtot)
        self.xmin, self.xmax= self.xmintot, self.xmaxtot
        self.ymin, self.ymax= self.ymintot, self.ymaxtot
        self.y2min, self.y2max= self.y2mintot, self.y2maxtot
        if self.ScrollMode!="OFF":
            self.__SetScroll()
        self.viewinit= 1

    def PutLine(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid")):
        opt= pen.GetBlt(1)
        if Y0==self.ymintot: Y0='-Inf'
        if Y1==self.ymaxtot: Y1='Inf'
        opt['coords']= ( X0,Y0,X1,Y1 )
        obj=self.marker_create('line', **opt)
        self.graphobjects[obj]="line"
        return obj

    #TODO: Doesn't work on Windows        
    def PutRectangle(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid"),brush=Brush((0,0,0),"fill_0")):
        opt= {}
        if pen is not None:	opt.update(pen.GetBlt(1))
        if brush is not None:	opt.update(brush.GetBlt())
        if Y0==self.ymintot: Y0='-Inf'
        if Y1==self.ymaxtot: Y1='Inf'
        opt['coords']= ( X0,Y0, X0,Y1, X1,Y1, X1,Y0 )
        obj=self.marker_create('polygon', **opt)
        self.graphobjects[obj]="rect"
        return obj

    def PutSymbol(self,X0,Y0,symbol="circle",pen=Pen((0,0,0),1,"solid"),yscale=0):
        #TODO: mind scale!
        obj= 'sy%d'%self.nbsymbol
        self.line_create(obj, xdata=(X0, ), ydata=(Y0, ), symbol=symbol, linewidth=0,
                outline=pen.GetColor(), pixels=10*pen.GetWidth())
        self.nbsymbol+=1
        self.graphobjects[obj]="symb"
        return obj
             
    def PutText(self,X0,Y0,text, align="center",orient=0.,pen=Pen((0,0,0),1,"solid"),style='normal',brush=Brush((255,255,255),"fill_100")): 
        obj=self.marker_create('text', coords=(X0,Y0), outline=pen.GetColor(),background=brush.GetColor(),
                               rotate=orient, anchor=align, text=text)
        #TODO in a efficient way : change text font style according to style argument : using tkFont works but takes a long time when displaying text objects 
        self.graphobjects[obj]="text"
        return obj

    def PutEllipse(self,X0,Y0,X1,Y1,pen=Pen((0,0,0),1,"solid"),brush=Brush((0,0,0),"fill_0")):
        return None

    def SetObjectCoords(self,obj,*args):
        if obj in self.graphobjects.keys():
            if self.graphobjects[obj]=="rect":
                coords= ()       
                coords+= (args[0], args[1])
                coords+= (args[0], args[3])
                coords+= (args[2], args[3])
                coords+= (args[2], args[1])
                self.marker_configure(obj, coords=coords)
            elif self.graphobjects[obj]=="symb":
               self.element_configure(obj, xdata=(args[0],), ydata=(args[1],))
            else:
                coords= ()
                for idx in range(0, len(args)-1, 2):
                    coords +=(args[idx], args[idx+1])
                self.marker_configure(obj, coords=coords)

    def GetObjectCoords(self,obj):
        if obj in self.graphobjects.keys():
            if self.graphobjects[obj]=="rect":
                coords=string.split(self.marker_cget(obj,'coords')," ")
                for i in range(len(coords)):
                    coords[i]=float(coords[i])
                xmin,ymin=coords[0],coords[1]
                xmax,ymax=coords[4],coords[5]
                return (xmin,ymin,xmax,ymax)
            else:
                coords=string.split(self.marker_cget(obj,'coords')," ")
                for i in range(len(coords)):
                    coords[i]=float(coords[i])
                return(coords)

    def EraseObject(self,obj):
        if obj in self.graphobjects.keys():
            if self.graphobjects[obj]=='symb':
                self.element_delete(obj)
            else:
                self.marker_delete(obj)
            del self.graphobjects[obj]

    def UpdateObject(self,obj,pen=None,brush=None,textOptsDic=None):
        if obj in self.graphobjects.keys():
            if self.graphobjects[obj]=="rect":
                opt= {}
                if pen is not None:	opt.update(pen.GetBlt(1))
                if brush is not None:	opt.update(brush.GetBlt())
                self.marker_configure(obj,**opt)
            elif self.graphobjects[obj]=="line":
                opt= {}
                if pen is not None:	opt.update(pen.GetBlt(1))
                self.marker_configure(obj,**opt)
            elif self.graphobjects[obj]=="text":
                opt= {}
                if pen is not None:	opt['outline']=pen.GetColor()
                if brush is not None:	opt['background']=brush.GetColor()
                if textOptsDic is not None:
                    if textOptsDic.has_key('orient'): opt['rotate']=textOptsDic['orient']
                    if textOptsDic.has_key('align'): opt['anchor']=textOptsDic['align']
                    if textOptsDic.has_key('text'): opt['text']=textOptsDic['text']
                self.marker_configure(obj,**opt)
            else: raise "Tkbinding : UpdateObject unimplemented for this object type : ",self.graphobjects[obj]


    def GetVisibleXAxis(self):
        xmin,ymin=self.GetDataPosition((self.xmin,self.ymin))
        xmax,ymax=self.GetDataPosition((self.xmax,self.ymax))
        return ((xmin,xmax))

    def GetVisibleYAxis(self):
        xmin,ymin=self.GetDataPosition((self.xmin,self.ymin))
        xmax,ymax=self.GetDataPosition((self.xmax,self.ymax))
        return ((ymin,ymax))

    def GetVisibleY2Axis(self):
        if self.y2min is not None and self.y2max is not None:
            xmin,y2min=self.GetDataPosition((self.xmin,self.y2min))
            xmax,y2max=self.GetDataPosition((self.xmax,self.y2max))
            return ((y2min,y2max))
        else:
            return ((self.ymin,self.ymax))
            
    def GetFunctionScale(self,name):
        try:
            return self.functions[name]["yscale"]
        except:
            return None
    
    def ImageCoord2ViewCoord(self, coord):
        return coord

    def ViewCoord2ImageCoord(self, coord):
        return coord

    def DataCoord2ViewCoord(self, coord):
        return self.transform(coord[0], coord[1])

    def ViewCoord2DataCoord(self, coord):
        return (self.inside(coord[0], coord[1]), self.invtransform(coord[0], coord[1]))

    def GetPlotPosition(self,(x,y)):        
        if self.axis['x']['logscale']==1: x=Numeric.log10(max(x,self.minvaluelogx))
        if self.axis['y']['logscale']==1: y=Numeric.log10(max(y,self.minvaluelogy))
        return (x,y)


    def GetDataPosition(self,(x,y)):
        if self.axis['x']['logscale']==1: x=pow(10.,x)
        if self.axis['y']['logscale']==1: y=pow(10.,y)
        return (x,y)



    def Save(self,filename='imTemp',format="BMP"):
        """
        take a snapshot of the graph frame, and save the image to hte given format 
        Allowed formats :
            - GIF, gif
            - PPM, ppm
            - PGM, pgm
            - BMP, bmp
            - JPEG, JPG, jpeg, jpg
        """
        #TODO: Optimize
        import os,StringIO
        import Image
        import ImageTk
        import tempfile
        # create a snapshot photoimage
        im=Tkinter.PhotoImage(master=self.parent) 
        #im=ImageTk.PhotoImage("RGB",(500,500))
        self.snap(im)
        #im.show()
        #buf=StringIO.StringIO()
        #print im.get(0,0)
        #for i in im.width():
        #    s=""
        #    for j in im.height():
        #        s.append(im.get(i,j))
        #        print im.get(i,j)
        #    buf.writeline(s)
                
        #im2=Image.open(buf)
        #buf.close()
        #im2=ImageTk.PhotoImage("RGB",(im.width(),im.height()))
        #im2.paste(im)
        #im2.save("/bliss/users/pascal/im2.bmp","BMP")
        # format extension
        radix,ext=os.path.splitext(filename)
        if format=='gif' or format=='GIF':
            filename=radix+"."+'gif'
        elif format=='ppm' or format=='PPM':
            filename=radix+"."+'ppm'
        elif format=='pgm' or format=='PGM':
            filename=radix+"."+'pgm'    
        elif format=='bmp' or format=='BMP':
            filename=radix+"."+'bmp'
        elif format=='jpg' or format=='jpeg' or format=='JPG' or format=='JPEG':
            filename=radix+"."+'jpg'
        else: format=None 
      
        if format is not None:
            #im.save(filename)
            # save Tkinter PhotoImage to ppm format in temporary file
            tmpFilePth=tempfile.mktemp('ppm')
            im.write(tmpFilePth,'ppm')
            # open this temp image using PIL Image 
            #pilim=Image.fromstring("RGB",(im.width(),im.height()),im.cget(data)) # try to read the data in the memory : not working
            pilim=Image.open(tmpFilePth)
            pilim.save(filename)
            os.remove(tmpFilePth)
        else: print "unsupported image format"


    def _RightButtonPress(self,event):
        self.parent._RightButtonPress(event)

    def _LeftButtonPress(self, e):
        self.parent._ButtonPress(self.ViewCoord2ImageCoord((e.x,e.y)))

    def _LeftButtonRelease(self, e):
        self.parent._ButtonRelease(self.ViewCoord2ImageCoord((e.x,e.y)))
            
    def _Motion(self, e):
        self.parent._Motion(self.ViewCoord2ImageCoord((e.x,e.y)))

    def _PressMotion(self,e):
        self.parent._ButtonPressMotion(self.ViewCoord2ImageCoord((e.x,e.y)))

    def _DoubleClick(self, e):
        self.parent._DoubleClick(self.ViewCoord2ImageCoord((e.x,e.y)))
