from DataSelection import OrthoLineSelection

class SPSMcaSelection(OrthoLineSelection):
	def __init__(self, source, spec=None, array=None, plot=0, x=0, y=1, synchronized=1):
		"""
		Initialization parameters:
			- source: Data Object
			- spec: name of spec session
			- array: name of spec shared array
			- plot (default=0): 0 means columns, 1 means rows
			- x (default=0): x index in array (if -1, an array of index will be generated)
			- y (default=1): y index
		"""
		if spec is None:
			spec= source.SourceName
		if array is None:
			alist= source.GetSourceInfo["KeyList"]
			if len(alist): array= alist[0]
		page= {"SourceName": specname, "Key":arrayname}

		(yposition, ysize)= self.ConvertInPositionAndSize(plot, y)
		OrthoLineSelection.__init__(self, source, yposition, ysize, page, synchronized)

		if x!=-1:
			(xposition, xsize)= self.ConvertInPositionAndSize(plot, x)
			self.xSelection= OrthoLineSelection(source, xposition, xsize, page, 0)
		else:
			self.xSelection= None
			
		self.plot= plot
		self.xIdx= x
		self.yIdx= y

	def ConvertInPositionAndSize(self, plot, idx):
		"""
		Convert plot/index into DataSelection coordinates (position and size)
		"""
		if plot==0:
			return ( (idx,0), (1,"ALL") )
		else:	return ( (0,idx), ("ALL",1) )

	def GetOutput(self):
		"""
		Return a dictionnary with:
			- data: numeric array for y data
			- xdata: numeric array for x data
		"""
		ysel= OrthoLineSelection.GetOutput(self)
		if not ysel.has_key("data"): return {}

		if self.xSelection is not None:
			xsel= self.xSelection.GetOutput()
		else:	xsel= {}

		if not xsel.has_key("data"):
			ysel["xdata"]= Numeric.arrayrange(ysel["data"].shape[0])
		else:	ysel["xdata"]= xsel["data"]

		return ysel

	def GetInfo(self):
		"""
		Retrieve SPSMcaSelection informations
		"""
		info= OrthoLineSelection.GetInfo(self)
		info["plot"]= self.plot
		info["x"]= self.xIdx
		info["y"]= self.yIdx
		legend= "%s:%s"%(self.IndexList[0]["SourceName"], self.IndexList[0]["Key"])
		if self.plot:
			info["legend"]= "%s:C:%d:%d"%(legend, self.xIdx, self.yIdx)
		else:	info["legend"]= "%s:R:%d:%d"%(legend, self.xIdx, self.yIdx)
		info["type"]= "SpecArray"
		return info

	def Destroy(self, source=None):
		if self.xSelection is not None:
			self.xSelection.Destroy()
		OrthoLineSelection.Destroy(self)

	def Reconfig(self, name=None, key=None, plot=None, x=None, y=None):
		"""
		Reconfigure the current selection with new parameters.
		A Refresh is called so that linked object are informed of the changes.
		"""
		if name is not None:
			self.IndexList[0]["SourceName"]= name
		if key is not None:
			self.IndexList[0]["Key"]= key
		if plot is not None:
			self.plot= plot
		if x is not None:
			self.xIdx= x
		if y is not None:
			self.yIdx= y

		(ypos, ysize)= self.ConvertInPositionAndSize(self.plot, self.yIdx)
		(xpos, xsize)= self.ConvertInPositionAndSize(self.plot, self.xIdx)

		self.Position= ypos
		self.Size= ysize

		if self.xIdx==-1:
			if self.xSelection is not None:
				self.xSelection.Destroy()
				self.xSelection= None
		else:
			if self.xSelection is None:
				self.xSelection= OrthoLineSelection(self.Source, xpos, xsize, self.IndexList[0], 0)
			else:	self.xSelection.Reconfig(position=xpos, size=xsize, index_list= self.IndexList)
		self.Refresh()
