"""
    ColormapEditorWidget.py
    Binding implementation of controls for ColormapSelect
        
"""

from PyDVT import __version__,__date__,__author__
from Binding import *
import qt


class ColormapEditorWidget(qt.QHBox):
    def __init__(self,parent,initial_colormap):
        self.Parent=parent
        self.MinMax=initial_colormap["MinMax"]
        self.Scale=initial_colormap["Scale"]
        self.Colormap=initial_colormap["Colormap"]
        self.AutoScale=initial_colormap["AutoScale"]
        self.AbsoluteMinMax=initial_colormap["AbsoluteMinMax"]
        
        qt.QHBox.__init__(self,parent)
        
        self.setSpacing (20)
        self.box1 = qt.QVBox( self )
        self.box2 = qt.QVBox( self )
        self.box2b= qt.QVBox( self.box2 )
        self.box2a= qt.QVBox( self.box2 )
        self.box3 = qt.QVBox( self )
        
        self.BGScale = qt.QButtonGroup( 1, qt.QGroupBox.Horizontal, "Scale", self.box1 )
        self.BGScale.setRadioButtonExclusive( 1 )
        self.rLinear=qt.QRadioButton("Linear",self.BGScale,"Linear")
        self.rLoga=qt.QRadioButton("Logarithmic",self.BGScale,"Logarithmic")
        self.rGamma=qt.QRadioButton("Gamma",self.BGScale,"Gamma")
        
        
        self.Min=qt.QLabel(self.box2b)
        self.slMin = qt.QSlider(qt.Qt.Horizontal,self.box2b,"Min")
        self.setMin=qt.QLineEdit(self.box2b)
        self.slMin.setPageStep(0)
        self.slMin.setRange(0,50000)
        self.slMin.setValue(0)
        self.connect(self.slMin,qt.SIGNAL("valueChanged(int)"),self.minChanged)
        self.connect(self.setMin,qt.SIGNAL("returnPressed()"),self.minForced)
        self.connect(self.slMin,qt.SIGNAL("sliderReleased()"),self.ApplyNoAutoscale)
        
        self.separator=qt.QLabel(self.box2b)
        self.Max=qt.QLabel(self.box2b)
        self.slMax = qt.QSlider(qt.Qt.Horizontal,self.box2b,"Max")
        self.setMax=qt.QLineEdit(self.box2b)
        self.slMax.setPageStep(0)
        self.slMax.setRange(0,50000)
        self.slMax.setValue(0)
        self.connect(self.slMax,qt.SIGNAL("valueChanged(int)"),self.maxChanged)
        self.connect(self.setMax,qt.SIGNAL("returnPressed()"),self.maxForced)
        self.connect(self.slMax,qt.SIGNAL("sliderReleased()"),self.ApplyNoAutoscale)
                
        self.cAutoScaleButton=qt.QPushButton(qt.QString("Autoscale"),self.box2a)
        self.cAutoScaleButton.setAutoDefault(0)
        self.connect(self.cAutoScaleButton,qt.SIGNAL("clicked()"),self.ApplyAutoscale)
        
        self.lbCE=qt.QListBox(self.box3,"Colormap")
        if GetDisplayProperties() ["DISPLAY_DEPTH"]==8:
            colormap_list=["GrayScale","Temperature","RevGrey"]
        else:
            colormap_list=["GrayScale","Temperature","Red","Green","Blue","RevGrey"]
        for item in colormap_list:
            self.lbCE.insertItem (item)

        if self.Scale=="Linear":
            self.BGScale.setButton(0)
            self.slMin.setEnabled(1)
            self.Min.setEnabled(1)
        else:
            if self.Scale=="Logarithmic":  self.BGScale.setButton(1)
            if self.Scale=="Gamma": self.BGScale.setButton(2)
            self.slMin.setEnabled(0)
            self.Min.setEnabled(0)
        self.connect(self.BGScale,qt.SIGNAL("clicked(int)"),self.Apply)
        if self.AutoScale:
            self.DefSliderMinMax(self.AbsoluteMinMax)
        else:
            self.DefSliderMinMax(self.MinMax)
        self.lbCE.setCurrentItem (self.lbCE.findItem(self.Colormap))
        self.connect(self.lbCE,qt.SIGNAL("selectionChanged()"),self.Apply)
        self.Parent.resize( 400, 200 )



    def DefSliderMinMax(self,MinMax):
        self.slMin.setValue(self.Float2Slider(MinMax[0]))
        self.Min.setText("Min: %04.2f" % (self.Slider2Float(self.slMin.value())) )
        self.slMax.setValue(self.Float2Slider(MinMax[1]))
        self.Max.setText("Max: %04.2f" % (self.Slider2Float(self.slMax.value())) )
        

    def Slider2Float( self, value ):
        return ((float(self.AbsoluteMinMax[1])-float(self.AbsoluteMinMax[0]))*value/50000+float(self.AbsoluteMinMax[0]))           

    def Float2Slider( self, value ):
        if self.AbsoluteMinMax[1]-self.AbsoluteMinMax[0] == 0:
            return 0
        else:
            return int((float(value)-float(self.AbsoluteMinMax[0]))*50000/(float(self.AbsoluteMinMax[1])-float(self.AbsoluteMinMax[0])))

    def minChanged( self, value ):
        self.Min.setText("Min: %04.2f" % (self.Slider2Float(value)) )

    def maxChanged( self, value ):
        self.Max.setText("Max: %04.2f" % (self.Slider2Float(value)) )

    def minForced( self):
        self.slMin.setValue(self.Float2Slider(float(str(self.setMin.text()))))
        self.ApplyNoAutoscale()
    def maxForced( self ):
        self.slMax.setValue(self.Float2Slider(float(str(self.setMax.text()))))
        self.ApplyNoAutoscale()

    def ApplyAutoscale(self):
        self.AutoScale=1
        self.Apply()

    def ApplyNoAutoscale(self):
        self.AutoScale=0
        self.Apply()

        
    def Apply( self ):
        Scale=str(self.BGScale.selected().text())
        if Scale=="Linear":
            self.slMin.setEnabled(1)
            self.Min.setEnabled(1)
        else:
            self.slMin.setEnabled(0)
            self.Min.setEnabled(0)
        MinMax=(self.Slider2Float(self.slMin.value()),self.Slider2Float(self.slMax.value()))
        Colormap=str(self.lbCE.currentText())
        AutoScale=self.AutoScale
        self.Parent.Apply({"MinMax":MinMax,"Scale":Scale,"Colormap":Colormap,"AutoScale":AutoScale})
        if self.AutoScale: self.DefSliderMinMax(self.AbsoluteMinMax)
        
