"""
    Operator.py
    Operator base class
"""

from PyDVT import __version__,__date__,__author__


import AM_EventHandler as EventHandler


class Operator:
    """
    Filter-like class, with the same interface, but initialized
    with sequence of sources, on which implements an operation.
    See Filter documentation.
    """
    def __init__(self,source_seq,synchronized=1,buffer_input=0):
        """
        source_seq: sequence of sources
        """        
        self.eh=EventHandler.EventHandler()
        self.DataChange = self.eh.create("DataChange")
        self.DeleteEvent = self.eh.create("DeleteEvent")        
        self.Synchronized=synchronized
        self.BufferInput=buffer_input
        if self.BufferInput: self.Input=[]        
        DataRef=[]
        for  source in source_seq:
            source.eh.register("DeleteEvent",self.Destroy)            
            if self.Synchronized:
               source.eh.register("DataChange",self.DataChanged)
            if hasattr (source,"DataRef"):
                DataRef.append(source.GetData())
            else:
                DataRef.append(source)
        else:
            self.DataRef=()
            self.Source=()
        self.Source=tuple(source_seq)
        self.DataRef=tuple(DataRef)
        self.Alive=1
        if buffer_input: self.DataChanged(None)


    def SetSynchronized(self,synchronized):
        if synchronized!=self.Synchronized:
            self.Synchronized=synchronized
            for source in self.Source:
                    if self.Synchronized:
                        source.eh.register("DataChange",self.DataChanged)
                    else:
                        source.eh.unregister("DataChange",self.DataChanged)


    def Refresh(self):
        if self.Source is not (): self.eh.event(self.DataChange, self)

    def GetNumberSources(self):
        return len(self.Source)

    def GetSource(self,index=0):
        try: return self.Source[index]
        except: return None
             
    def GetInput(self,index):
        if self.BufferInput:
            if index >= len(self.Input):return {}
            return self.Input[index]
        else:
            source=self.GetSource(index)
            if source is None: return {}
            return source.GetOutput()
            
    def GetData(self,index=0):
        try: return self.DataRef[index]
        except: return None


    def GetDataSelection(self,index=0):
        try: 
            obj=self
            source=self.GetSource[index]
            while (1):            
                if source==self.DataRef: return obj
                if source==None:return None
                obj=source
                source=self.GetSource()
        except: return None
            


    def Destroy(self,source=None):
        if self.Alive==0: return
        self.eh.event(self.DeleteEvent, self)     

        for source in self.Source:
            if source.eh is not None:
                source.eh.unregister("DataChange",self.DataChanged)
                if self.Synchronized:
                    source.eh.unregister("DeleteEvent",self.Destroy)
        self.Source=()
        self.DataRef=()
        self.eh=None
        self.Alive=0

#################################
#       OVERRIDABLES
#################################
    def DataCoord2SelectionCoord(self,data_coord):
        source=self.GetSource()
        if source is not None:
            return source.DataCoord2SelectionCoord(data_coord)
        return (-1,-1)


    def SelectionCoord2DataCoord(self,selection_coord):
        source=self.GetSource()
        if source is not None:
            return source.SelectionCoord2DataCoord(selection_coord)
        return DataPosition(-1,(-1,-1))


    def DataChanged(self,par):        
        #if self.Source is not ():
            if self.BufferInput:
                self.Input=[]
                for source in self.Source:
                    self.Input.append(source.GetOutput())
            self.Refresh()


#################################
#       VIRTUAL
#################################

    def GetOutput(self):
        return {}
