"""
    GraphViewSelect.py
    ViewSelect derived classes to GraphView 

"""    

from PyDVT import __version__,__date__,__author__

from ViewSelect import *



class GraphViewSelectHLine(ViewSelectDefault):
  """
  Implemets an horizontal line selection
  """
  
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Position=pos.DataCoord
    for view in self.ViewList.keys():   self.DrawTemp(view)


  def Release(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.SetSelectionPos((pos.DataCoord,pos.DataCoord))


  def DrawSelection(self,view):    
    """
    Virtual: See ViewSelectDefault
    """
    (xmin,xmax)= view.GetXAxis()
    if "BoundingRect" not in self.Selection.keys(): return
    ((x0,y0),(x1,y1))=self.Selection["BoundingRect"]
    if "SelectDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDraw"]=view.Drawable.PutLine(xmin,y0,xmax,y1,self.Pen)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"],xmin,y0,xmax,y1)


  def DrawTemp(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    pos=self.Position
    (xmin,xmax)= view.GetXAxis()
    if "TempDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["TempDraw"]=view.Drawable.PutLine( xmin, pos[1], xmax, pos[1],Pen(self.Pen.color,self.Pen.width,"dotted"))
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], xmin, pos[1], xmax, pos[1])


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "HLine"



class GraphViewSelectVLine(ViewSelectDefault):
  """
  Implemets an horizontal line selection
  """
  
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Position=pos.DataCoord
    for view in self.ViewList.keys():   self.DrawTemp(view)


  def Release(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.SetSelectionPos((pos.DataCoord,pos.DataCoord))


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    (ymin,ymax)= view.GetYAxis()
    if "BoundingRect" not in self.Selection.keys(): return
    ((x0,y0),(x1,y1))=self.Selection["BoundingRect"]
    if "SelectDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDraw"]=view.Drawable.PutLine(x0,ymin,x1,ymax,self.Pen)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"], x0,ymin,x1,ymax)


  def DrawTemp(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    
    pos=self.Position
    (ymin,ymax)= view.GetYAxis()
    if "TempDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["TempDraw"]=view.Drawable.PutLine(pos[0], ymin, pos[0], ymax,Pen(self.Pen.color,self.Pen.width,"dotted"))
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], pos[0], ymin, pos[0], ymax)


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "HLine"



class GraphViewSelectRect(ViewSelectDefault):
  """
  Implemets a rectangle selection
  """
  
  def PressMotion(self,pos):
      """
      Virtual: See ViewSelect
      """
      mouse_position=pos.DataCoord
      for view in self.ViewList.keys():   
        self.DrawTemp(view,mouse_position)


  def Press(self,pos):
      """
      Virtual: See ViewSelect
      """
      self.Erase("ALL")
      self.Selection={}
      self.Begin=pos.DataCoord


  def Release(self,pos):
      """
      Virtual: See ViewSelect
      """
      if hasattr(self,"Begin")==0: return
      self.SetSelectionPos((self.Begin,pos.DataCoord ))


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    if "BoundingRect" not in self.Selection.keys(): return
    self.EraseTemp(view)
    ((x0,y0),(x1,y1))=self.Selection["BoundingRect"]
    if "SelectDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDraw"]=view.Drawable.PutRectangle(x0,y0,x1,y1,self.Pen,self.Brush)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"], x0,y0,x1,y1)


  def DrawTemp(self,view,mouse_position):
    """
    Virtual: See ViewSelectDefault
    """
    if hasattr(self,"Begin")==0: return
    start=self.Begin
    end=mouse_position    
    if "TempDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["TempDraw"]=view.Drawable.PutRectangle(start[0], start[1], end[0], end[1],self.Pen,self.Brush)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start[0], start[1], end[0], end[1])

  def GetType(self):
      return "Rect"
  

class GraphViewSelectHRect(ViewSelectDefault):
  """
  Implemets a rectangle selection
  """
  
  def PressMotion(self,pos):
      """
      Virtual: See ViewSelect
      """
      mouse_position=pos.DataCoord
      for view in self.ViewList.keys():   
        self.DrawTemp(view,mouse_position)


  def Press(self,pos):
      """
      Virtual: See ViewSelect
      """
      self.Erase("ALL")
      self.Selection={}
      self.Selection["Begin"]= pos.DataCoord


  def Release(self,pos):
      """
      Virtual: See ViewSelect
      """
      if not self.Selection.has_key("Begin"): return
      
      if pos.DataCoord[0]>=self.Selection["Begin"][0]:
          start= self.Selection["Begin"]
	  end= pos.DataCoord
      else:
	  start= pos.DataCoord
          end= self.Selection["Begin"]
      self.SetSelectionPos((start,end))


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    if "BoundingRect" not in self.Selection.keys(): return
    self.EraseTemp(view)
    ((x0,y0),(x1,y1))=self.Selection["BoundingRect"]
    (ymin,ymax)= view.GetYAxis()
    if "SelectDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDraw"]=view.Drawable.PutRectangle(x0, ymin,x1, ymax,self.Pen,self.Brush)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"],x0, ymin, x1, ymax)


  def DrawTemp(self,view,mouse_position):
    """
    Virtual: See ViewSelectDefault
    """
    if not self.Selection.has_key("Begin"): return
    self.Selection["End"]= mouse_position
    (ymin,ymax)= view.GetYAxis()
    start= self.Selection["Begin"]
    end= self.Selection["End"]

    if "TempDraw" not in self.ViewList[view].keys():
        self.ViewList[view]["TempDraw"]=view.Drawable.PutRectangle(start[0], ymin, end[0], ymax,self.Pen,self.Brush)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start[0], ymin, end[0], ymax)


  def GetType(self):
      """
      Virtual: See ViewSelect
      """
      return "HRect"



class GraphViewSelectMousePosition(ViewSelectDefault):
  """
  Implemets a position selection - continous event generation
  """
  
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Selection["Position"]=pos
    self.Selection["BoundingRect"]=((pos.DataCoord[0], pos.DataCoord[1]), (pos.DataCoord[0], pos.DataCoord[1]))
    self.NotifySelection()


  def PressMotion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Motion(pos)


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "MousePosition"



class GraphViewSelectCrosshairs(ViewSelectDefault):
  """
  Implemets a crosshair selection - continous event generation + 2 orthogonal lines
  """
  
  def __init__(self,data=None,callback=None):
    """
    See ViewSelect
    """
    ViewSelect.__init__(self,data,callback)
    self.Pen=Pen((0,0,0),0,"dotted")

        
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Selection["Position"]=pos
    self.Selection["BoundingRect"]=((pos.DataCoord[0], pos.DataCoord[1]), (pos.DataCoord[0], pos.DataCoord[1]) )
    for view in self.ViewList.keys():  self.DrawSelection(view)
    self.NotifySelection()


  def PressMotion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Motion(pos)


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    if self.Selection=={}: return    
    pos=self.Selection["BoundingRect"][0]
    (x,y)=pos
    (xmin,xmax)= view.GetXAxis()
    (ymin,ymax)= view.GetYAxis()
    x=min((max((x,xmin)),xmax))
    y=min((max((y,ymin)),ymax))
    if "SelectDrawV" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDrawV"]=view.Drawable.PutLine(x,ymin, x, ymax,self.Pen)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDrawV"], x, ymin, x, ymax)
    if "SelectDrawH" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDrawH"]=view.Drawable.PutLine(xmin, y, xmax, y,self.Pen)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDrawH"], xmin, y, xmax, y)


  def EraseSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    for i in ["SelectDrawV","SelectDrawH"]:
      if i in self.ViewList[view].keys():
        view.Drawable.EraseObject(self.ViewList[view][i])
        del self.ViewList[view][i]


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "Crosshairs"



class GraphViewSelectVerticalCursor(ViewSelectDefault):
  """
  Implemets a crosshair selection - continous event generation + 2 orthogonal lines
  """
  
  def __init__(self,data=None,callback=None,symbol="circle"):
    """
    Virtual: See ViewSelect
    """
    ViewSelect.__init__(self,data,callback)
    self.Pen=Pen((0,0,0),0,"dotted")
    self.symbol=symbol
    self.Symbols=[]

    
  def Motion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Selection["Position"]=pos
    self.Selection["BoundingRect"]=((pos.DataCoord[0], pos.DataCoord[1]), (pos.DataCoord[0], pos.DataCoord[1]))
    for view in self.ViewList.keys():  self.DrawSelection(view)
    self.NotifySelection()


  def PressMotion(self,pos):
    """
    Virtual: See ViewSelect
    """
    self.Motion(pos)


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    pos=self.Selection["BoundingRect"][0]
    (ymin,ymax)= view.GetYAxis()
    if "SelectDrawV" not in self.ViewList[view].keys():
        self.ViewList[view]["SelectDrawV"]=view.Drawable.PutLine(pos[0], ymin, pos[0], ymax,self.Pen)
    else:
        view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDrawV"], pos[0], ymin, pos[0], ymax)

    for obj in self.Symbols: view.Drawable.EraseObject(obj)
    self.Symbols=[]
     
    for (name,(x,y)) in view.GetPositionValues(pos):
      scale=view.Drawable.functions[name]["yscale"]
      self.Symbols.append(view.Drawable.PutSymbol(x,y,symbol=self.symbol,yscale=scale))


  def EraseSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    if "SelectDrawV" in self.ViewList[view].keys():
      view.Drawable.EraseObject(self.ViewList[view]["SelectDrawV"])
      del self.ViewList[view]["SelectDrawV"]
    for obj in self.Symbols: view.Drawable.EraseObject(obj)
    self.Symbols=[]


  def GetType(self):
    """
    Virtual: See ViewSelect
    """
    return "VerticalCursor"



