"""
    PyDisSPS.py
    PyDis plugin to SPS - Spec Shared Merory 
"""
from PyDisWindow import *

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'

try:
    import sps
    import PyDVT.SPSData as SPSData
    found_sps=1
except:
    found_sps=0
    


class PyDisSPSPlugin(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnStartInit (self):
        if found_sps== 0: return 0
        return 1

    def OnInitMenuBar (self,menu_bar):
        self.menuSpec = qt.QPopupMenu(menu_bar)
        menu_bar.insertItem('&Spec',self.menuSpec)
        menu_bar.connect(self.menuSpec,qt.SIGNAL("aboutToShow()"),self.slotMenuSpecAboutToShow)
        
    def OnFinishInit (self,app_window):
        self.app_window=app_window
                
    def GetInfoString(self):
        return "v"+__version__

    ########################################################
    ### Private methods
    ########################################################

    def slotMenuSpecAboutToShow(self):
        self.menuSpec.clear()
        speclist=sps.getspeclist()
        if len(speclist):
            for i in speclist:
                menu = qt.QPopupMenu(self.menuSpec)
                self.menuSpec.insertItem(i,menu)
                self.menuSpec.connect(self.menuSpec,qt.SIGNAL("highlighted(int)"),self.onMenuSpecName)
                for j in sps.getarraylist(i):
                    menu.insertItem(j,self.onMenuArrayName)
        else:
            self.menuSpec.setItemEnabled (self.menuSpec.insertItem("No Spec Available",None),0)            


    def onMenuSpecName(self,i):
        self.specname=string.strip(str(self.menuSpec.text(i)))


    def onMenuArrayName(self,i):
        arrayname= string.strip(str(self.menuSpec.text(i)))
        self.loadSpec(self.specname,arrayname)     


    def loadSpec(self,specname,arrayname):
        try:        
            window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,"Spec - %s - %s" % (specname,arrayname),{"SelectionCallback":self.app_window.EventSelection,"UseColormapWidget":1})
            window.Data=SPSData.SPSData(refresh_interval=100)
            window.Data.SetSource(specname)
            window.Data.LoadSource(arrayname)
            window.DataSelection=DataSelection.RectSelection(window.Data)
            window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
            window.View.SetSource(window.Filter)
            window.View.GetPopupMenu().insertSeparator(window.View.GetPopupMenu().count()-1)
            self.app_window.Set2DViewMenu(window)
        except:
            try:
                window.close()
            except:
                pass
            self.app_window.statusBar().message('Error loading spec array',4000)

plugin=PyDisSPSPlugin()