"""
    DemoSPSTk.py
    Demo application - image displaying of SPS Shared Array - Tkinter GUI
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import Tkinter
import sys
from PyDVT.SPSData import SPSData
from PyDVT.ExtendedImageView import ExtendedImageView,ColormapFilter
from PyDVT.DataSelection import RectSelection
                    
try:
    root = Tkinter.Tk()

    data=SPSData(refresh_interval=100)
    view = ExtendedImageView(root,{"AddSelection":0})        
    view.SetSource(ColormapFilter(None,RectSelection(data)))        
    data.SetSource(sys.argv[1])
    data.LoadSource(sys.argv[2])
    view.Show()

    root.mainloop()
except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoSPSTk <Spec Name> <Array Name>"
    



