"""
    DemoPolygonViewSelectQt.py
    Sample application - creating a custom ViewSelect object
    (Stole this class from Anne Cecile Gendrin)

    Contact: Alexandre Gobbo (gobbo@esrf.fr)        
"""

import sys
import qt
from PyDVT.ImageView import *
from PyDVT.ImageViewSelect import *



class ViewSelectPolygon(ViewSelect):
    """
    Select a polygon
    """ 
    def __init__(self,data=None,callback=None):
        self.polygon=[]
        self.graphical_objects={}
        ViewSelect.__init__(self,data,callback)


    def Motion(self,pos):
        """
        Virtual: See ViewSelect
        """
        mouse_position=pos.DataCoord
        for view in self.GetViewList():   self.DrawTemp(view,mouse_position)


    def DoubleClick(self,pos):
        """
        Virtual: See ViewSelect
        """        
        if len(self.polygon)>2:
            self.polygon.append(self.polygon[0])
            self.SetSelection({"Polygon":self.polygon})
        else:
            self.RemoveSelection()


    def Press(self,pos):
        """
        Virtual: See ViewSelect
        """
        if self.GetSelection() != {}:
            self.RemoveSelection()
        self.polygon.append(pos.DataCoord)
        for view in self.GetViewList(): self.DrawView(view)
        

    def KeyPress(self,key,flags):
        """
        Virtual: See ViewSelect
        """
        if self.GetSelection() == {}: return
        polygon = self.GetSelection()["Polygon"]
        new_polygon=[]
        for point in polygon:
            if key==KeyCodes["KEY_UP"]:
                new_polygon.append(DataPosition(point.PageIndex,(point.PageCoord[0],point.PageCoord[1]-1)))
            elif key==KeyCodes["KEY_DOWN"]:
                new_polygon.append(DataPosition(point.PageIndex,(point.PageCoord[0],point.PageCoord[1]+1)))
            elif key==KeyCodes["KEY_LEFT"]:
                new_polygon.append(DataPosition(point.PageIndex,(point.PageCoord[0]-1,point.PageCoord[1])))
            elif key==KeyCodes["KEY_RIGHT"]:
                new_polygon.append(DataPosition(point.PageIndex,(point.PageCoord[0]+1,point.PageCoord[1])))
            else:
                return
        for point in new_polygon:
            if self.Data.IsCoordValid(point)==0: return
        self.polygon=new_polygon
        self.SetSelection({"Polygon":new_polygon})



    def DrawView(self,view):
        if len(self.polygon)>1:
            if view not in self.graphical_objects.keys(): self.graphical_objects[view]={}
            for i in range (len(self.polygon)-1 ):
                start=view.DataCoord2ImageCoord(self.polygon[i])
                end= view.DataCoord2ImageCoord(self.polygon[i+1])
                if i not in self.graphical_objects[view].keys():
                    self.graphical_objects[view][i]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
                else:
                    view.Drawable.SetObjectCoords(self.graphical_objects[view][i], start[0], start[1], end[0], end[1])


    def EraseView(self,view):
        if view in self.graphical_objects.keys():
            for name in self.graphical_objects[view].keys():
                view.Drawable.EraseObject(self.graphical_objects[view][name])
                del self.graphical_objects[view][name]


    def DrawTemp(self,view,mouse_position):
        """
        Virtual: See ViewSelectDefault
        """
        if self.GetSelection()!={}: return
        if len(self.polygon):
            if view not in self.graphical_objects.keys(): self.graphical_objects[view]={}
            start=view.DataCoord2ImageCoord(self.polygon[-1])
            end=  view.DataCoord2ImageCoord(mouse_position)
            if "TempDraw" not in self.graphical_objects[view].keys():
                self.graphical_objects[view]["TempDraw"]=view.Drawable.PutLine(start[0], start[1], end[0], end[1],self.Pen)
            else:
                view.Drawable.SetObjectCoords(self.graphical_objects[view]["TempDraw"], start[0], start[1], end[0], end[1])


    def RemoveSelection(self):
        ViewSelect.RemoveSelection(self)
        self.polygon=[]
        self.graphical_objects={}
    

    def GetType(self):
        """
        Virtual: See ViewSelect
        """
        return "Polygon"




def EventSelection(source):
    selection = source.GetSelection()
    polygon = selection["Polygon"]
    print "-------------"
    print "Selection: ",source.GetType()
    for point in polygon: print point.PageCoord

def MouseEnabled():
    if view.GetPopupMenu().IsItemChecked(mouse_enabled_menu):
        view.GetPopupMenu().CheckItem(mouse_enabled_menu,0)
        view_select.Disable()
    else:
        view.GetPopupMenu().CheckItem(mouse_enabled_menu,1)
        view_select.Enable()

def KeyboardEnabled():
    if view.GetPopupMenu().IsItemChecked(key_enabled_menu):
        view.GetPopupMenu().CheckItem(key_enabled_menu,0)
        view_select.DisableKeyboard()
    else:
        view.GetPopupMenu().CheckItem(key_enabled_menu,1)
        view_select.EnableKeyboard()

def ChangePen():
    view_select.SetPen(Pen((255,0,255),4,"dotted"))
    view_select.Update()
    

root = qt.QApplication(sys.argv)      
view = ImageView(None,{"ZoomMode":"OFF"})
    
arr = Numeric.zeros ((500,500))
for i in range(500):
  for j in range(500): arr[i][j]= i+j

img=Image(arr)
view.SetSource(img)
view_select=ViewSelectPolygon(img.GetData(),EventSelection)

view.SetSize(500,500)
mouse_enabled_menu=view.AddMenuPopupItem("Mouse Enabled",MouseEnabled,"checkbutton")
key_enabled_menu=view.AddMenuPopupItem("Keyboard Enabled",KeyboardEnabled,"checkbutton")
view.AddMenuPopupItem("Remove Selection",view_select.RemoveSelection)
view.AddMenuPopupItem("Change Pen",ChangePen)
view.GetPopupMenu().CheckItem(mouse_enabled_menu,1)
view.GetPopupMenu().CheckItem(key_enabled_menu,1)
view.Show()    

view_select.ConnectView(view)

root.setMainWidget(view)
root.exec_loop()


