"""
    DemoMeshView.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


import sys
if len (sys.argv)>1 and sys.argv[1]=="Tk":
    import Tkinter
else:
    import qt
from PyDVT.MeshView import *



if "qt" in sys.modules.keys():
    root = qt.QApplication(sys.argv)              
    view = MeshView(None)
else:
    root = Tkinter.Tk()
    view = MeshView(root)

import math    
arr = Numeric.zeros ((100,100))
for i in range(100):
    for j in range(100):   arr[i][j]= (i*(math.sin(float(i)/10.))+j)



view.SetSource(Mesh(arr))
view.SetSize(500,500)
view.Show()

if "qt" in sys.modules.keys():
    root.setMainWidget(view)
    root.exec_loop()
else:        
    root.mainloop()
