"""
    DemoFitMCAQt.py
    Demo application - fitting a specfile MCA
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
from PyDVT.SpecFileData import SpecFileData
from PyDVT.GraphView import GraphView,GraphFilter
from PyDVT.DataSelection import OrthoLineSelection
from PyDVT.FitFilter import FitFilter
from PyDVT.Binding import Pen,FitParametersDialog

    
try:
    filename=sys.argv[1]
    mcaname=sys.argv[2]

    root = qt.QApplication(sys.argv)
    data=SpecFileData()
    data.SetSource(filename)
    data.LoadSource(mcaname)
    sel=OrthoLineSelection(data)
    frame=qt.QSplitter(qt.Qt.Vertical,None)
    ParDlg=FitParametersDialog(frame,None)
    ParDlg.Show()
    fit_filter=FitFilter(sel)
    fit_filter.ConnectParameterEditor(ParDlg)
    fit_filter.SetParameters({"Theory":"Area Gaussians","Mode":"MCA"})
    view = GraphView(frame,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
    view.SetLabels("DemoFit","(x)","(y)")
    view.SetStyle("PointsLine")
    view.SetSource((GraphFilter("G1",sel,pen=Pen((255,0,0),0,"solid")),GraphFilter("G2",fit_filter,pen=Pen((0,255,0),0,"dotted"))))
    frame.resize(500,500)
    view.Show()
    frame.setSizes([126,126])
    frame.show()
    root.setMainWidget(frame)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoFitMCAQt <Spec file name> <MCA key>"

