"""
    DemoCursorQt
    Demo application - Zooming with selection in a small reference image
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.ImageViewSelect as ImageViewSelect
import PyDVT.EdfFileData as EdfFileData
import PyDVT.DataSelection as DataSelection
import PyDVT.Filter as Filter
    


def EventCursorSelection(source):
    sel=source.GetDataSelection()
    view.SetZoom(rect=(sel.Position[0], sel.Position[1], sel.Position[0]+sel.Size[0], sel.Position[1]+sel.Size[1]))


try:
    filename=sys.argv[1]
    index=int(sys.argv[2])

    root = qt.QApplication(sys.argv)  
    view =   ExtendedImageView.ExtendedImageView(None,{"AddSelection":0,"AddReduc":0,"AddCursorSelect":0,"ZoomMode":"OFF","ScrollMode":"OFF"})    
    cursor = ImageView.ImageView(None,{"ZoomMode":"FIT_TO_SCREEN","ScrollMode":"OFF"})    
    data=EdfFileData.EdfFileData()
    data.SetSource(filename)
    data.LoadSource(index) ,
    filter=Filter.Filter(ImageView.ColormapFilter(None,DataSelection.RectSelection(data)),buffer_input=1)
    view.SetSource(filter)
    select=ImageViewSelect.ImageViewSelectRect(data,EventCursorSelection)
    select.ConnectView(cursor)

    view.resize(500,500)
    view.Show()
    cursor.resize(200,200)
    cursor.setSizePolicy(qt.QSizePolicy(0,0))
    cursor.Show()
    cursor.SetSource(filter)            
    root.setMainWidget(view)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoCursorQt <Edf File Name> <index>"
