"""
    DemoContourView.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""


import sys
if len (sys.argv)>1 and sys.argv[1]=="Tk":
    import Tkinter
else:
    import qt
from PyDVT.ContourView import *
import math    


if "qt" in sys.modules.keys():
    root = qt.QApplication(sys.argv)              
    view = ContourView(None)
else:
    root = Tkinter.Tk()
    view = ContourView(root)

arr = Numeric.zeros ((200,100))
for i in range(200):
    for j in range(100):   arr[i][j]= (i*(math.sin(float(i)/10.))+j)
view.SetSource(Contour(arr))
view.SetSize(500,500)
view.Show()    

if "qt" in sys.modules.keys():
    root.setMainWidget(view)
    root.exec_loop()
else:
    root.mainloop()
