###########################################################
#
# CVS Id:       $Id: node.py,v 1.1 2002/06/19 15:02:44 svensson Exp $
#
# File:         node.py
#
# Package:      scisoft/python/scidxp
#
# Author:       Olof Svensson (May 2002)
#
# Description:  This module contains various classes
#               for the scidxp package, most notably
#               the event classes.
#
# Change log, most recent first:
#
# Update 19/06/2002 O Svensson (svensson@esrf.fr)
#                   Committed file to CVS repository
#
#


class Array:

  CHAR    = 1
  INT8    = 2
  INT16   = 3
  INT32   = 4
  INT64   = 5
  FLOAT32 = 6
  FLOAT64 = 7

  def getRank(self):
    raise NotImplementedError

  def getExtends(self):
    raise NotImplementedError

  def getExtend(self, dim):
    raise NotImplementedError

  def getDataCount(self):
    raise NotImplementedError

  def getDataType(self):
    raise NotImplementedError

  def getData(self):
    raise NotImplementedError

  def getDataSlab(self, first, last):
    raise NotImplementedError

  def addArrayEventListener(self, arrayEventListener):
    raise NotImplementedError

  def removeArrayEventListener(self, arrayEventListener):
    raise NotImplementedError

  def fireArrayEvent(self, arrayEvent):
    raise NotImplementedError







class ScidxpEvent:

  def __init__(self, node, change, param):
    self._node   = node
    self._change = change
    self._param  = param

  def getChange(self):
    return self._change

  def getParam(self):
    return self._param
  


class ArrayEvent(ScidxpEvent):

  ARRAY_FIRST          = 1
  TYPE_CHANGED         = 1
  SHAPE_CHANGED        = 2
  DATA_CHANGED         = 3
  STRUCTURE_CHANGED    = 4
  ARRAY_LAST           = 4
  



class NodeEvent(ScidxpEvent):

  NODE_CHANGE_FIRST  = 1
  NAME_CHANGED       = 1
  ATTRIBUTE_CHANGED  = 2
  CHILD_CHANGED      = 3
  DATA_CHANGED       = 4
  STRUCTURE_CHANGED  = 5
  NODE_DISPOSED      = 6
  NODE_CHANGE_LAST   = 6
  

class ArrayChangeSupport:

  def __init__(self, array):
    self._array = array
    self._arrayChangeListeners = []

  def addArrayEventListener(self, arrayChangeListener):
    self._arrayChangeListeners.append(arrayChangeListener)

  def removeArrayEventListener(self, arrayChangeListener):
    if arrayChangeListener in self._arrayChangeListeners:
      self._arrayChangeListeners.remove(arrayChangeListener)

  def fireArrayEvent(self, arrayEvent):
    for arrayChangeListener in self._arrayChangeListeners:    
      if arrayEvent.getChange() == ArrayEvent.TYPE_CHANGED:
        try:
          arrayChangeListener.typeChanged(arrayEvent)
        except:
          print "ERROR when firing type changed for listener ", arrayChangeListener
          #raise
      elif arrayEvent.getChange() == ArrayEvent.SHAPE_CHANGED:
        try:
          arrayChangeListener.shapeChanged(arrayEvent)
        except:
          print "ERROR when firing shape changed for listener ", arrayChangeListener
          #raise
      elif arrayEvent.getChange() == ArrayEvent.DATA_CHANGED:
        try:
          arrayChangeListener.dataChanged(arrayEvent)
        except:
          print "ERROR when firing data changed for listener ", arrayChangeListener
          #raise
      elif arrayEvent.getChange() == ArrayEvent.STRUCTURE_CHANGED:
        try:
          arrayChangeListener.structureChanged(arrayEvent)
        except:
          print "ERROR when firing array changed for listener ", arrayChangeListener
          #raise

  def typeChanged(self):
    self.fireArrayEvent(ArrayEvent(self._array, ArrayEvent.TYPE_CHANGED, None))

  def shapeChanged(self):
    self.fireArrayEvent(ArrayEvent(self._array, ArrayEvent.SHAPE_CHANGED, None))
  
  def dataChanged(self):
    self.fireArrayEvent(ArrayEvent(self._array, ArrayEvent.DATA_CHANGED, None))
  
  def structureChanged(self):
    self.fireArrayEvent(ArrayEvent(self._array, ArrayEvent.STRUCTURE_CHANGED, None))
  

  


class NodeChangeSupport:

  def __init__(self, node):
    self._node = node
    self._nodeChangeListeners = []

  def addNodeEventListener(self, nodeListener):
    self._nodeChangeListeners.append(nodeListener)

  def removeNodeEventListener(self, nodeListener):
    if nodeListener in self._nodeListeners:
      self._nodeChangeListeners.remove(nodeListener)

  def fireNodeEvent(self, nodeEvent):
    for nodeListener in self._nodeChangeListeners:    
      if nodeEvent.getChange() == NodeEvent.NAME_CHANGED:
        try:
          nodeListener.nameChanged(nodeEvent)
        except:
          print "ERROR when firing name changed for listener ", nodeListener
          #raise
      elif nodeEvent.getChange() == NodeEvent.ATTRIBUTE_CHANGED:
        try:
          nodeListener.attributeChanged(nodeEvent)
        except:
          print "ERROR when firing attribute changed for listener ", nodeListener
          #raise
      elif nodeEvent.getChange() == NodeEvent.CHILD_CHANGED:
        try:
          nodeListener.childChanged(nodeEvent)
        except:
          print "ERROR when firing child changed for listener ", nodeListener
          #raise
      elif nodeEvent.getChange() == NodeEvent.DATA_CHANGED:
        try:
          nodeListener.dataChanged(nodeEvent)
        except:
          print "ERROR when firing array changed for listener ", nodeListener
          #raise
      elif nodeEvent.getChange() == NodeEvent.STRUCTURE_CHANGED:
        try:
          nodeListener.structureChanged(nodeEvent)
        except:
          print "ERROR when firing structure changed for listener ", nodeListener
          #raise
      elif nodeEvent.getChange() == NodeEvent.NODE_DISPOSED:
        try:
          nodeListener.nodeDisposed(nodeEvent)
        except:
          print "ERROR when firing node disposed for listener ", nodeListener
          #raise

  def nameChanged(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.NAME_CHANGED))

  def attributeChanged(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.ATTRIBUTE_CHANGED))
  
  def childChanged(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.CHILD_CHANGED))
  
  def dataChanged(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.DATA_CHANGED))
  
  def structureChanged(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.STRUCTURE_CHANGED))
  
  def nodeDisposed(self):
    self.fireNodeEvent(NodeEvent(self._node, NodeEvent.NODE_DISPOSED))
  
  
