"""
    DemoTransf2DFilterQt.py
    Demo application -Using 2d transformation filter
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    



import qt    
import sys
import Command
import Numeric

import PyDVT.ContourView as ContourView
import PyDVT.MeshView as MeshView
import PyDVT.TableView as TableView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.Data as Data
import PyDVT.DataSelection as DataSelection
from PyDVT.Transf2DFilter import *


def ChangeFilter(transformation):
    global transf_filter
    transf_filter.SetTransformation(transformation,1)



try:   viewtype=sys.argv[1]
except:viewtype="Image"
if viewtype not in ("Image" , "Contour", "Table", "Mesh"):viewtype="Image"


root = qt.QApplication(sys.argv)  
if viewtype=="Mesh": view = MeshView.MeshView(None)
elif viewtype=="Table": view = TableView.TableView(None)
elif viewtype=="Image": view = ExtendedImageView.ExtendedImageView(None,{"AddLockPosition":1,"AddCursorSelect":1})
elif viewtype=="Contour": view = ContourView.ContourView(None)
else:raise "Usage: DemoTransf2DFilter <Image , Contour, Table or Mesh>"


y,x=200,100

import math    
arr = Numeric.zeros ((y,x))
for i in range(y):
    for j in range(x):   arr[i][j]= (i*(math.sin(float(i)/10.))+j)

view.AddMenuSeparator()


for op in ('Normal','Transpose','FlipY','FlipX','FlipXY','Rotate90','Rotate180','Rotate270'):
    item=view.AddMenuPopupItem(op,Command.Command(ChangeFilter, op) )
    #If MeshView disables all operations that generate axis in decreasing order:
    #MeshView has to get xdata and ydata always increasing
    if viewtype=="Mesh" and op not in ('Normal','Transpose'): view.DisableMenuItem(item)
        
        



if viewtype=="Image":
    data=Data.Data()
    data.AppendPage({},arr)
    transf_filter=Transf2DFilter(DataSelection.RectSelection(data))
    colormap_filter=ExtendedImageView.ColormapFilter(None,transf_filter)
    view.SetSource(colormap_filter)
else:

    if viewtype=="Mesh": transf_filter=Transf2DFilter(MeshView.Mesh(arr))
    elif viewtype=="Table": transf_filter=Transf2DFilter(TableView.Table(arr))
    elif viewtype=="Contour": transf_filter=Transf2DFilter(ContourView.Contour(arr))
    view.SetSource(transf_filter)
    

view.SetSize(500,500)
view.Show()
root.setMainWidget(view)
root.exec_loop()


