"""
    DemoSaveROIQt.py
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    
"""
import sys
from qt import *
from PyDVT.ExtendedImageView import *
from PyDVT.ImageViewSelect import *
from PyDVT.EdfFileData import *

                    

def EventSelect(source):
    return


def Save():
    global select,colormap_filter
    ROI_View=ExtendedImageView(None)
    sel= select.GetDataSelection()
    if sel==None:
        print "No ROI selected"
        return
    ROI_filter=ColormapFilter(None,select.GetDataSelection())        
    ColormapPars=colormap_filter.GetColormapParameters()
    ColormapPars["AutoScale"]=0
    ROI_filter.SetColormapParameters(ColormapPars)
    ROI_View.SetSource(ROI_filter)
    ROI_View.Save (sys.argv[3],"BMP")
    ROI_View.Destroy()
    print "Created: " , sys.argv[3],"BMP" 


def DefineROI():
    global data, select       
    select.ConnectView(view)

def EraseROI():
    select.RemoveSelection()
    select.DisconnectView(view)
    


try:
    app = QApplication(sys.argv)
    data=EdfFileData()
    view = ExtendedImageView(None,{"ScrollMode": "OFF","ZoomMode": "OFF","AddSelection":0,"AddCursorSelect":0,"AddReduc":0})            
    data.SetSource(sys.argv[1])
    colormap_filter=ColormapFilter(None,RectSelection(data))
    view.SetSource(colormap_filter)
    data.LoadSource(sys.argv[2])

    select=ImageViewSelectRect(data,EventSelect)
    select.SetPen(Pen((0,0,0),3,"solid"))
    select.SetBrush(Brush((0,0,0),"fill_0"))

    view.AddMenuSeparator()
    view.AddMenuPopupItem("Set ROI",DefineROI)
    view.AddMenuPopupItem("Erase ROI",EraseROI)
    view.AddMenuPopupItem("Save ROI",Save)

    app.setMainWidget(view)
    view.SetSize(600,400)
    view.Show()
    app.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoSaveROI <input file> <index> <output file>"
    



