"""
    DemoSaveAsQt.py
    Demo application to create a SaveAs dialog on qt, using view's supported formats

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""
import qt
import sys
import string
import Numeric
import Command
from PyDVT.ExtendedImageView import ExtendedImageView,Image
      

def SaveAs(view):
    filter=""
    for fmt in view.GetSaveFormats():
        filter=filter+"%s files (*.%s);;" % (fmt,string.lower(fmt))
    if filter=="":
        qt.QMessageBox.warning(None,'Save',"No file format supported by view object")
        return
    if qt.qVersion()>="3.0.0":
        selected=qt.QString()
        fn = qt.QFileDialog.getSaveFileName(qt.QString.null,filter,view,None,qt.QString.null,selected)
    else:
        dlg=qt.QFileDialog(qt.QString.null,filter,view,None,1)
        dlg.setCaption("Save As")
        dlg.show()            
        fn=dlg.selectedFile()
        selected=dlg.selectedFilter()
    if fn.isEmpty(): return None
    filename = str(fn)
    format=string.upper(str(selected)[-4:-1])
    if format==".PS":format="PS"
    if view.Save(filename,format): return (filename,format)
    return None
        

    
root = qt.QApplication(sys.argv)      
view = ExtendedImageView(None)  
arr = Numeric.zeros ((200,200))
for i in range(200):
  for j in range(200): arr[i][j]= i+j
view.SetSource(Image(arr))
view.SetSize(500,500)
view.AddMenuPopupItem("Save As",Command.Command(SaveAs, view))
view.Show()

root.setMainWidget(view)
root.exec_loop()




