"""
    DemoSPSGraphQt.py
    Demo application - graph displaying of SPS Shared Array - PyQt GUI
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
import Numeric

from PyDVT.SPSData import SPSData
from PyDVT.GraphView import GraphView,GraphFilter
from PyDVT.DataSelection import XYOrthoLineSelection
from PyDVT.Binding import Pen





try:
    specname=sys.argv[1]
    arrayname=sys.argv[2]
    coly=int(sys.argv[3])
    colx=int(sys.argv[4])

    root = qt.QApplication(sys.argv)

    data=SPSData(refresh_interval=100)
    data.SetSource(specname)

    #OPTION 1: TO LOAD TWO COLUMS (X,Y) IN TWO DIFFERENT PAGES
    data.LoadSource(arrayname,col=coly)
    data.LoadSource(arrayname,col=colx,append=1)
    sel=XYOrthoLineSelection(data,page=0,xpage=1)
    #OPTION 2: TO LOAD THE FULL ARRAY IN ONE PAGE, AND THE SELECTION OBJECT IDENTIFIES X AND Y COLUMNS
    #data.LoadSource(arrayname)
    #sel=XYOrthoLineSelection(data,position=(coly,0),size=(1,"ALL"),xposition=(colx,0),xsize=(1,"ALL"))

    view = GraphView(None,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
    view.SetLabels("DemoSPSGraph","(x)","(y)")
    view.SetSource(GraphFilter("G1",sel,pen=Pen((255,0,0),0,"dotted")))
    view.resize(500,500)
    view.Show()

    root.setMainWidget(view)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoSPSGraphQt <Spec Name> <Array Name> <col y> <col x>"


