"""
    DemoOperatorQt.py
    Demo application - use of operator class to subtract a background image
                       on Spec shared memory arrays
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
from PyDVT.SPSData import SPSData
from PyDVT.ExtendedImageView import ExtendedImageView,ColormapFilter
from PyDVT.DataSelection import RectSelection
from PyDVT.Operator import Operator
from PyDVT.Data import DataPosition



class SubOperator(Operator):
    def GetOutput(self):
        try:
                arr1=self.GetInput(0)["data"]
                arr2=self.GetInput(1)["data"]
                data=arr1-arr2
                return {"data":data}
        except:
           return {} 



def ShowMesh():
    global operator,data
    import MeshView
    import Binding
    meshview=MeshView.MeshView(None)
    meshview.SetSource((MeshView.MeshFilter(None,operator,pen=Binding.Pen((255,0,0),1,"solid")),MeshView.MeshFilter(None,RectSelection(data,page=0),pen=Binding.Pen((0,255,0),1,"solid")),MeshView.MeshFilter(None,RectSelection(data,page=1),pen=Binding.Pen((0,0,255),1,"solid"))))
    meshview.resize(500,500)
    meshview.Show()

    
def ShowContour():
    global operator,data
    import ContourView
    contourview=ContourView.ContourView(None)
    contourview.SetSource(ContourView.ContourFilter(None,operator))
    contourview.resize(500,500)
    contourview.Show()
    

try:
    specname=sys.argv[1]
    image=sys.argv[2]
    background=sys.argv[3]
    root = qt.QApplication(sys.argv)
    data=SPSData(refresh_interval=100)
    view = ExtendedImageView(None,{"UseImageValues":1,"AddSelection":0,"AddOnLine":1,"AddLockPosition":1,"AddRefresh":1})

    data.SetSource(specname)
    data.LoadSource(image)
    data.LoadSource(background,append=1)

    operator=SubOperator((RectSelection(data,page=0),RectSelection(data,page=1)))
    view.SetSource(ColormapFilter(None,operator))
    view.AddMenuSeparator()
    view.AddMenuPopupItem("Contour",ShowContour)
    view.AddMenuPopupItem("Mesh",ShowMesh)


    view.resize(500,500)
    view.Show()
    root.setMainWidget(view)
    root.exec_loop()

except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoOperator <Spec Name> <Image> <Background>"


