"""
    DemoMultipleTk.py
    Demo application - Depth Point selection
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
    

    Interface:
    ===========================
"""


from Tkinter import *
from PyDVT.ExtendedImageView import *
from PyDVT.EdfFileData import *
from PyDVT.GraphView import *
from PyDVT.DataSelection import *




def PointSelection(source):
    pos=source.GetSelection()["BoundingRect"][0]
    graph.SetSource(GraphFilter("",DataSelection(data,pos.PageCoord,(1,1),"ALL",1),pen=Pen((255,0,0),2,"normal")))           

def PageSelect(page):
    view.SetSource(ColormapFilter(None,RectSelection(data,page=page)))
    root.title("DemoMult" + " - " + sys.argv[1] + " - Image: " + ("%d" % (page+1)))

try:
    filename=sys.argv[1]
    root = Tk()

    data=EdfFileData()
    view = ExtendedImageView(root,{"AddSelection":0})
    view.LockPosition(1)
    data.SetSource(filename)    
    data.LoadSource()
    PageSelect(0)
    view.AddMenuSeparator()    
    for i in data.GetSourceInfo()["KeyList"]: view.AddMenuPopupItem("Image "+str(i+1),Command.Command(PageSelect, i),"radiobutton")
    view.GetPopupMenu().SetCheckedRadio("Image 1")
    graph=GraphView(root,{"AddStyleSelect":1,"AddStatus":1,"AutoHideStatus":1,"AddCursorSelect":1})    
    select=ImageViewSelect.ImageViewSelectPoint(data,PointSelection)
    select.ConnectView(view)

    view.pack(side=TOP,fill=BOTH,expand=YES)
    graph.pack(side=BOTTOM,fill=BOTH,expand=YES)
    root.mainloop()
except:
    import traceback
    traceback.print_exc()
    print "Usage: DemoMultipleTk <filename>"
    



