"""
    DemoGraphView.py

    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""

import sys

if len (sys.argv)>1 and sys.argv[1]=="Tk":
    import Tkinter
else:
    import qt
from PyDVT.GraphView import *



def cmd():
    global arr1,view
    Numeric.multiply(arr1,2,arr1)
    view.DataChanged()
    
def fix():
    global view
    view.SetXAxis((-1000.,1000.))
    view.SetYAxis((0.,4000.))
    view.DataChanged()
                                        
def add():
    global view,arr1,arr2,arr3
    view.SetY2Axis((0,1))
    view.SetLabels(y2_label="(y2)")
    view.SetSource((Graph(arr1,pen=Pen((0,0,255),3,"solid")),Graph(arr2,pen=Pen((0,255,0),3,"solid")),Graph(arr3,xdata=x,yscale=1,pen=Pen((255,0,0),3,"dotted"))))
    
    

def save():
    view.Save("out.bmp","BMP")

if "qt" in sys.modules.keys():
    root = qt.QApplication(sys.argv)      
    view = GraphView(None,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1})
else:
    root = Tkinter.Tk()
    view = GraphView(root,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1})

arr1 = Numeric.zeros ((500,))
arr2 = Numeric.zeros ((500,))
arr3 = Numeric.zeros ((500,),'float')
for i in range(500):
    arr1[i]= i
    arr2[i]= i*(1.1)
    arr3[i]= float(i)/500.
x=Numeric.arrayrange(500)
x=(x-250.)*2.

view.SetSource((Graph(arr1,pen=Pen((0,0,255),3,"solid")),Graph(arr2,pen=Pen((0,255,0),3,"solid"))))

view.AddMenuSeparator()
view.AddMenuPopupItem("Change",cmd)
view.AddMenuPopupItem("Fix Axis",fix)
view.AddMenuPopupItem("Add Y2 Function",add)
view.AddMenuPopupItem("Save (out.bmp)",save)
view.SetLabels("Demo GraphView","(x)","(y)")
view.SetSize(500,500)
view.Show()    

if "qt" in sys.modules.keys():
    root.setMainWidget(view)
    root.exec_loop()
else:
    root.mainloop()

