"""
    DemoFilterQt.py
    Demo application -How to cascade filter to image
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import sys
import qt    
import Command
import Numeric
from PyDVT.Filter import *
import PyDVT.ExtendedImageView as ExtendedImageView

class MyFilter(Filter):
    def GetOutput(self):
        sel=self.GetInput()
        if "image" not in sel.keys(): return {}
        
        oldimgstr=sel["image"]
        sizex=sel["size"][0]
        sizey=sel["size"][1]
        img=Numeric.reshape(Numeric.fromstring(oldimgstr),(sizey,sizex))

        for i in range(sizex):
            for j in range(sizey):
                R=img[j][i] & 0xFF
                G=(img[j][i] & 0xFF00)/0x100
                B=(img[j][i] & 0xFF0000)/0x10000
                R=int(R*self.R)
                G=int(G*self.G)
                B=int(B*self.B)
                img[j][i]=R | (G*0x100) | (B*0x10000)

        newimgstr=img.tostring()
        sel["image"]=newimgstr
        return sel
        

    def SetParameters(self,R,G,B):
        self.R,self.G,self.B=R,G,B
        
        



def ChangeFilter(R,G,B):
    global filter
    filter.SetParameters(R,G,B)
    filter.Refresh()
    

root = qt.QApplication(sys.argv)  
view = ExtendedImageView.ExtendedImageView(None,{"AddSelection":0})    
    
arr = Numeric.zeros ((200,300))
for i in range(200):
  for j in range(300): arr[i][j]= i+j

view.AddMenuSeparator()
view.AddMenuPopupItem('Filter None',Command.Command(ChangeFilter, 1.,1.,1.) )
view.AddMenuPopupItem('Filter Red',Command.Command(ChangeFilter, 1.,1.,0.) )
view.AddMenuPopupItem('Filter Blue', Command.Command(ChangeFilter, 0.,1.,1.))
view.AddMenuPopupItem('Filter Green', Command.Command(ChangeFilter, 1.,0.,1.))
view.AddMenuPopupItem('Filter 50%', Command.Command(ChangeFilter, 0.5,0.5,0.5))

filter=MyFilter(ExtendedImageView.Image(arr))
filter.SetParameters(1.,1.,1.)
view.SetSource(filter)

view.Show()
root.setMainWidget(view)
root.exec_loop()